/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.constants;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.Property;
import com.filenet.api.security.Realm;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SpecialPrincipal
implements Serializable {
    private String value;
    private static Map<String, SpecialPrincipal> principals = new HashMap<String, SpecialPrincipal>();
    protected static final String AUTHENTICATED_USERS_STRING = "#AUTHENTICATED-USERS";
    protected static final String CREATOR_OWNER_STRING = "#CREATOR-OWNER";
    protected static final String REALM_USERS_STRING = "#REALM-USERS";
    public static final SpecialPrincipal AUTHENTICATED_USERS = new SpecialPrincipal("#AUTHENTICATED-USERS");
    public static final SpecialPrincipal CREATOR_OWNER = new SpecialPrincipal("#CREATOR-OWNER");
    private static final long serialVersionUID = -4846791583317622767L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    private SpecialPrincipal(String val) {
        this.value = val;
    }

    public String getValue() {
        return this.value;
    }

    public static SpecialPrincipal getInstanceFromString(String value) {
        if (value == null || value.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "value");
        }
        if (value.charAt(0) != '#') {
            return null;
        }
        if (SpecialPrincipal.isAuthenticatedUsers(value)) {
            return AUTHENTICATED_USERS;
        }
        if (SpecialPrincipal.isCreatorOwner(value)) {
            return CREATOR_OWNER;
        }
        String realmUsersArg = SpecialPrincipal.parseRealmUsers(value);
        if (realmUsersArg != null) {
            return SpecialPrincipal.getInstanceWithQualifier(REALM_USERS_STRING, realmUsersArg);
        }
        return null;
    }

    private static synchronized SpecialPrincipal getInstanceWithQualifier(String base, String qualifier) {
        if (base == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "base");
        }
        if (qualifier == null || qualifier.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "qualifier");
        }
        String val = base + '(' + qualifier + ')';
        SpecialPrincipal sp = principals.get(val);
        if (sp == null) {
            sp = new SpecialPrincipal(val);
            principals.put(val, sp);
        }
        return sp;
    }

    public static SpecialPrincipal REALM_USERS(String qualifier) {
        return SpecialPrincipal.getInstanceWithQualifier(REALM_USERS_STRING, qualifier);
    }

    public static SpecialPrincipal REALM_USERS(Realm realm) {
        if (realm == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "realm");
        }
        String name = null;
        Property prop = realm.getProperties().find("SymbolicName");
        name = prop != null ? prop.getStringValue() : realm.getObjectReference().getObjectIdentity();
        return SpecialPrincipal.getInstanceWithQualifier(REALM_USERS_STRING, name);
    }

    public static boolean isAuthenticatedUsers(String principal) {
        return AUTHENTICATED_USERS_STRING.equalsIgnoreCase(principal);
    }

    public static boolean isCreatorOwner(String principal) {
        return CREATOR_OWNER_STRING.equalsIgnoreCase(principal);
    }

    public static boolean isRealmUsers(String principal) {
        return SpecialPrincipal.parseRealmUsers(principal) != null;
    }

    public static String parseRealmUsers(String principal) {
        if (principal == null || !principal.toUpperCase().startsWith(REALM_USERS_STRING)) {
            return null;
        }
        int len0 = REALM_USERS_STRING.length();
        int len1 = principal.length();
        if (len1 - len0 <= 2 || principal.charAt(len0) != '(' || principal.charAt(len1 - 1) != ')') {
            return null;
        }
        return principal.substring(len0 + 1, len1 - 1);
    }

    public String toString() {
        return this.value;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.value);
    }

    private void readObject(ObjectInputStream s) throws Exception {
        this.value = (String)s.readObject();
    }
}

