/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.query;

import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchTemplateParameters;
import com.filenet.api.query.StoredSearch;
import com.filenet.apiimpl.query.RepositorySearch;
import com.filenet.apiimpl.query.RepositoryStoredSearch;
import com.filenet.apiimpl.util.classloader.CRCLHelper;

public final class SearchScope {
    private Object crclDelegate = null;
    private static final String SS_CLASS_NAME = SearchScope.class.getName();
    private static final Class[] types_o = new Class[]{ObjectStore.class};
    private static final Class[] types_om = new Class[]{ObjectStore[].class, MergeMode.class};
    private static final Class[] types_sipb = new Class[]{SearchSQL.class, Integer.class, PropertyFilter.class, Boolean.class};
    private static final Class[] types_sstipb = new Class[]{StoredSearch.class, String.class, SearchTemplateParameters.class, Integer.class, PropertyFilter.class, Boolean.class};
    private static final Class[] types_sp = new Class[]{String[].class, PropertyFilter.class};
    private static final Class[] types_void = new Class[0];
    private ObjectStore[] objectStores = null;
    private MergeMode mergeMode = null;

    public SearchScope(ObjectStore objectStore) {
        this.decideCrclDelegate(objectStore);
        if (this.crclDelegate != null) {
            return;
        }
        this.objectStores = new ObjectStore[1];
        this.objectStores[0] = objectStore;
    }

    public SearchScope(ObjectStore[] objectStores, MergeMode mergeMode) {
        this.decideCrclDelegate(objectStores, mergeMode);
        if (this.crclDelegate != null) {
            return;
        }
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        this.objectStores = (ObjectStore[])objectStores.clone();
        this.mergeMode = mergeMode;
    }

    private void decideCrclDelegate(ObjectStore objectStore) {
        this.crclDelegate = CRCLHelper.constructCRCLdelegateObject(SS_CLASS_NAME, types_o, objectStore);
    }

    private void decideCrclDelegate(ObjectStore[] objectStores2, MergeMode mergeMode2) {
        this.crclDelegate = CRCLHelper.constructCRCLdelegateObject(SS_CLASS_NAME, types_om, objectStores2, mergeMode2);
    }

    public RepositoryRowSet fetchRows(SearchSQL searchSQL, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (this.crclDelegate != null) {
            Object result = CRCLHelper.doCRCLcall(this.crclDelegate, SS_CLASS_NAME, "fetchRows", types_sipb, searchSQL, pageSize, filter, continuable);
            return (RepositoryRowSet)result;
        }
        RepositorySearch rs = new RepositorySearch();
        if (this.objectStores.length > 1) {
            return rs.fetchRows(this.objectStores, searchSQL, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchRows(this.objectStores[0], searchSQL, pageSize, filter, continuable);
    }

    public IndependentObjectSet fetchObjects(SearchSQL searchSQL, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (this.crclDelegate != null) {
            Object result = CRCLHelper.doCRCLcall(this.crclDelegate, SS_CLASS_NAME, "fetchObjects", types_sipb, searchSQL, pageSize, filter, continuable);
            return (IndependentObjectSet)result;
        }
        RepositorySearch rs = new RepositorySearch();
        if (this.objectStores.length > 1) {
            return rs.fetchObjects(this.objectStores, searchSQL, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchObjects(this.objectStores[0], searchSQL, pageSize, filter, continuable);
    }

    public RepositoryRowSet fetchRows(StoredSearch storedSearch, String searchClauseFromClass, SearchTemplateParameters templateData, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (this.crclDelegate != null) {
            Object result = CRCLHelper.doCRCLcall(this.crclDelegate, SS_CLASS_NAME, "fetchRows", types_sstipb, storedSearch, searchClauseFromClass, templateData, pageSize, filter, continuable);
            return (RepositoryRowSet)result;
        }
        RepositoryStoredSearch rs = new RepositoryStoredSearch();
        if (this.objectStores.length > 1) {
            return rs.fetchRows(this.objectStores, storedSearch, searchClauseFromClass, templateData, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchRows(this.objectStores[0], storedSearch, searchClauseFromClass, templateData, pageSize, filter, continuable);
    }

    public IndependentObjectSet fetchObjects(StoredSearch storedSearch, String searchClauseFromClass, SearchTemplateParameters templateData, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (this.crclDelegate != null) {
            Object result = CRCLHelper.doCRCLcall(this.crclDelegate, SS_CLASS_NAME, "fetchObjects", types_sstipb, storedSearch, searchClauseFromClass, templateData, pageSize, filter, continuable);
            return (IndependentObjectSet)result;
        }
        RepositoryStoredSearch rs = new RepositoryStoredSearch();
        if (this.objectStores.length > 1) {
            return rs.fetchObjects(this.objectStores, storedSearch, searchClauseFromClass, templateData, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchObjects(this.objectStores[0], storedSearch, searchClauseFromClass, templateData, pageSize, filter, continuable);
    }

    public ClassDescriptionSet fetchSearchableClassDescriptions(String[] classNames, PropertyFilter filter) {
        if (this.crclDelegate != null) {
            Object result = CRCLHelper.doCRCLcall(this.crclDelegate, SS_CLASS_NAME, "fetchSearchableClassDescriptions", types_sp, classNames, filter);
            return (ClassDescriptionSet)result;
        }
        RepositorySearch rs = new RepositorySearch();
        if (this.objectStores.length > 1) {
            return rs.fetchSearchableClassDescriptions(this.objectStores, this.mergeMode, classNames, filter);
        }
        return rs.fetchSearchableClassDescriptions(this.objectStores[0], classNames, filter);
    }

    public MergeMode getMergeMode() {
        if (this.crclDelegate != null) {
            Object result = CRCLHelper.doCRCLcall(this.crclDelegate, SS_CLASS_NAME, "getMergeMode", types_void, new Object[0]);
            return (MergeMode)result;
        }
        if (this.objectStores != null && this.objectStores.length > 1) {
            return this.mergeMode;
        }
        return MergeMode.UNION;
    }

    public ObjectStore[] getObjectStores() {
        if (this.crclDelegate != null) {
            Object result = CRCLHelper.doCRCLcall(this.crclDelegate, SS_CLASS_NAME, "getObjectStores", types_void, new Object[0]);
            return (ObjectStore[])result;
        }
        return (ObjectStore[])this.objectStores.clone();
    }
}

