/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication;

import com.filenet.apiimpl.authentication.util.J2EEAuthnUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class FnceCallbackHandler
implements CallbackHandler {
    private String name;
    private char[] password;
    private HashMap textValues = new HashMap();

    public FnceCallbackHandler() {
    }

    public FnceCallbackHandler(String name, char[] password) {
        this.name = name;
        this.password = password;
    }

    public FnceCallbackHandler(String name, char[] password, String url) {
        this.name = name;
        this.password = password;
        this.setURL(url);
    }

    public void setText(String text, String prompt) {
        if (text == null || text.length() == 0 || prompt == null || prompt.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.textValues.put(prompt, text);
    }

    public void setSPN(String text) {
        this.setText(text, "SPN");
    }

    public void setURL(String text) {
        this.setText(text, "URL");
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.name);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.password);
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                TextInputCallback tc = (TextInputCallback)callbacks[i];
                String prompt = tc.getPrompt();
                String text = (String)this.textValues.get(prompt);
                if (text == null) {
                    text = tc.getDefaultText();
                }
                tc.setText(text);
                continue;
            }
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                continue;
            }
            J2EEAuthnUtil.getInstance().handleCallback(callbacks[i], this.textValues);
        }
    }
}

