/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.FnceCallbackHandler;
import com.filenet.apiimpl.authentication.util.AuthnUtil;
import com.filenet.apiimpl.authentication.util.J2EEAuthnUtil;
import com.filenet.apiimpl.authentication.util.LmState;
import com.filenet.apiimpl.exception.ExceptionAuthn;
import com.filenet.apiimpl.util.J2EEType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

class J2EEAuthnUtilWS
extends J2EEAuthnUtil {
    private static final String FNAME = "[J2EEAuthnUtilWS] ";
    private static final String[] WS_CALLBACK_PACKAGES = new String[]{"com.ibm.websphere.security.auth.callback", "com.ibm.wsspi.security.auth.callback"};
    private static final int MIN_TIME = 60;
    private static Constructor m_WSTokenHolderCallback;
    private static Method m_WSSubject_doAs;
    private static Method m_WSSubject_doAsEx;
    private static Method m_WSSubject_getCallerSubject;
    private static Method m_WSTokenHolderCallback_getRequiresLogin;
    private static HashMap consts;
    private static final String WSCREDENTIAL_EXPIRATION;
    private static final String WSCREDENTIAL_LONGSECURITYNAME;
    private static final String WSCREDENTIAL_PROPERTIES_KEY;
    private static final String WSCREDENTIAL_SECURITYNAME;
    private static final String WSCREDENTIAL_UNIQUEID;
    private static final String WSCREDENTIAL_CACHE_KEY;
    private static final String WSCREDENTIAL_GROUPS;

    protected J2EEAuthnUtilWS() {
        fname = FNAME;
        this.krb5LoginModuleClass = "com.ibm.security.auth.module.Krb5LoginModule";
        this.krb5NormalClientLoginOptions = new String[]{"credsType=both"};
        this.krb5CachedClientLoginOptions = new String[]{"useDefaultCcache=true"};
        this.krb5ServiceLoginOptions = new String[]{"credsType=acceptor", "useDefaultKeytab=true"};
        this.krb5ServiceLoginOptionsKeytab = new String[]{"credsType=acceptor"};
        this.krb5KeytabOption = "useKeytab";
        this.krb5KeytabPrefix = "FILE:/";
    }

    @Override
    public boolean handleServerCallbacks(LmState state, Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        try {
            int clen = callbacks.length;
            Callback[] newCallbacks = new Callback[clen + 1];
            System.arraycopy(callbacks, 0, newCallbacks, 0, clen);
            newCallbacks[clen] = (Callback)m_WSTokenHolderCallback.newInstance("Authz token: ");
            state.callbackHandler.handle(newCallbacks);
            boolean requiresLogin = (Boolean)m_WSTokenHolderCallback_getRequiresLogin.invoke((Object)newCallbacks[clen], null);
            return requiresLogin;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = (Exception)((InvocationTargetException)e).getCause();
            }
            AuthnUtil.error(fname + "handleServerCallbacks: " + e.getLocalizedMessage());
            if (e instanceof UnsupportedCallbackException) {
                throw (UnsupportedCallbackException)e;
            }
            throw J2EEAuthnUtilWS.processedException(e, this.getClass(), "handleServerCallbacks");
        }
    }

    @Override
    public boolean precommitClientLogin(LmState state, char[] credential) throws LoginException, IOException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (state.isDebug) {
                AuthnUtil.log(fname + "precommit authenticate");
            }
            if (!J2EEType.isInitialContextOk()) {
                AuthnUtil.warn(fname + "InitialContext not okay!");
            }
            FnceCallbackHandler handler = new FnceCallbackHandler(state.shortName, credential);
            LoginContext lc = new LoginContext("FileNetP8", handler);
            lc.login();
            Subject temp = lc.getSubject();
            if (temp == null) {
                AuthnUtil.warn(fname + "precommit authenticate returned null subject");
                throw new FailedLoginException(ExceptionAuthn.SECURITY_SUBJECT_NULL.toString());
            }
            if (state.isDebug) {
                AuthnUtil.log(fname + "precommit ClientContainer login successful");
            }
            state.newPrincipals.addAll(temp.getPrincipals());
            state.newPublicCredentials.addAll(temp.getPublicCredentials());
            state.newPrivateCredentials.addAll(temp.getPrivateCredentials());
            if (state.extraCred != null) {
                state.newPrivateCredentials.add(state.extraCred);
            }
            return true;
        }
        catch (Exception e) {
            AuthnUtil.error(fname + "precommitClientLogin: " + e.getLocalizedMessage());
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilWS.wrappedException(e);
        }
    }

    @Override
    public boolean precommitServerLogin(LmState state) throws LoginException, IOException {
        String longSecurityName;
        String securityName = state.princName;
        String uniqueId = longSecurityName = state.realm + '/' + securityName;
        String cacheKey = uniqueId + "_KerberosUser";
        Hashtable<String, Object> shared = new Hashtable<String, Object>();
        shared.put(WSCREDENTIAL_UNIQUEID, uniqueId);
        shared.put(WSCREDENTIAL_SECURITYNAME, securityName);
        shared.put(WSCREDENTIAL_LONGSECURITYNAME, longSecurityName);
        shared.put(WSCREDENTIAL_GROUPS, new ArrayList());
        shared.put(WSCREDENTIAL_CACHE_KEY, cacheKey);
        if (state.lifetime > 60 && state.lifetime < Integer.MAX_VALUE) {
            long time = new Date().getTime();
            shared.put(WSCREDENTIAL_EXPIRATION, Long.toString(time += (long)((state.lifetime - 60) * 1000)));
        }
        state.sharedState.put(WSCREDENTIAL_PROPERTIES_KEY, shared);
        state.extra = shared;
        if (state.isDebug) {
            StringBuffer buf = new StringBuffer();
            buf.append(fname);
            buf.append("adding key '");
            buf.append(WSCREDENTIAL_PROPERTIES_KEY);
            buf.append("' to shared state with these values...");
            Iterator it = shared.entrySet().iterator();
            while (it.hasNext()) {
                buf.append('\n');
                Map.Entry ent = it.next();
                buf.append("  ");
                buf.append(ent.getKey().toString());
                buf.append(" = ");
                buf.append(ent.getValue().toString());
            }
            AuthnUtil.log(buf.toString());
        }
        if (state.extraCred != null) {
            state.newPrivateCredentials.add(state.extraCred);
        }
        return true;
    }

    @Override
    public boolean precommitLogin(LmState state) throws LoginException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean commitServerLogin(LmState state) {
        if (state.extra != null && state.extra instanceof Hashtable) {
            state.sharedState.remove(WSCREDENTIAL_PROPERTIES_KEY);
            state.extra = null;
        }
        return this.commitLogin(state);
    }

    @Override
    public void cleanupLogin(LmState state) {
        if (state.extra != null && state.extra instanceof Hashtable) {
            state.sharedState.remove(WSCREDENTIAL_PROPERTIES_KEY);
            state.extra = null;
        }
        super.cleanupLogin(state);
    }

    @Override
    public Object runAs(Subject subject, PrivilegedAction action) {
        return J2EEAuthnUtilWS.reflectionCall(m_WSSubject_doAs, null, new Object[]{subject, action});
    }

    @Override
    public Object runAs(Subject subject, PrivilegedExceptionAction action) throws Exception {
        return J2EEAuthnUtilWS.reflectionCall(m_WSSubject_doAsEx, null, new Object[]{subject, action});
    }

    @Override
    public Subject getCurrentSubject() {
        return (Subject)J2EEAuthnUtilWS.reflectionCall(m_WSSubject_getCallerSubject, null, null);
    }

    @Override
    public void handleCallback(Callback callback, Map textValues) throws UnsupportedCallbackException {
        String className = callback.getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot > 0) {
            className = className.substring(0, dot);
        }
        for (int i = 0; i < WS_CALLBACK_PACKAGES.length; ++i) {
            if (!className.equals(WS_CALLBACK_PACKAGES[i])) continue;
            return;
        }
        super.handleCallback(callback, textValues);
    }

    @Override
    public boolean isTicketsSPNToMatchLogins() {
        return true;
    }

    static {
        consts = new HashMap();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> cWSSubject = Class.forName("com.ibm.websphere.security.auth.WSSubject", false, cl);
            Class<?> cWSTokenHolderCallback = Class.forName("com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback", false, cl);
            m_WSSubject_doAs = cWSSubject.getMethod("doAs", Subject.class, PrivilegedAction.class);
            m_WSSubject_doAsEx = cWSSubject.getMethod("doAs", Subject.class, PrivilegedExceptionAction.class);
            m_WSSubject_getCallerSubject = cWSSubject.getMethod("getCallerSubject", null);
            m_WSTokenHolderCallback_getRequiresLogin = cWSTokenHolderCallback.getMethod("getRequiresLogin", null);
            m_WSTokenHolderCallback = cWSTokenHolderCallback.getConstructor(String.class);
            J2EEAuthnUtilWS.fetchStaticConstants(Class.forName("com.ibm.wsspi.security.token.AttributeNameConstants"), consts);
        }
        catch (Exception e) {
            AuthnUtil.error("[J2EEAuthnUtilWS] Failed static initialization: " + e.getLocalizedMessage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilWS.wrappedException(e);
        }
        WSCREDENTIAL_EXPIRATION = (String)consts.get("WSCREDENTIAL_EXPIRATION");
        WSCREDENTIAL_LONGSECURITYNAME = (String)consts.get("WSCREDENTIAL_LONGSECURITYNAME");
        WSCREDENTIAL_PROPERTIES_KEY = (String)consts.get("WSCREDENTIAL_PROPERTIES_KEY");
        WSCREDENTIAL_SECURITYNAME = (String)consts.get("WSCREDENTIAL_SECURITYNAME");
        WSCREDENTIAL_UNIQUEID = (String)consts.get("WSCREDENTIAL_UNIQUEID");
        WSCREDENTIAL_CACHE_KEY = (String)consts.get("WSCREDENTIAL_CACHE_KEY");
        WSCREDENTIAL_GROUPS = (String)consts.get("WSCREDENTIAL_GROUPS");
    }
}

