/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.constants.GuidConstants;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.core.Scope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.constants.Constants;
import com.filenet.apiimpl.core.ClassDescriptionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectFactory;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.meta.SearchScopeIdentity;
import com.filenet.apiimpl.meta.SearchableClassDescription;
import com.filenet.apiimpl.util.ConfigValueLookup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class EngineObjectUtil {
    private static HashMap classNameToJavaClassMap;
    private static HashMap classNameToSuperClassArray;
    private static HashMap classNameToIsSubClassable;
    private static HashMap classNameShortMap;
    static final boolean cheetahBCMode;
    public static final Map domainIdentities;
    public static final PropertyFilter domainFilter;
    private static final Set scopeExclusions;
    private static String[] newClassesSince401;
    private static HashSet<String> recentlyAddedClasses;

    public static ClassDescriptionImpl getClassDescriptionBySearchScope(Connection connection, Id objectId, GlobalIdentity[] objectStores, MergeMode mergeMode) {
        if (objectStores != null && objectStores.length == 1) {
            return (ClassDescriptionImpl)ObjectFactory.getInstance(objectStores[0], connection, "ClassDescription", null, objectId);
        }
        return SearchableClassDescription.getSearchableClassDescriptionInstance(connection, objectId, objectStores, mergeMode);
    }

    public static String getAPIClassName(EngineObjectImpl eo) {
        return EngineObjectUtil.getAPIClassName(eo.getClass());
    }

    public static String getAPIClassName(Class eoClass) {
        return EngineObjectUtil.getAPIClassName(eoClass.getName());
    }

    public static String getAPIClassName(String eoClass) {
        String temp = eoClass;
        int pos = temp.lastIndexOf(".");
        if (pos == -1) {
            return eoClass;
        }
        temp = temp.substring(pos + 1);
        String suffix = "Impl";
        if (temp.length() <= suffix.length()) {
            return temp;
        }
        return !temp.endsWith(suffix) ? temp : temp.substring(0, temp.length() - suffix.length());
    }

    private static String getClassNameShort(String classNameLong) {
        return classNameLong.substring(classNameLong.lastIndexOf(".") + 1);
    }

    private static String getManifestLookupVal(String className) {
        String lookupVal = className.toLowerCase().trim();
        return lookupVal;
    }

    public static String[] getSuperClassNames(String className) {
        if (className == null) {
            return null;
        }
        String lookupVal = EngineObjectUtil.getManifestLookupVal(className);
        return (String[])classNameToSuperClassArray.get(lookupVal);
    }

    private static boolean isSubclassable(String className) {
        if (className == null) {
            return false;
        }
        String lookupVal = EngineObjectUtil.getManifestLookupVal(className);
        Boolean issubclassable = (Boolean)classNameToIsSubClassable.get(lookupVal);
        return issubclassable != null ? issubclassable : false;
    }

    public static boolean isRepositoryObject(String className, String[] superClasses) {
        Class c = EngineObjectUtil.getClassByName(className, superClasses);
        return RepositoryObject.class.isAssignableFrom(c);
    }

    public static boolean isDependentObject(String className, String[] superClasses) {
        Class c = EngineObjectUtil.getClassByName(className, superClasses);
        return !IndependentObject.class.isAssignableFrom(c);
    }

    public static String findRoot(String className, String[] superClassNames) {
        String lookupVal = EngineObjectUtil.getManifestLookupVal(className);
        String shortName = (String)classNameShortMap.get(lookupVal);
        if (shortName != null) {
            return shortName;
        }
        for (int lp = 0; lp < superClassNames.length; ++lp) {
            String lookupVL = EngineObjectUtil.getManifestLookupVal(superClassNames[lp]);
            shortName = (String)classNameShortMap.get(lookupVL);
            if (shortName == null) continue;
            return shortName;
        }
        return null;
    }

    public static Class getClassByName(String className, String[] superClassNames) {
        if (className == null) {
            throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_API_CLASS, "null");
        }
        Class tempClass = EngineObjectUtil.findClassByName(className);
        if (tempClass != null) {
            return tempClass;
        }
        tempClass = EngineObjectUtil.findClassBySuperClassNames(superClassNames);
        if (tempClass != null) {
            return tempClass;
        }
        if (cheetahBCMode) {
            return EngineObjectImpl.class;
        }
        throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_API_CLASS, className);
    }

    static Class findClassByName(String className) {
        if (className == null) {
            return null;
        }
        String lookupVal = EngineObjectUtil.getManifestLookupVal(className);
        return (Class)classNameToJavaClassMap.get(lookupVal);
    }

    static Class findClassBySuperClassNames(String[] superClassNames) {
        if (superClassNames == null || superClassNames.length == 0) {
            return null;
        }
        for (int lp = 0; lp < superClassNames.length; ++lp) {
            String lookupVL = EngineObjectUtil.getManifestLookupVal(superClassNames[lp]);
            Class tempClass = (Class)classNameToJavaClassMap.get(lookupVL);
            if (tempClass != null) {
                return tempClass;
            }
            String lookupSL = EngineObjectUtil.getManifestLookupVal(EngineObjectUtil.getAPIClassName(superClassNames[lp]));
            tempClass = (Class)classNameToJavaClassMap.get(lookupSL);
            if (tempClass == null) continue;
            return tempClass;
        }
        return null;
    }

    public static Scope getScope(ObjectReferenceBase oa, Connection connection) {
        Scope scope = null;
        GlobalIdentity reference = null;
        if (!oa.isObjectStoreReference() && (reference = oa.getObjectStoreReference()) == null && oa instanceof SearchScopeIdentity) {
            return null;
        }
        if (reference != null) {
            scope = (Scope)((Object)ObjectFactory.getInstance(reference, null, connection));
            return scope;
        }
        String scopeId = EngineObjectUtil.scopeId(oa.getClassIdentity());
        if (scopeId == null) {
            return null;
        }
        if ((scopeId.equalsIgnoreCase("ClassDescription") || scopeId.equals(GuidConstants.Class_ClassDescription.toString())) && (scopeId = EngineObjectUtil.scopeId(oa.getObjectIdentity())) == null) {
            return null;
        }
        if (scopeExclusions.contains(scopeId)) {
            return null;
        }
        String uri = connection.getURI();
        if (uri == null) {
            return null;
        }
        String domainIdentity = (String)domainIdentities.get(uri);
        if (domainIdentity == null) {
            Domain domain = Factory.Domain.fetchInstance(connection, null, domainFilter);
            domainIdentity = domain.get_Id().toString();
            domainIdentities.put(uri, domainIdentity);
        }
        scope = Factory.Domain.getInstance(connection, domainIdentity);
        return scope;
    }

    private static String scopeId(String idStr) {
        if (idStr == null) {
            return null;
        }
        Id id = Id.asIdOrNull(idStr);
        if (id != null) {
            return id.toString();
        }
        return idStr.toUpperCase();
    }

    public static boolean isRecentlyAddedClass(String className) {
        return recentlyAddedClasses.contains(className);
    }

    static {
        int classCount = Constants.ClassManifest.length;
        classNameToJavaClassMap = new HashMap(classCount * 4);
        classNameToSuperClassArray = new HashMap(classCount * 4);
        classNameToIsSubClassable = new HashMap(classCount * 4);
        classNameShortMap = new HashMap(classCount * 4);
        for (int i = 0; i < classCount; ++i) {
            String[] scArray;
            String classNameLong = ((Class)Constants.ClassManifest[i][2]).getName().toLowerCase();
            String classNameShort = ((String)Constants.ClassManifest[i][0]).toLowerCase();
            String classGUID = ((String)Constants.ClassManifest[i][1]).toLowerCase();
            String exposedClass = EngineObjectUtil.getAPIClassName(classNameLong);
            if (!classGUID.startsWith("{")) {
                classGUID = "{" + classGUID;
            }
            if (!classGUID.endsWith("}")) {
                classGUID = classGUID + "}";
            }
            classNameToJavaClassMap.put(classNameLong, Constants.ClassManifest[i][2]);
            classNameToJavaClassMap.put(classNameShort, Constants.ClassManifest[i][2]);
            classNameToJavaClassMap.put(classGUID, Constants.ClassManifest[i][2]);
            classNameToJavaClassMap.put(exposedClass, Constants.ClassManifest[i][2]);
            classNameShortMap.put(classNameLong, Constants.ClassManifest[i][0]);
            classNameShortMap.put(classNameShort, Constants.ClassManifest[i][0]);
            classNameShortMap.put(classGUID, Constants.ClassManifest[i][0]);
            classNameShortMap.put(exposedClass, Constants.ClassManifest[i][0]);
            String superClasses = (String)Constants.ClassManifest[i][3];
            String[] stringArray = scArray = superClasses != null ? superClasses.split(",") : null;
            if (scArray != null && scArray.length > 0) {
                for (int lp = 0; lp < scArray.length; ++lp) {
                    scArray[lp] = EngineObjectUtil.getAPIClassName(scArray[lp]);
                }
            }
            classNameToSuperClassArray.put(classNameLong, scArray);
            classNameToSuperClassArray.put(classNameShort, scArray);
            classNameToSuperClassArray.put(classGUID, scArray);
            classNameToSuperClassArray.put(exposedClass, scArray);
            Boolean isSubclassable = Boolean.valueOf((String)Constants.ClassManifest[i][4]);
            classNameToIsSubClassable.put(classNameLong, isSubclassable);
            classNameToIsSubClassable.put(classNameShort, isSubclassable);
            classNameToIsSubClassable.put(classGUID, isSubclassable);
            classNameToIsSubClassable.put(exposedClass, isSubclassable);
        }
        cheetahBCMode = Boolean.valueOf(ConfigValueLookup.getValue("CheetahBCMode", "false"));
        domainIdentities = new Hashtable();
        domainFilter = new PropertyFilter();
        domainFilter.addIncludeProperty(0, null, null, "Id", null);
        scopeExclusions = new HashSet<String>(Arrays.asList("Realm".toUpperCase(), GuidConstants.Class_Realm.toString(), "Domain".toUpperCase(), GuidConstants.Class_Domain.toString(), "EntireNetwork".toUpperCase(), GuidConstants.Class_EntireNetwork.toString()));
        newClassesSince401 = new String[]{"ReplicationConfiguration", "ReplicableClassDefinition", "CMODFixedContentDevice", "DirectoryConfigurationCA", "CmDirectoryConfigurationOID", "CmDirectoryConfigurationDomino", "CmDirectoryConfigurationRadiantOne", "TivoliFixedContentDevice", "CmHitachiFixedContentDevice", "CmTextSearchIndexArea", "CmTextSearchConfiguration", "CmAuditingConfiguration", "CmMoveContentEvent", "CmChangePreprocessorAction", "CmThreadPoolConfiguration", "CmDirectoryConfigurationDomino", "CmQueueEntryClassDefinition", "CmSweepConfiguration", "CmSweepAction", "CmProcessEngineConfiguration", "CmMarkForDeletionEvent", "CmRecoverEvent", "CmDirectoryConfigurationRadiantOne", "CmDirectoryConfigurationVMM", "CmAtmosFixedContentDevice", "CmIndexJobResyncItem", "CmContentMigrationPolicy", "CmCustomSweepPolicy", "CmAdvancedStorageArea", "CmIsilonFixedContentDevice", "CmSMTPConfiguration", "CmSearchFunctionDefinition", "CmContentConversionConfiguration", "CmContentConversionAction", "CmTextIndexingPreprocessorAction", "CmConversionSettingsClassDefinition", "CmDelegatedAccessPermission", "CmRoleClassDefinition", "CmRoleMembershipAction", "CmDependentClassDefinition", "CmICOSFixedContentDevice", "CmContentConsistencyCheckJob", "CmAWSFixedContentDevice", "CmDirectoryConfigurationManaged", "CmAzureBlobStorageDevice", "CmElasticSearchIndexArea", "CmDirectoryConfigurationSCIM", "CmElasticSearchIndexRequest", "CmElasticSearchIndexingSweep"};
        recentlyAddedClasses = new HashSet();
        for (int I = 0; I < newClassesSince401.length; ++I) {
            recentlyAddedClasses.add(newClassesSince401[I]);
        }
    }
}

