/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class GlobalIdentity
extends ObjectReferenceBase {
    private Object identity;
    private static final long serialVersionUID = 5571038870140943306L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_IDENTITY = 2;
    private static final int IS_ID = 4;

    public GlobalIdentity() {
    }

    public GlobalIdentity(String className, Id id) {
        super(className);
        this.identity = id;
    }

    public GlobalIdentity(String className, String name) {
        super(className);
        Id id = Id.asIdOrNull(name);
        this.identity = id != null ? id : name;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("classId=");
        sb.append(this.getClassIdentity());
        sb.append("&objectId=");
        sb.append(this.getObjectIdentity());
        return sb.toString();
    }

    @Override
    public Id getObjectId() {
        if (this.identity instanceof Id) {
            return (Id)this.identity;
        }
        return null;
    }

    public String getName() {
        if (this.identity instanceof String) {
            return (String)this.identity;
        }
        return null;
    }

    public void setObjectId(Id id) {
        this.identity = id;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GlobalIdentity)) {
            return false;
        }
        GlobalIdentity base = (GlobalIdentity)object;
        if (this.identity != null && base.identity == null || base.identity != null && this.identity == null) {
            return false;
        }
        if (this.identity != null && !this.identity.equals(base.identity)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.identity != null ? this.identity.hashCode() : 0);
        result = 37 * result + super.hashCode();
        return result;
    }

    @Override
    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        GlobalIdentity that = (GlobalIdentity)obj;
        if (this.identity != that.identity) {
            if (this.identity == null) {
                return -1;
            }
            if (that.identity == null) {
                return 1;
            }
            if (this.identity instanceof String && that.identity instanceof String || this.identity instanceof Id && that.identity instanceof Id) {
                int cmp = ((Comparable)this.identity).compareTo(that.identity);
                if (cmp != 0) {
                    return cmp;
                }
            } else {
                throw new UnsupportedOperationException("!compareTo " + this.identity + " , " + that.identity);
            }
        }
        return super.compareTo(obj);
    }

    @Override
    public boolean isResolved() {
        return this.identity instanceof Id;
    }

    @Override
    public String getObjectIdentity() {
        return this.identity != null ? this.identity.toString() : null;
    }

    @Override
    public String getObjectStoreIdentity() {
        if (this.isObjectStoreReference()) {
            return this.getObjectIdentity();
        }
        return null;
    }

    @Override
    public GlobalIdentity getObjectStoreReference() {
        if (this.isObjectStoreReference()) {
            return this;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream s) {
    }

    private void readObject(ObjectInputStream s) {
    }

    @Override
    public int getClassType() {
        return 2;
    }

    @Override
    protected int getStreamFlags() {
        int flags = super.getStreamFlags();
        flags |= this.identity == null ? 2 : 0;
        return flags |= this.identity instanceof Id ? 4 : 0;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        super.serializeValue(s);
        if (this.identity != null) {
            if (this.identity instanceof Id) {
                s.putId((Id)this.identity);
            } else {
                s.writeObject(this.identity);
            }
        }
    }

    @Override
    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        super.deserializeValue(s, flags);
        if ((flags & 2) == 0) {
            this.identity = (flags & 4) != 0 ? s.getId() : s.readObject();
        }
    }

    @Override
    protected void copyValue(ObjectReferenceBase src) {
        super.copyValue(src);
        GlobalIdentity source = (GlobalIdentity)src;
        this.identity = source.identity;
    }
}

