/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.core.Connection;
import com.filenet.api.core.DependentObject;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.collection.Lists;
import com.filenet.apiimpl.constants.ListMode;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ListUpdate;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ListImpl
implements List,
Serializable,
Cloneable {
    private Class internalClassType;
    private List originalList = new ArrayList();
    private List currentList = new ArrayList();
    private List deletedList = new ArrayList();
    private boolean isDirty = false;
    private boolean isReadOnly = false;
    private ListMode listMode = ListMode.UPDATE;
    private boolean hasBeenAttached = false;
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ListImpl.class, SubSystem.API);
    ListUpdates lu;
    private static final long serialVersionUID = -8884316246339132005L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ListImpl(List list) {
        if (list instanceof ListImpl) {
            this.internalClassType = ((ListImpl)list).getContainedType();
        } else if (list != null && list.size() > 0) {
            this.setClassType(list);
        }
        if (list != null) {
            this.currentList.addAll(list);
            this.originalList.addAll(list);
        }
    }

    public ListImpl(Class classType, List list) {
        this.internalClassType = classType;
        if (list != null) {
            this.currentList.addAll(list);
            this.originalList.addAll(list);
        }
    }

    public ListImpl(Class classType, List origList, List curList, List delList) {
        this.isDirty = true;
        this.internalClassType = classType;
        this.originalList = origList;
        this.currentList = curList;
        this.deletedList = delList;
    }

    public ListImpl(Object[] objArray) {
        if (objArray != null) {
            List<Object> v = Arrays.asList(objArray);
            this.currentList.addAll(v);
            this.originalList.addAll(v);
        }
    }

    public Object clone() {
        try {
            ListImpl clone = (ListImpl)super.clone();
            if (this.isObjectList()) {
                EngineObjectImpl srcObj;
                int i;
                clone.originalList = new ArrayList();
                for (i = 0; i < this.originalList.size(); ++i) {
                    srcObj = (EngineObjectImpl)this.originalList.get(i);
                    clone.originalList.add(srcObj.clone());
                }
                clone.deletedList = new ArrayList();
                for (i = 0; i < this.deletedList.size(); ++i) {
                    srcObj = (EngineObjectImpl)this.deletedList.get(i);
                    int iDel = ListImpl.firstIndexOf(srcObj, this.originalList, 0);
                    if (iDel != -1) {
                        clone.deletedList.add(clone.originalList.get(iDel));
                        continue;
                    }
                    clone.deletedList.add(srcObj.clone());
                }
                clone.currentList = new ArrayList();
                for (i = 0; i < this.currentList.size(); ++i) {
                    srcObj = (EngineObjectImpl)this.currentList.get(i);
                    int iCurr = ListImpl.firstIndexOf(srcObj, this.originalList, 0);
                    if (iCurr != -1) {
                        clone.currentList.add(clone.originalList.get(iCurr));
                        continue;
                    }
                    clone.currentList.add(srcObj.clone());
                }
                if (this.lu != null) {
                    clone.listMode = this.listMode;
                    clone.internalClassType = this.internalClassType;
                    clone.lu = null;
                    clone.getListUpdates();
                }
            } else {
                clone.originalList = new ArrayList(this.originalList);
                clone.currentList = new ArrayList(this.currentList);
                clone.deletedList = new ArrayList(this.deletedList);
            }
            return clone;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    public DependentObjectList copyForReuse() {
        ListImpl copy = (ListImpl)this.clone();
        copy.hasBeenAttached = false;
        return (DependentObjectList)((Object)copy);
    }

    public ListMode getListMode() {
        return this.listMode;
    }

    public void setListModeNoPush(ListMode lm) {
        this.listMode = lm;
    }

    public void setListMode(ListMode lm) {
        this.listMode = lm;
        if (this.listMode != ListMode.REPLACE || this.currentList == null || this.currentList.size() < 1) {
            return;
        }
        this.originalList = new ArrayList();
        for (Object v : this.currentList) {
            if (!(v instanceof EngineObjectImpl)) break;
            EngineObjectImpl eoi = (EngineObjectImpl)v;
            Iterator propIter = eoi.getProperties().iterator();
            while (propIter.hasNext()) {
                PropertyImpl pi = (PropertyImpl)propIter.next();
                if (pi.getInstanceValue() instanceof ListImpl) {
                    ((ListImpl)pi.getInstanceValue()).setListMode(lm);
                }
                pi.setDirty(true);
            }
        }
    }

    public boolean hasBeenAttached() {
        return this.hasBeenAttached;
    }

    public void setHasBeenAttached(boolean hba) {
        this.hasBeenAttached = hba;
    }

    public ListUpdates getListUpdates() {
        if (this.lu == null) {
            this.lu = new ListUpdates(this.internalClassType, this.listMode, this.originalList, this.currentList, this.deletedList, false, false, null);
        }
        return this.lu;
    }

    public ListUpdates getModifiedData(EngineObjectImpl parent) {
        return new ListUpdates(this.internalClassType, this.listMode, this.originalList, this.currentList, this.deletedList, true, false, parent);
    }

    public ListUpdates getListUpdatesWithImplicitMoves() {
        return new ListUpdates(this.internalClassType, this.listMode, this.originalList, this.currentList, this.deletedList, false, true, null);
    }

    public void setListUpdates(ListUpdates list) {
        this.lu = list;
        if (list != null) {
            this.listMode = list.listMode;
        }
    }

    private boolean isObjectList() {
        return this instanceof DependentObjectList;
    }

    @Override
    public boolean add(Object object) {
        this.checkUpdate(object);
        if (this.internalClassType == null) {
            this.setClassType(object);
        }
        if (this.isObjectList()) {
            int idx = ListImpl.firstIndexOf(object, this.currentList, 0);
            int rmidx = ListImpl.firstIndexOf(object, this.deletedList, 0);
            if (idx != -1) {
                if (idx == this.currentList.size() - 1) {
                    return true;
                }
                if (rmidx == -1) {
                    this.remove(idx);
                } else {
                    this.currentList.remove(idx);
                }
            }
        }
        if (this.currentList.add(object)) {
            this.isDirty = true;
            return true;
        }
        return false;
    }

    public void loadElement(Object object) {
        this.currentList.add(object);
    }

    public void add(int index, Object object) {
        this.checkUpdate(object);
        if (this.internalClassType == null) {
            this.setClassType(object);
        }
        int idx = -1;
        if (this.isObjectList()) {
            idx = ListImpl.firstIndexOf(object, this.currentList, 0);
            if (idx == index) {
                return;
            }
            int rmidx = ListImpl.firstIndexOf(object, this.deletedList, 0);
            if (idx != -1) {
                if (rmidx == -1) {
                    this.remove(idx);
                } else {
                    this.currentList.remove(idx);
                }
            }
        }
        this.isDirty = true;
        this.currentList.add(index, object);
    }

    public boolean addAll(int index, Collection collection) {
        this.checkUpdate(collection);
        if (this.internalClassType == null) {
            this.setClassType(collection);
        }
        this.isDirty = true;
        return this.currentList.addAll(index, collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        this.checkUpdate(collection);
        if (this.internalClassType == null) {
            this.setClassType(collection);
        }
        this.isDirty = true;
        return this.currentList.addAll(collection);
    }

    @Override
    public void clear() {
        this.checkUpdate();
        this.deletedList.addAll(this.currentList);
        this.listMode = ListMode.REPLACE;
        this.isDirty = true;
        this.currentList.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.currentList.contains(object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.currentList.containsAll(collection);
    }

    @Override
    public boolean equals(Object obj) {
        return this.currentList.equals(obj);
    }

    public Class getContainedType() {
        return this.internalClassType;
    }

    public Object get(int index) {
        return this.currentList.get(index);
    }

    @Override
    public int hashCode() {
        return this.currentList.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.currentList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.currentList.isEmpty();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public Iterator iterator() {
        return new InternalIterator(this);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.currentList.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return new InternalListIterator(this);
    }

    public ListIterator listIterator(int index) {
        return new InternalListIterator(this, index);
    }

    public Object remove(int index) {
        this.checkUpdate();
        this.isDirty = true;
        Object obj = this.currentList.remove(index);
        int posInOriginalList = ListImpl.firstIndexOf(obj, this.originalList, 0);
        if (posInOriginalList >= 0) {
            this.addToDeleteList(obj);
        }
        return obj;
    }

    @Override
    public boolean remove(Object object) {
        this.checkUpdate();
        boolean removed = false;
        int index = this.currentList.indexOf(object);
        if (index >= 0) {
            Object temp = this.currentList.get(index);
            removed = this.currentList.remove(object);
            this.isDirty = true;
            int posInOriginalList = ListImpl.firstIndexOf(temp, this.originalList, 0);
            if (posInOriginalList >= 0) {
                this.addToDeleteList(temp);
            }
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection collection) {
        this.checkUpdate();
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean listChanged = false;
        for (Object obj : collection) {
            if (!this.currentList.contains(obj)) continue;
            this.addToDeleteList(obj);
            this.currentList.remove(obj);
            this.isDirty = true;
            listChanged = true;
        }
        return listChanged;
    }

    @Override
    public boolean retainAll(Collection collection) {
        this.checkUpdate();
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean listChanged = false;
        Iterator iter = this.currentList.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (collection.contains(obj)) continue;
            this.addToDeleteList(obj);
            iter.remove();
            this.isDirty = true;
            listChanged = true;
        }
        return listChanged;
    }

    public Object set(int index, Object object) {
        this.checkUpdate(object);
        if (this.internalClassType == null) {
            this.setClassType(object);
        }
        this.isDirty = true;
        Object currItem = this.currentList.get(index);
        if (currItem == object) {
            return currItem;
        }
        this.deletedList.add(currItem);
        return this.currentList.set(index, object);
    }

    public void setReadOnly(boolean ro) {
        this.isReadOnly = ro;
    }

    @Override
    public int size() {
        return this.currentList.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.currentList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.currentList.toArray();
    }

    @Override
    public Object[] toArray(Object[] array) {
        return this.currentList.toArray(array);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" IsDirty=");
        sb.append(this.isDirty);
        sb.append(" IsReadOnly=");
        sb.append(this.isReadOnly);
        sb.append(" CurrentList=");
        sb.append(this.currentList);
        sb.append(" DeletedList=");
        sb.append(this.deletedList);
        sb.append(" InternalClassType=");
        sb.append(this.internalClassType != null ? this.internalClassType.getName() : "null");
        sb.append(" OriginalList=");
        sb.append(this.originalList);
        return sb.toString();
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return this.isDirty;
        }
        if (!this.deletedList.isEmpty()) {
            this.isDirty = true;
            return true;
        }
        if (this.deletedList.isEmpty() && this.currentList.isEmpty() && this.originalList.isEmpty()) {
            this.isDirty = false;
            return false;
        }
        if (this.isObjectList()) {
            for (EngineObject eo : this.currentList) {
                if (!eo.getProperties().isDirty()) continue;
                this.isDirty = true;
                return true;
            }
        }
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        if (!dirty) {
            this.deletedList.clear();
            this.originalList = new ArrayList(this.currentList);
        }
        for (Object obj : this.currentList) {
            if (!(obj instanceof EngineObjectImpl)) continue;
            ((EngineObjectImpl)obj).setDirty(dirty);
        }
        this.isDirty = dirty;
    }

    public List getOriginalList() {
        return this.originalList;
    }

    private void addToDeleteList(Object obj) {
        this.deletedList.add(obj);
    }

    private void setClassType(Collection collection) {
        if (this.internalClassType != null) {
            return;
        }
        if (collection.size() > 0) {
            this.setClassType(collection.iterator().next());
        }
    }

    public void setClassType(Object object) {
        if (this.internalClassType == null && object != null) {
            this.internalClassType = object.getClass();
        }
    }

    private void checkUpdate() {
        if (this.isReadOnly) {
            throw new EngineRuntimeException(ExceptionCode.E_READ_ONLY, null);
        }
    }

    private void checkUpdate(Object object) {
        this.checkUpdate();
        if (this.isObjectList()) {
            if (!(object instanceof DependentObject)) {
                throw new EngineRuntimeException(ExceptionCode.E_INVALID_OBJECT_TYPE, object.getClass());
            }
        } else {
            Lists.checkType(this.internalClassType, object);
        }
    }

    private void checkUpdate(Collection collection) {
        if (this instanceof DependentObjectList) {
            return;
        }
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.checkUpdate(i.next());
        }
    }

    private Connection getConnection() {
        if (this.currentList == null || this.currentList.size() < 1) {
            return null;
        }
        Object v = this.currentList.get(0);
        if (v instanceof EngineObjectImpl) {
            return ((EngineObjectImpl)v).getConnection();
        }
        return null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(20);
        s.writeObject(this.getConnection());
        DelegateOutputStream tos = null;
        tos = s instanceof DelegateOutputStream ? (DelegateOutputStream)s : BinaryOutputStream.getInstance((short)20, s);
        tos.writeObject(this.internalClassType);
        int originalListSize = this.originalList == null ? 0 : this.originalList.size();
        tos.writeInt(originalListSize);
        for (int lp = 0; lp < originalListSize; ++lp) {
            tos.putObject(this.originalList.get(lp));
        }
        int currentListSize = this.currentList == null ? 0 : this.currentList.size();
        tos.writeInt(currentListSize);
        for (int lp = 0; lp < currentListSize; ++lp) {
            tos.putObject(this.currentList.get(lp));
        }
        int deletedListSize = this.deletedList == null ? 0 : this.deletedList.size();
        tos.writeInt(deletedListSize);
        for (int lp = 0; lp < deletedListSize; ++lp) {
            tos.putObject(this.deletedList.get(lp));
        }
        tos.writeBoolean(this.isDirty);
        tos.writeBoolean(this.isReadOnly);
        tos.writeObject(this.listMode);
        tos.writeBoolean(this.hasBeenAttached);
        tos.flush();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        short version = s.readShort();
        Connection conn = (Connection)s.readObject();
        DelegateInputStream tis = null;
        tis = s instanceof DelegateInputStream ? (DelegateInputStream)s : BinaryInputStream.getInstance(version, s, conn);
        this.internalClassType = (Class)tis.readObject();
        int originalListSize = tis.readInt();
        this.originalList = new ArrayList();
        for (int lp = 0; lp < originalListSize; ++lp) {
            this.originalList.add(tis.getObject());
        }
        int currentListSize = tis.readInt();
        this.currentList = new ArrayList();
        for (int lp = 0; lp < currentListSize; ++lp) {
            this.currentList.add(tis.getObject());
        }
        int deletedListSize = tis.readInt();
        this.deletedList = new ArrayList();
        for (int lp = 0; lp < deletedListSize; ++lp) {
            this.deletedList.add(tis.getObject());
        }
        this.isDirty = tis.readBoolean();
        this.isReadOnly = tis.readBoolean();
        this.listMode = (ListMode)tis.readObject();
        this.hasBeenAttached = tis.readBoolean();
    }

    private List cloneList(List srcList) {
        ArrayList<Object> retList;
        if (this.isObjectList()) {
            retList = new ArrayList<Object>();
            for (int i = 0; i < srcList.size(); ++i) {
                EngineObjectImpl srcObj = (EngineObjectImpl)srcList.get(i);
                retList.add(srcObj.clone());
            }
        } else {
            retList = new ArrayList(srcList);
        }
        return retList;
    }

    private static int firstIndexOf(Object obj, List list, int startPos) {
        for (int curPos = startPos; curPos < list.size(); ++curPos) {
            Object o = list.get(curPos);
            if (o != obj) continue;
            return curPos;
        }
        return -1;
    }

    public static class ListUpdates
    implements List {
        private List modsList = new ArrayList();
        private int numDeletes = 0;
        private int numMoves = 0;
        private int numUpdates = 0;
        private int numInserts = 0;
        private ListMode listMode;

        public ListUpdates(Class internalClassType, ListMode lm, List originalList, List currentList, List deletedList, boolean provideMods, boolean addImplicitMoves, EngineObjectImpl eoi) {
            ObjectReferenceBase parent = null;
            if (eoi != null) {
                parent = (ObjectReferenceBase)eoi.getObjectReference();
            }
            this.listMode = lm;
            if (internalClassType == null || !EngineObject.class.isAssignableFrom(internalClassType)) {
                this.modsList.addAll(currentList);
            } else if (lm == ListMode.REPLACE) {
                this.computeListReplacements(currentList, provideMods, parent);
            } else {
                this.computeListUpdates(originalList, currentList, deletedList, provideMods, addImplicitMoves);
            }
        }

        public ListMode getListMode() {
            return this.listMode;
        }

        public ListUpdates(List listOfExistingUpdates, ListMode lm) {
            this.listMode = lm;
            if (listOfExistingUpdates.isEmpty()) {
                return;
            }
            this.modsList.addAll(listOfExistingUpdates);
            for (ListUpdate lu : this.modsList) {
                switch (lu.getAction()) {
                    case 2: {
                        ++this.numDeletes;
                        break;
                    }
                    case 0: {
                        ++this.numInserts;
                        break;
                    }
                    case 1: {
                        ++this.numMoves;
                        break;
                    }
                    case 3: {
                        ++this.numUpdates;
                    }
                }
            }
        }

        public int getNumDeletes() {
            return this.numDeletes;
        }

        public void setNumDeletes(int deletes) {
            this.numDeletes = deletes;
        }

        public int getNumMoves() {
            return this.numMoves;
        }

        public int getNumInserts() {
            return this.numInserts;
        }

        public int getNumUpdates() {
            return this.numUpdates;
        }

        private EngineObjectImpl getObjectForInsert(ObjectReferenceBase parent, int curPos, EngineObjectImpl eo) {
            DependentIdentity di;
            ObjectReferenceBase ref = (ObjectReferenceBase)eo.getObjectReference();
            if (parent != null && ref instanceof DependentIdentity && !parent.equals((di = (DependentIdentity)ref).getParentReference())) {
                if (!eo.isNew()) {
                    if (logger.isWarnEnabled() && !SessionLocator.isExecutingInServer()) {
                        logger.warn("Dependent object reuse is detected. Reuse of dependent objects is not recommended");
                    }
                    eo = (EngineObjectImpl)eo.clone();
                }
                di = (DependentIdentity)eo.getObjectReference();
                di.setParentReference(parent);
                di.setIndex(curPos);
            }
            Iterator propIter = eo.getProperties().iterator();
            while (propIter.hasNext()) {
                PropertyImpl pi = (PropertyImpl)propIter.next();
                if (pi.getInstanceValue() instanceof ListImpl) {
                    ((ListImpl)pi.getInstanceValue()).setListMode(ListMode.REPLACE);
                }
                pi.setDirty(true);
            }
            return eo;
        }

        private void computeListReplacements(List currentList, boolean provideMods, ObjectReferenceBase parent) {
            Iterator iter = currentList.iterator();
            int curPos = 0;
            while (iter.hasNext()) {
                EngineObjectImpl eo = (EngineObjectImpl)iter.next();
                eo = this.getObjectForInsert(parent, curPos, eo);
                this.modsList.add(new ListUpdate(0, provideMods ? eo.getModifiedData() : eo, -1, curPos));
                ++this.numInserts;
                ++curPos;
            }
        }

        private void computeListAppends(List originalList, List currentList, boolean provideMods) {
            Iterator iter = currentList.iterator();
            int curPos = -1;
            while (iter.hasNext()) {
                EngineObjectImpl eo = (EngineObjectImpl)iter.next();
                this.modsList.add(new ListUpdate(0, provideMods ? eo.getModifiedData() : eo, -1, curPos));
                ++this.numInserts;
            }
        }

        private void removeDuplicateDeletes(List deletedList) {
            if (deletedList.size() >= 2) {
                for (int curPos = 0; curPos < deletedList.size(); ++curPos) {
                    int innerPos = curPos + 1;
                    while (innerPos < deletedList.size()) {
                        if (deletedList.get(curPos) == deletedList.get(innerPos)) {
                            deletedList.remove(innerPos);
                            continue;
                        }
                        ++innerPos;
                    }
                }
            }
        }

        private void computeListUpdates(List originalList, List currentList, List deletedList, boolean provideMods, boolean addImplicitMoves) {
            this.removeDuplicateDeletes(deletedList);
            for (EngineObjectImpl eo : deletedList) {
                int currentIndex = ListImpl.firstIndexOf(eo, currentList, 0);
                int originalIndex = ListImpl.firstIndexOf(eo, originalList, 0);
                if (originalIndex == -1) continue;
                if (currentIndex == -1) {
                    this.modsList.add(new ListUpdate(2, provideMods ? eo.getModifiedData() : eo, originalIndex, -1));
                    ++this.numDeletes;
                    continue;
                }
                this.modsList.add(new ListUpdate(1, provideMods ? eo.getModifiedData() : eo, originalIndex, currentIndex));
                ++this.numMoves;
            }
            Iterator iter = currentList.iterator();
            int curPos = 0;
            while (iter.hasNext()) {
                EngineObjectImpl eo = (EngineObjectImpl)iter.next();
                int origIndex = ListImpl.firstIndexOf(eo, originalList, 0);
                int delIndex = ListImpl.firstIndexOf(eo, deletedList, 0);
                if (delIndex == -1) {
                    if (origIndex == -1) {
                        eo = this.getObjectForInsert(null, curPos, eo);
                        this.modsList.add(new ListUpdate(0, provideMods ? eo.getModifiedData() : eo, -1, curPos));
                        ++this.numInserts;
                    } else if (eo.getProperties().isDirty()) {
                        this.modsList.add(new ListUpdate(3, provideMods ? eo.getModifiedData() : eo, origIndex, curPos));
                        ++this.numUpdates;
                    } else if (curPos != origIndex && addImplicitMoves) {
                        this.modsList.add(new ListUpdate(1, provideMods ? eo.getModifiedData() : eo, origIndex, curPos));
                        ++this.numMoves;
                    }
                }
                ++curPos;
            }
        }

        @Override
        public boolean addAll(Collection collection) {
            return this.modsList.addAll(collection);
        }

        public Object get(int pos) {
            return this.modsList.get(pos);
        }

        @Override
        public int hashCode() {
            return this.modsList.hashCode();
        }

        @Override
        public int indexOf(Object object) {
            return this.modsList.indexOf(object);
        }

        @Override
        public boolean isEmpty() {
            return this.modsList.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return this.modsList.iterator();
        }

        public ListIterator listIterator() {
            return this.modsList.listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.modsList.listIterator(index);
        }

        @Override
        public boolean removeAll(Collection collection) {
            return this.modsList.removeAll(collection);
        }

        @Override
        public boolean add(Object object) {
            return this.modsList.add(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.modsList.lastIndexOf(object);
        }

        public void add(int index, Object object) {
            this.modsList.add(index, object);
        }

        public List subList(int fromIndex, int toIndex) {
            return this.modsList.subList(fromIndex, toIndex);
        }

        public Object remove(int index) {
            return this.modsList.remove(index);
        }

        @Override
        public int size() {
            return this.modsList.size();
        }

        @Override
        public Object[] toArray() {
            return this.modsList.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            return this.modsList.toArray(array);
        }

        public String toString() {
            return "List mode: " + this.listMode + ", modifications: " + this.modsList.toString();
        }

        @Override
        public boolean remove(Object object) {
            return this.modsList.remove(object);
        }

        @Override
        public boolean retainAll(Collection collection) {
            return this.modsList.retainAll(collection);
        }

        @Override
        public boolean contains(Object object) {
            return this.modsList.contains(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            return this.modsList.containsAll(collection);
        }

        @Override
        public boolean equals(Object obj) {
            return this.modsList.equals(obj);
        }

        public Object set(int index, Object object) {
            return this.modsList.set(index, object);
        }

        public boolean addAll(int index, Collection collection) {
            return this.modsList.addAll(index, collection);
        }

        @Override
        public void clear() {
            this.modsList.clear();
        }
    }

    private static class InternalListIterator
    implements ListIterator {
        private ListImpl listPtr = null;
        private ListIterator iterator = null;
        private Object currItem = null;

        public InternalListIterator(ListImpl list) {
            this.listPtr = list;
            this.iterator = this.listPtr.currentList.listIterator();
        }

        public InternalListIterator(ListImpl list, int index) {
            this.listPtr = list;
            this.iterator = this.listPtr.currentList.listIterator(index);
        }

        public void add(Object obj) {
            this.listPtr.checkUpdate(obj);
            this.iterator.add(obj);
            this.listPtr.isDirty = true;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public Object next() {
            this.currItem = this.iterator.next();
            return this.currItem;
        }

        public Object previous() {
            this.currItem = this.iterator.previous();
            return this.currItem;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.listPtr.checkUpdate();
            this.iterator.remove();
            if (this.currItem != null) {
                this.listPtr.deletedList.add(this.currItem);
                this.listPtr.isDirty = true;
            }
        }

        public void set(Object obj) {
            this.listPtr.checkUpdate(obj);
            this.iterator.set(obj);
            if (this.currItem != null) {
                this.listPtr.deletedList.add(this.currItem);
                this.listPtr.isDirty = true;
            }
        }
    }

    private static class InternalIterator
    implements Iterator {
        private ListImpl listPtr;
        private Iterator iterator;
        private Object currItem;

        public InternalIterator(ListImpl list) {
            this.listPtr = list;
            this.iterator = this.listPtr.currentList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.currItem = this.iterator.next();
            return this.currItem;
        }

        @Override
        public void remove() {
            this.listPtr.checkUpdate();
            this.iterator.remove();
            if (this.currItem != null) {
                this.listPtr.deletedList.add(this.currItem);
                this.listPtr.isDirty = true;
            }
        }
    }
}

