/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class ObjectByName
extends ObjectReferenceBase {
    private GlobalIdentity objectStore;
    private String name;
    private static final long serialVersionUID = -3953796360367435819L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_OBJECT_STORE = 2;
    private static final int NULL_NAME = 4;

    public ObjectByName() {
    }

    public ObjectByName(String classIdentity, ObjectStoreImpl objectStore, String name) {
        super(classIdentity);
        this.objectStore = objectStore.getObjectStoreReference();
        this.name = name;
    }

    public ObjectByName(String classIdentity, GlobalIdentity objectStore, String name) {
        super(classIdentity);
        this.objectStore = objectStore;
        this.name = name;
    }

    @Override
    public GlobalIdentity getObjectStoreReference() {
        return this.objectStore;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("classId=");
        sb.append(this.getClassIdentity());
        sb.append("&objectId=");
        sb.append(this.getObjectIdentity());
        sb.append("&objectStore=");
        sb.append(this.getObjectStoreIdentity());
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectByName)) {
            return false;
        }
        ObjectByName base = (ObjectByName)object;
        if (this.name != null && base.name == null || base.name != null && this.name == null) {
            return false;
        }
        if (this.objectStore != null && base.objectStore == null || base.objectStore != null && this.objectStore == null) {
            return false;
        }
        if (this.name != null && !this.name.equalsIgnoreCase(base.name)) {
            return false;
        }
        if (this.objectStore != null && !this.objectStore.equals(base.objectStore)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + super.hashCode();
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.objectStore != null ? this.objectStore.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        ObjectByName that = (ObjectByName)obj;
        int cmp = 0;
        if (this.name != that.name) {
            if (this.name == null) {
                return -1;
            }
            if (that.name == null) {
                return 1;
            }
            cmp = this.name.compareToIgnoreCase(that.name);
            if (cmp != 0) {
                return cmp;
            }
        }
        if (this.objectStore != that.objectStore) {
            if (this.objectStore == null) {
                return -1;
            }
            if (that.objectStore == null) {
                return 1;
            }
            cmp = this.objectStore.compareTo(that.objectStore);
            if (cmp != 0) {
                return cmp;
            }
        }
        return super.compareTo(obj);
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public String getObjectIdentity() {
        return this.name;
    }

    @Override
    public String getObjectStoreIdentity() {
        return this.objectStore != null ? this.objectStore.getObjectIdentity() : null;
    }

    private void writeObject(ObjectOutputStream s) {
    }

    private void readObject(ObjectInputStream s) {
    }

    @Override
    public int getClassType() {
        return 3;
    }

    @Override
    protected int getStreamFlags() {
        int flags = super.getStreamFlags();
        flags |= this.objectStore == null ? 2 : 0;
        return flags |= this.name == null ? 4 : 0;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        super.serializeValue(s);
        if (this.objectStore != null) {
            s.putObjectReference(this.objectStore);
        }
        if (this.name != null) {
            s.writeObject(this.name);
        }
    }

    @Override
    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        super.deserializeValue(s, flags);
        if ((flags & 2) == 0) {
            this.objectStore = (GlobalIdentity)s.getObjectReference();
        }
        if ((flags & 4) == 0) {
            this.name = (String)s.readObject();
        }
    }

    @Override
    protected void copyValue(ObjectReferenceBase src) {
        super.copyValue(src);
        ObjectByName source = (ObjectByName)src;
        this.objectStore = source.objectStore;
        this.name = source.name;
    }
}

