/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.action.Create;
import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.BooleanList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.PageIterator;
import com.filenet.api.collection.StringList;
import com.filenet.api.core.Connection;
import com.filenet.api.core.DependentObject;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.Property;
import com.filenet.api.util.ConfigurationParameters;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.BinaryListImpl;
import com.filenet.apiimpl.collection.BooleanListImpl;
import com.filenet.apiimpl.collection.DateTimeListImpl;
import com.filenet.apiimpl.collection.EngineSetPageIterator;
import com.filenet.apiimpl.collection.Float64ListImpl;
import com.filenet.apiimpl.collection.IdListImpl;
import com.filenet.apiimpl.collection.Integer32ListImpl;
import com.filenet.apiimpl.collection.StringListImpl;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.EngineObjectUtil;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.core.ObjectByName;
import com.filenet.apiimpl.core.ObjectByPath;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.core.SubListImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.meta.Cache;
import com.filenet.apiimpl.property.PropertyImpl;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectFactory {
    private static final Map constructors = new ConcurrentHashMap();
    private static final Class[] constructorArgs = new Class[]{Connection.class, String.class, ObjectReferenceBase.class};

    public static EngineObjectImpl getInstance(ObjectReference or, String[] superClassIdentities, Connection connection) {
        Constructor c = ObjectFactory.lookupConstructor(or.getClassIdentity(), superClassIdentities);
        Object[] args = new Object[]{connection, or.getClassIdentity(), or};
        try {
            EngineObjectImpl eo = (EngineObjectImpl)c.newInstance(args);
            eo.setSuperClasses(ObjectFactory.getSuperClasses(or.getClassIdentity(), superClassIdentities));
            return eo;
        }
        catch (Exception e) {
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            throw new EngineRuntimeException(e, ExceptionCode.API_UNSUPPORTED_API_CLASS, new Object[]{or.getClassIdentity() != null ? or.getClassIdentity() : "null"});
        }
    }

    private static String[] getSuperClasses(String className, String[] superClasses) {
        if (superClasses == null || superClasses.length == 0) {
            return null;
        }
        if (className == null) {
            return null;
        }
        if (EngineObjectUtil.findClassByName(className) != null && !EngineObjectUtil.isRecentlyAddedClass(className)) {
            return null;
        }
        return superClasses;
    }

    public static EngineObjectImpl getInstance(Connection conn, String classIdentity, String[] superClassIdentities, Id id, Domain d) {
        GlobalIdentity or = ObjectFactory.getGlobalReference(classIdentity, id);
        EngineObjectImpl eo = ObjectFactory.getInstance(or, superClassIdentities, conn);
        if (d != null) {
            eo.setDomainScope((ObjectReferenceBase)d.getObjectReference());
        }
        return eo;
    }

    public static EngineObjectImpl getInstance(Connection conn, String classIdentity, String[] superClassIdentities, String name, Domain d) {
        GlobalIdentity or = ObjectFactory.getGlobalReference(classIdentity, name);
        EngineObjectImpl eo = ObjectFactory.getInstance(or, superClassIdentities, conn);
        if (d != null) {
            eo.setDomainScope((ObjectReferenceBase)d.getObjectReference());
        }
        return eo;
    }

    public static EngineObjectImpl getInstance(ObjectStore os, String classIdentity, String[] superClassIdentities, Id id) {
        ObjectReference osOR = os.getObjectReference();
        GlobalIdentity osGI = new GlobalIdentity(osOR.getClassIdentity(), osOR.getObjectIdentity());
        RepositoryIdentity or = ObjectFactory.getRepositoryReference(classIdentity, osGI, id);
        return ObjectFactory.getInstance(or, superClassIdentities, os.getConnection());
    }

    public static EngineObjectImpl getInstance(ObjectStore os, String classIdentity, String[] superClassIdentities, String objectIdentity) {
        ObjectReferenceBase or = ObjectFactory.getRepositoryReference(classIdentity, (GlobalIdentity)os.getObjectReference(), objectIdentity);
        return ObjectFactory.getInstance(or, superClassIdentities, os.getConnection());
    }

    public static EngineObjectImpl getInstance(GlobalIdentity objectStore, Connection conn, String classIdentity, String[] superClassIdentities, Id id) {
        RepositoryIdentity or = ObjectFactory.getRepositoryReference(classIdentity, objectStore, id);
        return ObjectFactory.getInstance(or, superClassIdentities, conn);
    }

    public static EngineObjectImpl getDependentInstance(Connection conn, String classIdentity, String[] superClassIdentities, ObjectReferenceBase parent, String propertyName, Integer index) {
        DependentIdentity or = ObjectFactory.getDependentReference(classIdentity, parent, propertyName, index);
        return ObjectFactory.getInstance(or, superClassIdentities, conn);
    }

    public static EngineObjectImpl createInstance(ObjectReference or, String[] superClassIdentities, Connection connection, Create createAction) {
        EngineObjectImpl eo = ObjectFactory.getInstance(or, superClassIdentities, connection);
        if (eo instanceof IndependentlyPersistableObjectImpl) {
            if (createAction == null) {
                IndependentlyPersistableObjectImpl.addCreatePendingAction((IndependentlyPersistableObjectImpl)eo);
            } else {
                ((IndependentlyPersistableObjectImpl)eo).addPendingAction(createAction);
            }
        }
        return eo;
    }

    public static DependentIdentity getDependentReference(String classIdentity, ObjectReferenceBase parent, String propertyName, Integer index) {
        return new DependentIdentity(classIdentity, parent, propertyName, index);
    }

    public static RepositoryIdentity getRepositoryReference(String classIdentity, GlobalIdentity objectStore, Id id) {
        return new RepositoryIdentity(classIdentity, objectStore, id);
    }

    public static ObjectReferenceBase getRepositoryReference(String classIdentity, GlobalIdentity objectStore, String objectIdentity) {
        if (objectIdentity == null) {
            return new RepositoryIdentity(classIdentity, objectStore, null);
        }
        Id objId = Id.asIdOrNull(objectIdentity);
        if (objId != null) {
            return new RepositoryIdentity(classIdentity, objectStore, objId);
        }
        if (ObjectReferenceBase.isPathIdentity(objectIdentity)) {
            return new ObjectByPath(classIdentity, objectStore, objectIdentity);
        }
        return new ObjectByName(classIdentity, objectStore, objectIdentity);
    }

    public static GlobalIdentity getGlobalReference(String classIdentity, Id id) {
        return new GlobalIdentity(classIdentity, id);
    }

    public static GlobalIdentity getGlobalReference(String classIdentity, String objectIdentity) {
        Id objId = Id.asIdOrNull(objectIdentity);
        if (objId != null) {
            return new GlobalIdentity(classIdentity, objId);
        }
        return new GlobalIdentity(classIdentity, objectIdentity);
    }

    private static Constructor lookupConstructor(String classIdentity, String[] superClassIdentities) {
        Constructor constructor;
        if (classIdentity == null) {
            classIdentity = ObjectFactory.findIdentity(superClassIdentities);
        }
        if ((constructor = (Constructor)constructors.get(classIdentity)) == null) {
            constructor = ObjectFactory.findConstructor(classIdentity, superClassIdentities);
        }
        return constructor;
    }

    private static String findIdentity(String[] superClassIdentities) {
        if (superClassIdentities == null || superClassIdentities.length == 0) {
            throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_API_CLASS, "null");
        }
        return EngineObjectUtil.getAPIClassName(superClassIdentities[0]);
    }

    private static Constructor findConstructor(String classIdentity, String[] superClassIdentities) {
        try {
            boolean cacheable;
            Class c = EngineObjectUtil.findClassByName(classIdentity);
            boolean bl = cacheable = c != null;
            if (c == null && (c = EngineObjectUtil.findClassBySuperClassNames(superClassIdentities)) == null) {
                throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_API_CLASS, classIdentity);
            }
            Constructor constructor = c.getDeclaredConstructor(constructorArgs);
            if (cacheable) {
                constructors.put(classIdentity, constructor);
            }
            return constructor;
        }
        catch (Throwable e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_UNSUPPORTED_API_CLASS, new Object[]{classIdentity});
        }
    }

    public static EngineObjectImpl getInstance(ObjectStore impl, String className, String classNameForSuperClass, Id objectId) {
        String[] superClasses = null;
        if (classNameForSuperClass != null) {
            superClasses = EngineObjectUtil.getSuperClassNames(classNameForSuperClass);
            if (className != null && EngineObjectUtil.findClassByName(className) == null && impl != null) {
                RepositoryIdentity r = ObjectFactory.getRepositoryReference(className, (GlobalIdentity)impl.getObjectReference(), objectId);
                Connection connection = impl.getConnection();
                superClasses = ObjectFactory.getSuperClassesFromCMC(connection, r);
            }
        } else if (impl != null) {
            RepositoryIdentity or = ObjectFactory.getRepositoryReference(className, (GlobalIdentity)impl.getObjectReference(), objectId);
            Connection connection = impl.getConnection();
            superClasses = ObjectFactory.getSuperClassesFromCMC(connection, or);
        }
        return ObjectFactory.getInstance(impl, className, superClasses, objectId);
    }

    private static String[] getSuperClassesFromCMC(Connection connection, ObjectReference or) {
        if (connection != null) {
            InstantiatingScope scope = (InstantiatingScope)EngineObjectUtil.getScope((ObjectReferenceBase)or, connection);
            String classIdentity = or.getClassIdentity();
            return ObjectFactory.getSuperClassesFromCMC(scope, classIdentity);
        }
        return null;
    }

    static String[] getSuperClassesFromCMC(InstantiatingScope scope, String classIdentity) {
        if (classIdentity == null || EngineObjectUtil.findClassByName(classIdentity) != null) {
            return null;
        }
        Object[] superClasses = null;
        Vector<String> superClassDescs = new Vector<String>();
        Cache cache = Cache.getDefaultInstance((EngineObject)((Object)scope));
        ClassDescription classDesc = cache.getClassDescription(scope, classIdentity);
        while (classDesc != null && EngineObjectUtil.findClassByName(classDesc.get_SymbolicName()) == null) {
            ClassDescription supClassDesc = null;
            Property supClassDescProperty = classDesc.getProperties().get("SuperclassDescription");
            ObjectReference or = ((PropertyImpl)supClassDescProperty).getObjectReference();
            if (EngineObjectUtil.findClassByName(or.getObjectIdentity()) == null) {
                supClassDesc = classDesc.get_SuperclassDescription();
            } else {
                superClassDescs.add(EngineObjectUtil.findRoot(or.getObjectIdentity(), null));
            }
            if (supClassDesc == null) break;
            superClassDescs.add(supClassDesc.get_SymbolicName());
            classDesc = supClassDesc;
        }
        if (superClassDescs.size() > 0) {
            superClasses = new String[superClassDescs.size()];
            superClassDescs.copyInto(superClasses);
        }
        return superClasses;
    }

    public static EngineObjectImpl getInstanceByPath(ObjectReference or, String superClassId, ObjectStore os) {
        String[] stringArray;
        if (superClassId == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = superClassId;
        }
        return ObjectFactory.getInstanceByPath(or, stringArray, os);
    }

    public static EngineObjectImpl getInstanceByPath(ObjectReference or, String[] superClassIdentities, ObjectStore os) {
        if (superClassIdentities == null) {
            superClassIdentities = ObjectFactory.getSuperClassesFromCMC(os.getConnection(), or);
        }
        return ObjectFactory.getInstance(or, superClassIdentities, os != null ? os.getConnection() : (Connection)null);
    }

    public static EngineObjectImpl getInstanceByPath(ObjectStore os, String classIdentity, String objectIdentity) {
        ObjectByPath or = new ObjectByPath(classIdentity, (ObjectStoreImpl)os, objectIdentity);
        return ObjectFactory.getInstanceByPath((ObjectReference)or, (String[])null, os);
    }

    public static DependentObject getInstanceDependent(String classIdentity, ObjectStore objectStore) {
        DependentIdentity di = new DependentIdentity(classIdentity, (ObjectStoreImpl)objectStore);
        Connection conn = objectStore.getConnection();
        String[] superClasses = ObjectFactory.getSuperClassesFromCMC(conn, di);
        DependentObject dob = (DependentObject)((Object)ObjectFactory.getInstance(di, superClasses, conn));
        return dob;
    }

    public static DependentObject getInstanceDependent(String classIdentity) {
        DependentIdentity di = new DependentIdentity(classIdentity);
        DependentObject dob = (DependentObject)((Object)ObjectFactory.getInstance(di, null, null));
        return dob;
    }

    public static EngineRuntimeException nullargPacei() {
        return new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, new Object[]{"id"}, ExceptionContext.PERSIST_ADDON_CREATION_REQUIRES_ID, null);
    }

    public static PageIterator resumeFromCheckpoint(Connection conn, byte[] checkpoint) {
        return EngineSetPageIterator.resumeFromCheckpoint(conn, checkpoint);
    }

    public static Connection getConnection(String uri, ConfigurationParameters parameters) {
        return new ConnectionImpl(uri, parameters);
    }

    public static BinaryList createBinaryList() {
        return new BinaryListImpl(null);
    }

    public static BooleanList createBooleanList() {
        return new BooleanListImpl(null);
    }

    public static DateTimeList createDateTimeList() {
        return new DateTimeListImpl(null);
    }

    public static Float64List createFloat64List() {
        return new Float64ListImpl(null);
    }

    public static IdList createIdList() {
        return new IdListImpl(null);
    }

    public static Integer32List createInteger32List() {
        return new Integer32ListImpl(null);
    }

    public static StringList createStringList() {
        return new StringListImpl(null);
    }

    public static List createList(Class singleton) {
        return new SubListImpl(singleton);
    }
}

