/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.apiimpl.jdbc.ResultSet;
import com.filenet.apiimpl.jdbc.RowData;
import java.util.ArrayList;
import java.util.List;

public class RowDataStatic
implements RowData {
    private int index;
    ResultSet owner;
    private List rows;

    public RowDataStatic(ArrayList rows) {
        this.index = -1;
        this.rows = rows;
    }

    public RowDataStatic() {
        this.rows = new ArrayList();
        this.index = -1;
    }

    @Override
    public void addRow(Object[] row) {
        this.rows.add(row);
    }

    @Override
    public void afterLast() {
        this.index = this.rows.size();
    }

    @Override
    public void beforeFirst() {
        this.index = -1;
    }

    @Override
    public void beforeLast() {
        this.index = this.rows.size() - 2;
    }

    @Override
    public void close() {
    }

    @Override
    public Object[] getAt(int atIndex) {
        if (atIndex < 0 || atIndex >= this.rows.size()) {
            return null;
        }
        return (Object[])this.rows.get(atIndex);
    }

    @Override
    public int getCurrentRowNumber() {
        return this.index;
    }

    @Override
    public ResultSet getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasNext() {
        boolean hasMore = this.index + 1 < this.rows.size();
        return hasMore;
    }

    @Override
    public boolean isAfterLast() {
        return this.index >= this.rows.size();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.index == -1 && this.rows.size() != 0;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.rows.size() == 0;
    }

    @Override
    public boolean isFirst() {
        return this.index == 0;
    }

    @Override
    public boolean isLast() {
        if (this.rows.size() == 0) {
            return false;
        }
        return this.index == this.rows.size() - 1;
    }

    @Override
    public void moveRowRelative(int rowsToMove) {
        this.index += rowsToMove;
    }

    @Override
    public Object[] next() {
        ++this.index;
        if (this.index < this.rows.size()) {
            return (Object[])this.rows.get(this.index);
        }
        return null;
    }

    @Override
    public void removeRow(int atIndex) {
        this.rows.remove(atIndex);
    }

    @Override
    public void setCurrentRow(int newIndex) {
        this.index = newIndex;
    }

    @Override
    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    @Override
    public int size() {
        return this.rows.size();
    }
}

