/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.core.Connection;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.core.Scope;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.core.ClassDescriptionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.meta.Cache;
import com.filenet.apiimpl.meta.CachedObject;
import com.filenet.apiimpl.meta.CachedPropertyClassDescription;
import com.filenet.apiimpl.meta.CachedPropertyClassDescriptionSet;
import com.filenet.apiimpl.meta.CachedPropertyEngineObject;
import com.filenet.apiimpl.meta.CachedPropertyEngineObjectList;
import com.filenet.apiimpl.meta.CachedPropertyEngineObjectSet;
import com.filenet.apiimpl.meta.Util;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;

class CachedClassDescription
extends ClassDescriptionImpl
implements CachedObject {
    private final Cache cache;
    private final InstantiatingScope scope;
    private static final Util util = Util.INSTANCE;
    private static final Constructor classDescriptionConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                Class[] params = new Class[]{Connection.class, String.class, ObjectReferenceBase.class};
                Constructor c = ClassDescriptionImpl.class.getDeclaredConstructor(params);
                c.setAccessible(true);
                return c;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    });

    CachedClassDescription(Cache cache, InstantiatingScope scope, ClassDescriptionImpl object) {
        super(object.getConnection(), object.getObjectReference().getClassIdentity(), (ObjectReferenceBase)object.getObjectReference());
        this.cache = cache;
        this.scope = scope;
        this.setObject(object);
        this.wrapProperties(this);
    }

    private void wrapProperties(EngineObjectImpl object) {
        PropertiesImpl props = object.getPropertiesImpl();
        Iterator i = props.iterator();
        while (i.hasNext()) {
            Object instance;
            PropertyImpl property;
            PropertyImpl value = (PropertyImpl)i.next();
            if (value instanceof CachedObject) continue;
            if (value instanceof PropertyEngineObjectImpl) {
                property = (PropertyEngineObjectImpl)value;
                instance = property.getInstanceValue();
                if (instance instanceof IndependentObject) {
                    instance = ((IndependentObject)instance).getObjectReference();
                    property.setInstanceValue(instance);
                }
                if (util.isClassDescriptionReference(instance)) {
                    if (this.getObjectReference().equals(instance)) {
                        property.setInstanceValue(this);
                    } else {
                        props.put(new CachedPropertyClassDescription(this, (PropertyEngineObjectImpl)property));
                    }
                } else if (instance != null) {
                    props.put(new CachedPropertyEngineObject(this, (PropertyEngineObjectImpl)property));
                }
                if (!(instance instanceof EngineObjectImpl)) continue;
                this.wrapProperties((EngineObjectImpl)instance);
                continue;
            }
            if (value instanceof PropertyEngineObjectListImpl) {
                property = (PropertyEngineObjectListImpl)value;
                instance = property.getInstanceValue();
                if (instance instanceof ListImpl) {
                    this.wrapProperties((ListImpl)instance);
                    continue;
                }
                if (!(instance instanceof UnevaluatedPropertyValue)) continue;
                props.put(new CachedPropertyEngineObjectList(this, (PropertyEngineObjectListImpl)property));
                continue;
            }
            if (!(value instanceof PropertyEngineObjectSetImpl)) continue;
            property = (PropertyEngineObjectSetImpl)value;
            if (util.isClassDescriptionPropertyUnevaluatedSet(property)) {
                props.put(new CachedPropertyClassDescriptionSet(this, (PropertyEngineObjectSetImpl)property));
                continue;
            }
            if (property.getInstanceValue() == null) continue;
            props.put(new CachedPropertyEngineObjectSet(this, (PropertyEngineObjectSetImpl)property));
        }
    }

    void wrapProperties(ListImpl value) {
        if (value == null) {
            return;
        }
        List list = value.getOriginalList();
        if (list == null || list.size() == 0) {
            return;
        }
        for (Object element : list) {
            if (!(element instanceof EngineObjectImpl)) continue;
            this.wrapProperties((EngineObjectImpl)element);
        }
    }

    Cache getCache() {
        return this.cache;
    }

    InstantiatingScope getInstantiatingScope() {
        return this.scope;
    }

    @Override
    public Scope getScope() {
        return util.createScope(this.scope);
    }

    @Override
    public Boolean describedIsOfClass(String className) {
        return this.cache.describedIsOfClass(this, className);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void refresh(String[] propertyNames) {
    }

    @Override
    public void refresh(PropertyFilter filter) {
    }

    @Override
    public void fetchProperties(String[] propertyNames) {
    }

    @Override
    public void fetchProperties(PropertyFilter filter) {
    }

    @Override
    public Property fetchProperty(String propertyName, PropertyFilter pf) {
        return this.getProperty(propertyName);
    }

    @Override
    public Property fetchProperty(String propertyName, PropertyFilter pf, Integer pageSize) {
        return this.getProperty(propertyName);
    }

    @Override
    protected Class getEqualsClass() {
        return ClassDescriptionImpl.class;
    }

    private Object writeReplace() throws ObjectStreamException {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Object[] args = new Object[]{CachedClassDescription.this.getConnection(), CachedClassDescription.this.getObjectReference().getClassIdentity(), CachedClassDescription.this.getObjectReference()};
                    ClassDescriptionImpl cd = (ClassDescriptionImpl)classDescriptionConstructor.newInstance(args);
                    cd.setObject(CachedClassDescription.this);
                    return cd;
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        });
    }
}

