/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.perflog;

import com.filenet.apiimpl.perflog.AuditEntry;
import com.filenet.apiimpl.perflog.AuditInterval;
import com.filenet.apiimpl.perflog.PerfAuditEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;

public class Perflog {
    public static final int LOGGING_DEFAULT = 1;
    public static final int LOGGING_SQL_STATEMENT = 2;
    public static final int LOGGING_CE_QUERY = 3;
    public static final int LOGGING_GCD = 4;
    public static final int LOGGING_CBR_QUERY = 5;
    public static final int LOGGING_CONTENT = 6;
    public static final int LOGGING_CPU = 10;
    public static final int LOGGING_SCHEDULEDTASK = 15;
    public static final int LOGGING_WORKERTASK = 16;
    public static final int LOGGING_CALLSTACK = 20;
    public static final long FILE_SIZE_BASE = 0x100000L;
    public static final int FILE_SIZE_MAX = 1024;
    public static final int FILE_SIZE_MIN = 1;
    public static final int MAX_FILE_INDEX_DEFAULT = -1;
    public static final String PRINTSPACE = "     \t";
    public static final String LINE_HEADER = "#Audit#-";
    public static final String PERF_HEADLINE = "#Audit#-\tTOTAL/AVE_TIME  FAILURE/AVE_TIME    TYPE";
    public static final String AUDIT_INTERVALS_STR = "1:10:60:240";
    public static final String AUDIT_OFF = "0";
    private Vector intervalVec = new Vector();
    private AuditInterval headInterval = null;
    private AuditInterval sinkInterval = new AuditInterval(0);
    protected PrintWriter pw = null;
    private static PrintStream errStream = null;
    private HashMap loggingLevelMap = new HashMap();
    private String baseFileName;
    private long maxFileSize = 0x6400000L;
    private long curFileSize = 0L;
    private int maxFileIndex = 5;
    private boolean verbose = true;
    private static final String prefix = "[Perf Log] ";
    protected String auditorDir = null;
    protected String propfileName = null;
    protected String AUDIT_CONFIG_FILE = "perflog_config.properties";
    protected long fileLastChecked = 0L;
    protected boolean checking = false;
    protected long lastChecked = 0L;
    protected long systemStartTime = System.currentTimeMillis();
    protected long checkingInterval = 30L;
    protected boolean enableDump = false;
    protected int dumpsCount = 0;
    protected int dumpWaitInterval = 0;
    protected Integer dumpFilterTime = null;
    protected OutputStream threadDumpOS = null;
    protected volatile boolean dumping = false;
    protected long nextDumpTime = 0L;
    protected String counterWithStack = null;
    protected static long timesThreshHold = 0L;
    protected static long durationThreshHold = 0L;
    protected long cpucollectinterval = 10L;
    protected LinkedList<Method> dumpCallbacks = new LinkedList();
    protected ConcurrentHashMap<Long, List<Object>> threadMsgs = new ConcurrentHashMap();
    protected boolean isThreadMsg = false;
    String newline = System.getProperty("line.separator");
    static ThreadMXBean threadBean = null;
    static boolean isCPUSupported = false;
    private static final Perflog instance = new Perflog();

    public static Perflog Instance() {
        return instance;
    }

    public void countIn(String name, Method callback) {
        if (this.headInterval != null && this.loggingLevelMap.keySet().size() == 1) {
            this.headInterval.countIn(name, callback);
        }
    }

    public void countIn(int level, String name, Method callback) {
        if (this.headInterval != null && this.loggingLevelMap.containsKey(Integer.valueOf(level).toString())) {
            this.headInterval.countIn(name, callback);
        }
    }

    public void countInStack(String type, long time, boolean successful) {
        if (this.headInterval != null) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StackTraceElement[] s = e.getStackTrace();
                String log = "";
                int index = 1;
                boolean cont = true;
                while (cont) {
                    if (s[index].getClassName().startsWith("com.filenet")) {
                        log = s[index].getClassName() + "." + s[index].getMethodName() + "() - line " + s[index].getLineNumber();
                        cont = false;
                    }
                    ++index;
                }
                this.headInterval.countIn(type + " : " + log, time, successful);
            }
        }
    }

    public void countIn(String type, long time, boolean successful) {
        this.countIn(type, time, successful, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countIn(String type, long time, boolean successful, long unit) {
        try {
            long current = System.currentTimeMillis();
            if (current - this.lastChecked > this.checkingInterval * 1000L && this.propfileName != null && !this.checking) {
                Perflog perflog = this;
                synchronized (perflog) {
                    if (current - this.lastChecked > this.checkingInterval * 1000L) {
                        try {
                            long t;
                            this.checking = true;
                            File f = new File(this.propfileName);
                            if (f.exists() && (t = f.lastModified()) > this.fileLastChecked) {
                                this.setupWithPropertyFile(new File(this.propfileName.substring(0, this.propfileName.indexOf(this.AUDIT_CONFIG_FILE))));
                                this.fileLastChecked = t;
                            }
                        }
                        finally {
                            this.checking = false;
                        }
                    }
                }
                this.lastChecked = current;
            }
            if (this.enableDump) {
                this.checkDump();
            }
            if (this.headInterval != null) {
                this.headInterval.countIn(type, time, successful, unit);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void checkDump() {
        long currentTime = System.currentTimeMillis();
        if (this.enableDump && currentTime > this.nextDumpTime && !this.dumping) {
            this.dumpOnce();
        }
    }

    public void countIn(int level, String type, long time, boolean successful) {
        if (this.headInterval != null && this.loggingLevelMap.containsKey(Integer.valueOf(level).toString())) {
            if (level == 10) {
                if (isCPUSupported) {
                    this.headInterval.countIn(type, time, successful, 1000000L);
                }
            } else {
                this.headInterval.countIn(type, time, successful);
            }
        }
    }

    public void countIn(AuditEntry entry) {
        if (this.headInterval != null) {
            this.headInterval.countIn(entry);
        }
    }

    public boolean isSQLEnabled() {
        return this.loggingLevelMap.containsKey(Integer.valueOf(2).toString());
    }

    public boolean isIntLevelEnabled(int level) {
        return this.loggingLevelMap.containsKey(Integer.valueOf(level).toString());
    }

    public boolean isLevelEnabled(String level) {
        return this.loggingLevelMap.containsKey(level);
    }

    public void addLoggingLevel(String level) {
        if (!this.loggingLevelMap.containsKey(level)) {
            this.loggingLevelMap.put(level, null);
        }
    }

    public boolean isEnabled() {
        return this.headInterval != null;
    }

    private Perflog() {
        String auditorDir;
        String intervalStr;
        String loggingLevel;
        String maxFileSize;
        errStream = System.out;
        Properties props = new Properties();
        String verb = System.getProperty("perflog.verbose");
        if (verb != null) {
            props.put("perflog.verbose", verb);
        }
        if ((maxFileSize = System.getProperty("perflog.maxfilesize")) != null) {
            props.put("perflog.maxfilesize", maxFileSize);
            props.put("perflog.maxfileindex", System.getProperty("perflog.maxfileindex"));
        }
        if ((loggingLevel = System.getProperty("perflog.logginglevel")) == null) {
            loggingLevel = System.getProperty("filenet.perflog.logginglevel");
        }
        if (loggingLevel != null) {
            props.put("perflog.logginglevel", loggingLevel);
        }
        if ((intervalStr = System.getProperty("perflog.interval")) == null) {
            intervalStr = System.getProperty("filenet.perflog.interval");
        }
        if (intervalStr != null) {
            props.put("perflog.interval", intervalStr);
        }
        if ((auditorDir = System.getProperty("perflog.dir")) == null) {
            auditorDir = System.getProperty("filenet.perflog.dir");
        }
        if (auditorDir != null) {
            props.put("perflog.dir", auditorDir);
        }
        this.initialize(props);
    }

    public void initialize(Properties props) {
        String counterStack;
        String verbosegc;
        String intervalStr;
        String cpuIntervalStr;
        String chkIntStr;
        String maxFileSize;
        String verb = props.getProperty("perflog.verbose");
        if (verb != null && verb.equalsIgnoreCase("on")) {
            this.verbose = true;
        }
        if (verb != null && verb.equalsIgnoreCase("off")) {
            this.verbose = false;
        }
        if ((maxFileSize = props.getProperty("perflog.maxfilesize")) != null && maxFileSize.length() > 0) {
            this.maxFileSize = Math.max(Math.min(new Integer(maxFileSize), 1024), 1);
            this.maxFileSize *= 0x100000L;
            String maxFileIndex = props.getProperty("perflog.maxfileindex");
            this.maxFileIndex = maxFileIndex != null && maxFileIndex.length() > 0 ? Math.max(new Integer(maxFileIndex), -1) : -1;
        }
        String loggingLevel = props.getProperty("perflog.logginglevel");
        this.loggingLevelMap.clear();
        this.loggingLevelMap.put(new Integer(1).toString(), null);
        if (loggingLevel != null && loggingLevel.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(loggingLevel, ":");
            while (tokens.hasMoreTokens()) {
                this.loggingLevelMap.put(tokens.nextToken().trim(), null);
            }
        }
        if ((chkIntStr = props.getProperty("perflog.checkinginterval")) != null) {
            int intval;
            block31: {
                intval = 0;
                try {
                    intval = Integer.parseInt(chkIntStr);
                }
                catch (NumberFormatException e) {
                    if (!this.verbose) break block31;
                    errStream.println("[Perf Log] ignored invalid perflog.checkinginterval: " + chkIntStr);
                }
            }
            if (intval > 0) {
                this.checkingInterval = intval;
            }
        }
        if ((cpuIntervalStr = props.getProperty("perflog.cpucollectinterval")) != null) {
            int intval;
            block32: {
                intval = 10;
                try {
                    intval = Integer.parseInt(cpuIntervalStr);
                }
                catch (NumberFormatException e) {
                    if (!this.verbose) break block32;
                    errStream.println("[Perf Log] ignored invalid perflog.checkinginterval: " + chkIntStr);
                }
            }
            if (intval > 0) {
                this.cpucollectinterval = intval;
            }
        }
        if ((intervalStr = props.getProperty("perflog.interval")) == null || intervalStr.length() == 0 || intervalStr.trim().equals("") || intervalStr.trim().equals("off")) {
            intervalStr = AUDIT_OFF;
        } else if (intervalStr.trim().equals("on")) {
            intervalStr = AUDIT_INTERVALS_STR;
        }
        this.auditorDir = props.getProperty("perflog.dir");
        if ((this.auditorDir == null || this.auditorDir.length() == 0) && this.propfileName != null) {
            this.auditorDir = this.propfileName.substring(0, this.propfileName.indexOf(this.AUDIT_CONFIG_FILE));
        }
        if (this.auditorDir != null) {
            this.auditorDir.trim();
        }
        if (this.auditorDir == null || this.auditorDir.length() == 0 || this.auditorDir.trim().equals("") || !new File(this.auditorDir).exists()) {
            intervalStr = AUDIT_OFF;
        }
        String dumpThread = props.getProperty("perflog.dumpthreads");
        this.setupThreadDump(dumpThread);
        String dumpHeap = props.getProperty("perflog.dumpheap");
        if (dumpHeap != null) {
            dumpHeap = dumpHeap.trim();
        }
        if (dumpHeap != null && (dumpHeap.equalsIgnoreCase("true") || dumpHeap.equalsIgnoreCase("withGC"))) {
            this.dumpHeap(dumpHeap);
        }
        if ((verbosegc = props.getProperty("perflog.verbosegc")) != null) {
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            boolean isverbose = mbean.isVerbose();
            if (verbosegc.equalsIgnoreCase("true") && !isverbose) {
                mbean.setVerbose(true);
            } else if (verbosegc.equalsIgnoreCase("false")) {
                mbean.setVerbose(false);
            }
        }
        this.counterWithStack = (counterStack = props.getProperty("perflog.counterwithstack")) != null && counterStack.trim().length() > 0 ? counterStack.trim() : null;
        String printThreshHold = props.getProperty("perflog.printthreshhold");
        if (printThreshHold != null && printThreshHold.trim().length() > 0) {
            StringTokenizer tokens = new StringTokenizer(printThreshHold, ":");
            try {
                if (tokens.hasMoreTokens()) {
                    String timesT = tokens.nextToken();
                    timesThreshHold = Long.valueOf(timesT);
                }
                if (tokens.hasMoreTokens()) {
                    String durationT = tokens.nextToken();
                    durationThreshHold = Long.valueOf(durationT);
                }
            }
            catch (Exception exception) {}
        } else {
            timesThreshHold = 0L;
            durationThreshHold = 0L;
        }
        this.initPerfInterval(intervalStr);
        this.setPerfLogFile("perf.log");
    }

    public void dumpHeap(String dumpOption) {
        if (dumpOption.equalsIgnoreCase("withGC")) {
            System.gc();
        }
        if (dumpOption.equalsIgnoreCase("true") || dumpOption.equalsIgnoreCase("withGC")) {
            String javaVersion = System.getProperty("java.version");
            String javaVendor = System.getProperty("java.vendor").toUpperCase();
            Date d = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("MMddHHmmss");
            String fileName = this.auditorDir.trim() + File.separator + "perf_heap_dump" + formatter.format(d);
            boolean live = true;
            String jver = javaVersion.substring(0, 3);
            float javaVersionF = Float.valueOf(jver).floatValue();
            try {
                if (javaVendor.startsWith("IBM")) {
                    Perflog.IBMJavaDumper();
                } else if (javaVendor.startsWith("SUN") && (double)javaVersionF >= 1.6) {
                    Perflog.dumpHeap(fileName, live);
                } else if (javaVendor.startsWith("ORACLE") && (double)javaVersionF >= 1.6) {
                    Perflog.dumpHeap(fileName, live);
                } else {
                    errStream.println(" can not dump heap for java :" + javaVendor + " " + javaVersion);
                }
            }
            catch (Throwable t) {
                errStream.println(" error dump heap " + t.getMessage());
            }
        }
    }

    public static void IBMJavaDumper() {
        try {
            Class<?> c = Class.forName("com.ibm.jvm.Dump");
            Method m = c.getMethod("HeapDump", null);
            m.invoke(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void dumpHeap(String fileName, boolean live) {
        String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
        try {
            Class<?> c = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, c);
            ArrayList<Class> argL = new ArrayList<Class>();
            argL.add(String.class);
            argL.add(Boolean.class);
            Class[] argTypes = new Class[]{String.class, Boolean.TYPE};
            Method m = bean.getClass().getMethod("dumpHeap", argTypes);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(fileName);
            list.add(true);
            m.invoke(bean, list.toArray());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public void setupThreadDump(String str) {
        block11: {
            if (str == null || str.length() <= 0 || str.indexOf(":") < 0) {
                this.enableDump = false;
                return;
            }
            String[] strs = str.split(":");
            if (strs.length < 2) {
                this.enableDump = false;
                return;
            }
            this.dumpsCount = Integer.parseInt(strs[0].trim());
            this.dumpWaitInterval = Integer.parseInt(strs[1].trim());
            if (strs.length >= 3) {
                this.dumpFilterTime = Integer.parseInt(strs[2].trim());
                if (this.dumpFilterTime < 0) {
                    this.dumpFilterTime = null;
                }
            } else {
                this.dumpFilterTime = null;
            }
            if (this.dumpsCount <= 0 || this.dumpWaitInterval <= 0 && this.dumpsCount > 1 || this.auditorDir == null) {
                return;
            }
            File auditFolder = new File(this.auditorDir);
            if (!auditFolder.exists()) {
                return;
            }
            if (this.verbose) {
                errStream.println("[Perf Log]  setting up the threads dumps for " + this.dumpsCount + " times and " + this.dumpWaitInterval + " interval");
            }
            try {
                Date d = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("MMddHHmmss");
                this.threadDumpOS = new FileOutputStream(new File(this.auditorDir.trim() + File.separator + "perf_thread_dump" + formatter.format(d)));
            }
            catch (FileNotFoundException e) {
                if (!this.verbose) break block11;
                errStream.println("[Perf Log] error creating the file for dumping threads ");
            }
        }
        if (this.threadDumpOS != null) {
            this.enableDump = true;
            this.nextDumpTime = System.currentTimeMillis();
        }
    }

    public void addDumpCallback(Method method) {
        this.dumpCallbacks.add(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void dumpOnce() {
        this.isThreadMsg = true;
        if (System.currentTimeMillis() < this.nextDumpTime) {
            return;
        }
        this.dumping = true;
        try {
            if (this.threadDumpOS != null) {
                try {
                    this.dumpThreads(this.threadDumpOS);
                    if (null != this.dumpFilterTime && this.dumpFilterTime != 0) ** GOTO lbl25
                    this.threadDumpOS.write((" dumping background tasks now " + new Date() + this.newline).getBytes());
                    for (Method m : this.dumpCallbacks) {
                        this.threadDumpOS.write(this.newline.getBytes());
                        str = "";
                        try {
                            str = str + m.invoke(null, null);
                        }
                        catch (Exception var4_6) {
                            // empty catch block
                        }
                        this.threadDumpOS.write(str.getBytes());
                    }
                }
                catch (Throwable var1_2) {}
            } else {
                this.enableDump = false;
            }
lbl25:
            // 4 sources

            --this.dumpsCount;
            if (this.dumpsCount > 0) {
                this.nextDumpTime = System.currentTimeMillis() + (long)(this.dumpWaitInterval * 1000);
            } else {
                this.enableDump = false;
            }
        }
        finally {
            this.dumping = false;
            if (this.dumpsCount <= 0) {
                try {
                    this.enableDump = false;
                    this.threadDumpOS.flush();
                    this.threadDumpOS.close();
                    this.threadDumpOS = null;
                    this.isThreadMsg = false;
                }
                catch (Exception var1_3) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPerfInterval(String intervals) {
        Perflog perflog = this;
        synchronized (perflog) {
            this.headInterval = null;
            this.intervalVec.clear();
        }
        if (intervals.equalsIgnoreCase(AUDIT_OFF)) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(intervals, ":");
        while (tok.hasMoreTokens()) {
            int iTemp;
            String str = tok.nextToken();
            if (this.verbose) {
                errStream.println("[Perf Log] Interval configuration: " + str);
            }
            if ((iTemp = Integer.parseInt(str.trim())) == 0) {
                this.headInterval = null;
                if (this.verbose) {
                    errStream.println("[Perf Log] No interval provided. Auditor disabled.");
                }
                return;
            }
            this.intervalVec.add(new AuditInterval(iTemp));
        }
        this.intervalVec.add(this.sinkInterval);
        for (int i = this.intervalVec.size() - 2; i >= 0; --i) {
            ((AuditInterval)this.intervalVec.elementAt(i)).setNextInterval((AuditInterval)this.intervalVec.elementAt(i + 1));
        }
        this.headInterval = (AuditInterval)this.intervalVec.elementAt(0);
        if (this.headInterval == null && this.verbose) {
            errStream.println("[Perf Log] No interval provided. Auditor disabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEntry(String log) {
        if (this.maxFileSize > 0L) {
            int strLength = log.getBytes().length;
            this.curFileSize += (long)strLength;
            if (this.curFileSize > this.maxFileSize) {
                Perflog perflog = this;
                synchronized (perflog) {
                    if (this.curFileSize > this.maxFileSize) {
                        this.pw.close();
                        this.rollPerflogFiles();
                        this.curFileSize = 0L;
                        this.setPerfLogFile(this.baseFileName);
                    }
                }
            }
        }
        this.pw.print(log);
        this.pw.flush();
    }

    public void rollPerflogFiles() {
        try {
            boolean rollSuccess = true;
            String baseFile = (this.auditorDir + File.separator + this.baseFileName).trim();
            if (this.maxFileIndex > 0) {
                File target;
                File file = new File(baseFile + '.' + this.maxFileIndex);
                if (file.exists()) {
                    rollSuccess = file.delete();
                }
                for (int i = this.maxFileIndex - 1; i >= 1 && rollSuccess; --i) {
                    file = new File(baseFile + "." + i);
                    if (!file.exists()) continue;
                    target = new File(baseFile + '.' + (i + 1));
                    rollSuccess = file.renameTo(target);
                }
                if (rollSuccess) {
                    target = new File(baseFile + "." + 1);
                    file = new File(baseFile);
                    rollSuccess = file.renameTo(target);
                }
                if (!rollSuccess) {
                    errStream.println("Perflog file rollover failed ");
                }
            }
        }
        catch (Exception e) {
            errStream.println("Perflog file rollover failed due to exception :" + e.getMessage());
        }
    }

    public static long getCpuTime() {
        if (threadBean == null && (threadBean = ManagementFactory.getThreadMXBean()) != null) {
            isCPUSupported = threadBean.isCurrentThreadCpuTimeSupported();
        }
        if (isCPUSupported && threadBean != null) {
            long cpuTime = 0L;
            try {
                cpuTime = threadBean.getCurrentThreadCpuTime();
            }
            catch (Throwable t) {
                if (errStream != null) {
                    errStream.println(" Exception when calling threadBean.getCurrentThreadCpuTime(), getCPUTime is disabled." + t.getMessage());
                }
                isCPUSupported = false;
            }
            return cpuTime;
        }
        return 0L;
    }

    public void dumpThreads(OutputStream os) {
        block19: {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threads = bean.getThreadInfo(bean.getAllThreadIds(), Integer.MAX_VALUE);
            HashMap<Long, Long> mapCPU = new HashMap<Long, Long>();
            for (ThreadInfo info : threads) {
                long threadCPU = bean.getThreadCpuTime(info.getThreadId());
                mapCPU.put(info.getThreadId(), threadCPU);
            }
            try {
                Thread.sleep(this.cpucollectinterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            threads = bean.getThreadInfo(bean.getAllThreadIds(), Integer.MAX_VALUE);
            try {
                boolean isFirst = true;
                for (ThreadInfo info : threads) {
                    StackTraceElement[] els;
                    long threadId = info.getThreadId();
                    boolean filteredOut = false;
                    Long elapseTime = null;
                    if (this.dumpFilterTime != null) {
                        long currentTime = System.currentTimeMillis();
                        List<Object> l = this.threadMsgs.get(threadId);
                        Object o = null;
                        if (null != l && l.size() >= 1) {
                            long startTime;
                            o = l.get(0);
                            if (null != o && o instanceof Long && (elapseTime = Long.valueOf(currentTime - (startTime = ((Long)o).longValue()))) < (long)(this.dumpFilterTime * 1000)) {
                                filteredOut = true;
                            }
                        } else {
                            filteredOut = true;
                        }
                    }
                    if (filteredOut) continue;
                    if (isFirst) {
                        os.write(this.newline.getBytes());
                        os.write(this.newline.getBytes());
                        os.write((" dumping  threads now " + new Date() + this.newline).getBytes());
                        isFirst = false;
                    }
                    long threadCPU = bean.getThreadCpuTime(info.getThreadId());
                    Object previousCPUObject = mapCPU.get(threadId);
                    long previousCPU = 0L;
                    if (previousCPUObject != null) {
                        previousCPU = (Long)previousCPUObject;
                    }
                    String CPUUsage = "";
                    if (previousCPUObject != null) {
                        CPUUsage = " CPU percent=" + (threadCPU - previousCPU) / 10000L / this.cpucollectinterval;
                    }
                    String ElapseString = "";
                    if (elapseTime != null) {
                        ElapseString = " CPE ElapseTime=" + elapseTime;
                    }
                    os.write(("" + this.dumpsCount + " " + info.getThreadName() + " (ID=" + info.getThreadId() + ")  State=" + (Object)((Object)info.getThreadState()) + " LockName=" + info.getLockName() + " LockOwnerId=" + info.getLockOwnerId() + " LockOwnerName=" + info.getLockOwnerName() + " threadCpu=" + threadCPU + CPUUsage + ElapseString + this.newline).getBytes());
                    List<Object> l = this.threadMsgs.get(threadId);
                    if (l != null) {
                        for (Object o : l) {
                            if (o instanceof Object[]) {
                                Object[] objectArray = (Object[])o;
                                int n = objectArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Object oo = objectArray[i];
                                    os.write((" " + oo.toString()).getBytes());
                                }
                                os.write(this.newline.getBytes());
                                continue;
                            }
                            os.write((" " + o.toString() + this.newline).getBytes());
                        }
                    }
                    for (StackTraceElement el : els = info.getStackTrace()) {
                        os.write(("  " + this.dumpsCount + "  " + el.toString() + this.newline).getBytes());
                    }
                }
            }
            catch (Throwable t) {
                if (!this.verbose) break block19;
                errStream.println("[Perf Log] error when dumping threads " + t.getMessage());
            }
        }
    }

    public boolean isThreadMsg() {
        return this.isThreadMsg;
    }

    public void addThreadMsg(Object o) {
        long threadId = Thread.currentThread().getId();
        this.addThreadMsg(threadId, o);
    }

    public void addThreadMsg(long threadId, Object o) {
        if (null == o) {
            return;
        }
        List<Object> l = this.threadMsgs.get(threadId);
        if (l != null) {
            if (l.size() > 1000) {
                l.clear();
            }
            if (l.size() == 0) {
                l.add(System.currentTimeMillis());
            }
            l.add(o);
        } else {
            l = new ArrayList<Object>();
            if (l.size() == 0) {
                l.add(System.currentTimeMillis());
            }
            l.add(o);
            this.threadMsgs.put(threadId, l);
        }
        if (this.enableDump) {
            this.checkDump();
        }
    }

    public void removeThreadMsg(Object o) {
        this.removeThreadMsg(Thread.currentThread().getId(), o);
    }

    public void removeThreadMsg(long threadId, Object o) {
        if (null == o) {
            return;
        }
        List<Object> l = this.threadMsgs.get(threadId);
        if (null == l) {
            return;
        }
        l.remove(o);
    }

    public void clearThreadMsgs() {
        this.clearThreadMsgs(Thread.currentThread().getId());
    }

    public void clearThreadMsgs(long threadId) {
        List<Object> l = this.threadMsgs.remove(threadId);
    }

    public void setConfigDirectory(String folderName) {
        File folder = new File(folderName);
        if (folder.exists() && folder.isDirectory()) {
            if (this.verbose) {
                errStream.println("[Perf Log]  setup perflog with config properties file in: " + folderName);
            }
            this.setupWithPropertyFile(folder);
        } else {
            errStream.println(prefix + folderName + " does not exist or not a folder");
        }
    }

    public void setPerfLogFile(String filename) {
        this.baseFileName = filename;
        this.setPerfLogFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupWithPropertyFile(File folder) {
        block29: {
            try {
                if (!folder.exists() || !folder.isDirectory()) {
                    if (this.verbose) {
                        errStream.println("[Perf Log]  can not proceed setup with properties files when folder does not exists :" + folder.getAbsolutePath());
                    }
                    return;
                }
                this.propfileName = folder.getAbsolutePath() + File.separator + this.AUDIT_CONFIG_FILE;
                File propFile = new File(this.propfileName);
                if (!propFile.exists()) {
                    try {
                        FileOutputStream os = new FileOutputStream(propFile);
                        os.write(("# configuration file for the perflog utility" + this.newline).getBytes());
                        os.write(("# use.me=true will turn on to use this property file instead of the Java commond line args" + this.newline).getBytes());
                        os.write((" use.me=false" + this.newline).getBytes());
                        os.write(("# perflog.interval=on or perflog.interval=1:10:60:240, turn on the perflog with 1 minute accumulation interval, followed by 10, 60, 240 minutes " + this.newline).getBytes());
                        os.write((" perflog.interval=on " + this.newline).getBytes());
                        os.write(("# perflog.dir=< log file location>, default to the CE tracelog directory" + this.newline).getBytes());
                        os.write(("# perflog.dir=c:/temp " + this.newline).getBytes());
                        os.write(("# perflog.logginglevel=2:3:4:5:6:10:15:16, where 2->CE DB, 3->CE Query, 4->GCD 5->CBR query, 6->content 10->CPU time 15->ScheduledBackgroundTask 16->WorkerBackgroundTask 102->PE DB 110->PE CPU 115->PE background task" + this.newline).getBytes());
                        os.write((" perflog.logginglevel=2:3:5:10" + this.newline).getBytes());
                        os.write(("# perflog.dumpthreads=<times>:<interval> will dump threads stacks to a file, <times> with <interval> elapse time in between " + this.newline).getBytes());
                        os.write(("# perflog.dumpheap=true/false/withGC, for IBM Java 5 and Sun/JRockit JDK 6 only. If \"true\" will dump heap, if \"withGC\", will do a GC and then dump heap " + this.newline).getBytes());
                        os.write(("# perflog.verbosegc=true/false to turn on or off the verbose gc dynamically, could overwrite the commandline" + this.newline).getBytes());
                        os.write(("# perflog.counterwithstack=<counter name> add stack elements for the specific counter" + this.newline).getBytes());
                        os.write(("perflog.printthreshhold=60:100   the counter will not in the output if it is called less than (60) times and total duration is less than (100)ms" + this.newline).getBytes());
                        os.write(("# perflog.cpucollectinterval=<> default 10 ms, when dumping threads, what is the time span to collect CPU usage percentage" + this.newline).getBytes());
                        os.write(("# perflog.checkinginterval=<> default 30 (seconds), how often to check for config file change" + this.newline).getBytes());
                        os.write(("# perflog.maxfilesize=<> default 100 (MB),  the perflog file size before rolling" + this.newline).getBytes());
                        os.write(("# perflog.maxfileindex=<> default 5 , how many total perflog file rolled before be deleted, like perf.log.5 " + this.newline).getBytes());
                        os.flush();
                        os.close();
                    }
                    catch (FileNotFoundException e) {
                        if (this.verbose) {
                            errStream.println("[Perf Log]  property file does not exists : " + this.propfileName);
                        }
                        break block29;
                    }
                    catch (IOException e) {
                        if (this.verbose) {
                            errStream.println("[Perf Log]  error with IOException: " + e.getMessage());
                        }
                        break block29;
                    }
                }
                Properties props = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(propFile);
                    props.load(fis);
                    String useMe = props.getProperty("use.me");
                    if (useMe != null && useMe.trim().equalsIgnoreCase("true")) {
                        this.initialize(props);
                    }
                }
                catch (FileNotFoundException e) {
                    if (this.verbose) {
                        errStream.println("[Perf Log]  property file does not exists : " + this.propfileName);
                    }
                }
                catch (IOException e) {
                    if (this.verbose) {
                        errStream.println("[Perf Log]  error with IOException: " + e.getMessage());
                    }
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable t) {
                if (!this.verbose) break block29;
                errStream.println("[Perf Log]  error with configuring the perf log " + t.getMessage());
            }
        }
    }

    private void setPerfLogFile() {
        if (this.headInterval == null) {
            if (this.verbose) {
                errStream.println("[Perf Log] No interval found. Auditor disabled.");
            }
            return;
        }
        this.auditorDir = this.auditorDir.trim();
        if (this.auditorDir == null || this.auditorDir.length() == 0 || this.auditorDir.trim().equals("") || this.baseFileName == null || this.baseFileName.length() == 0 || this.baseFileName.trim().equals("")) {
            if (this.verbose) {
                errStream.println("[Perf Log] Cannot log perf into file. Write to the console instead : " + this.auditorDir + "|" + this.baseFileName);
            }
            this.pw = new PrintWriter(errStream);
        } else {
            String auditorFile = this.auditorDir + File.separator + this.baseFileName;
            File f = new File(auditorFile);
            if (f.exists()) {
                this.curFileSize = f.length();
            }
            try {
                if (this.pw != null) {
                    try {
                        this.pw.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(auditorFile, true)));
                if (this.verbose) {
                    errStream.println("[Perf Log] Auditor File (reset): " + auditorFile);
                }
            }
            catch (Exception e) {
                if (this.verbose) {
                    errStream.println("[Perf Log] Cannot log perf into file. Write to the console instead : " + this.auditorDir);
                    errStream.println(e.getMessage());
                }
                this.pw = new PrintWriter(errStream);
            }
        }
    }

    protected String getCounterWithStack() {
        return this.counterWithStack;
    }

    public static void main(String[] args) {
        Perflog.getCpuTime();
        Perflog.Instance().setConfigDirectory("c:\\temp\\perflog");
        for (int j = 0; j < 5; ++j) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long cur = System.currentTimeMillis();
                    Random ran = new Random(System.currentTimeMillis());
                    for (int i = 0; i < 10000000; ++i) {
                        1 var5_6 = this;
                        synchronized (var5_6) {
                        }
                        int typeSeq = ran.nextInt(1000);
                        String type = "auditType" + typeSeq;
                        boolean fail = true;
                        if (i % 3 == 0) {
                            fail = false;
                        }
                        Perflog.Instance().countIn(type, Perflog.getCpuTime(), true, 1000000L);
                        Perflog.Instance().addThreadMsg(" SQL messge q");
                        Perflog.Instance().addThreadMsg(" SQL messge r");
                        Perflog.Instance().addThreadMsg(" SQL messge s");
                        Perflog.Instance().addThreadMsg(" SQL messge t");
                        PerfAuditEntry entry = new PerfAuditEntry(type);
                        entry.start();
                        try {
                            for (int j = 0; j < 1000000; ++j) {
                                ran.nextInt(ran.nextInt(100));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Perflog.Instance().clearThreadMsgs(Thread.currentThread().getId());
                        Perflog.Instance().countIn(entry);
                    }
                    long end = System.currentTimeMillis();
                }
            }.start();
        }
    }
}

