/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyEngineObject;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class PropertyEngineObjectImpl
extends PropertyImpl
implements PropertyEngineObject {
    private static final long serialVersionUID = -4617414835480968796L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public PropertyEngineObjectImpl(String propertyName, byte access) {
        super(propertyName, null, access);
    }

    public PropertyEngineObjectImpl(String propertyName, EngineObject val, byte access) {
        super(propertyName, val, access);
        this.connection = val != null ? val.getConnection() : null;
    }

    public PropertyEngineObjectImpl(String propertyName, ObjectReferenceBase obj, Connection connection, byte access) {
        super(propertyName, obj, access);
        this.connection = connection;
    }

    public PropertyEngineObjectImpl(UnevaluatedPropertyValue obj, Connection connection, byte access) {
        super(obj.getPropertyName(), obj, access);
        this.connection = connection;
    }

    public PropertyEngineObjectImpl(String propertyName, EngineRuntimeException retrievalError) {
        super(propertyName, retrievalError, (byte)1);
    }

    public PropertyEngineObjectImpl(PropertyEngineObjectImpl source) {
        super(source);
    }

    @Override
    PropertyImpl getModifiedData(EngineObject parent) {
        if (!this.isDirty()) {
            return null;
        }
        PropertyEngineObjectImpl ret = new PropertyEngineObjectImpl(this.getPropertyName(), null, this.connection, this.access);
        ret.value = this.getObjectReference();
        ret.isDirty = this.isDirty;
        return ret;
    }

    @Override
    public void setValue(EngineObject val) {
        super.setValue(val);
        this.connection = val != null ? val.getConnection() : null;
    }

    @Override
    public IndependentObject fetchIndependentObject(PropertyFilter pf) {
        IndependentObject object = this.fetchIndependentObject(this.value, pf);
        this.value = object;
        return object;
    }

    protected IndependentObject fetchIndependentObject(Object value, PropertyFilter pf) {
        if (value == null) {
            return null;
        }
        if (value instanceof DependentIdentity || value instanceof EngineObject && !(value instanceof IndependentObject)) {
            throw new EngineRuntimeException(ExceptionCode.API_METHOD_NO_DEPENDENT_SUPPORT, new Object[]{"fetchIndependentObject", value.getClass().getName()});
        }
        try {
            if (value instanceof UnevaluatedPropertyValue) {
                PropertyImpl tProp = this.getSession().getProperty((ConnectionImpl)this.connection, (UnevaluatedPropertyValue)value, null, pf, null);
                value = tProp != null ? tProp.value : null;
            } else if (value instanceof ObjectReferenceBase) {
                value = this.getSession().getObject((ConnectionImpl)this.connection, (ObjectReferenceBase)value, pf, null);
            } else if (value instanceof EngineObjectImpl) {
                ObjectReference oa = ((EngineObjectImpl)value).getObjectReference();
                value = this.getSession().getObject((ConnectionImpl)this.connection, (ObjectReferenceBase)oa, pf, null);
            }
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                value = null;
            }
            throw e;
        }
        return (IndependentObject)value;
    }

    @Override
    protected Object fetchValue(Object value) {
        try {
            return super.fetchValue(value);
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                return null;
            }
            throw e;
        }
    }

    public void setConnection(Connection connectionVal) {
        this.connection = connectionVal;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
    }

    @Override
    public int getSerializeMask() {
        return super.getSerializeMask() | 7;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        s.putObject(this.value);
    }

    @Override
    public void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.value = s.getObject();
        this.connection = conn;
    }
}

