/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query;

import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.ContentQueryOptimization;
import com.filenet.api.constants.GroupAction;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.constants.RequiredState;
import com.filenet.api.constants.SearchModifier;
import com.filenet.api.constants.SortOrder;
import com.filenet.api.constants.VersionSelection;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchTemplateContent;
import com.filenet.api.query.SearchTemplateContentItem;
import com.filenet.api.query.SearchTemplateFolder;
import com.filenet.api.query.SearchTemplateParameters;
import com.filenet.api.query.SearchTemplateSelectProperty;
import com.filenet.api.query.SearchTemplateSubclass;
import com.filenet.api.query.SearchTemplateWhereProperty;
import com.filenet.api.query.StoredSearch;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.Streamable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoryStoredSearch
extends Search
implements Streamable {
    private ObjectReference searchObject = null;
    private String fromClass = null;
    private SearchTemplateParameters templateData = null;
    static final int MAX_RECORDS_NOT_DEFINED = -1;
    static final int CONTENT_NOT_DEFINED = -1;
    static final int CONTENT_DEFINED = 0;
    static final Map<String, GroupAction> groupActionMap = new HashMap<String, GroupAction>();
    static final Map<String, ContentQueryOptimization> optimizeMap = new HashMap<String, ContentQueryOptimization>();
    static final int TIME_LIMIT_NOT_DEFINED = -1;
    static final int COUNT_LIMIT_NOT_DEFINED = -1;
    static final int CBR_MAX_ROWS_NOT_DEFINED = -1;
    static final int CBR_DYNAMIC_THRESHOLD_NOT_DEFINED = -1;
    private static final long serialVersionUID = 2882400000L;

    public ClassDescriptionSet fetchSearchableClassDescriptions(ObjectStore objectStore, String[] classNames, PropertyFilter filter) {
        if (objectStore == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        Session session = SessionLocator.getSession(objectStore.getConnection());
        return session.getSearchMetadata((ConnectionImpl)objectStore.getConnection(), (ObjectStoreImpl)objectStore, classNames, filter);
    }

    public ClassDescriptionSet fetchSearchableClassDescriptions(ObjectStore[] objectStores, MergeMode mergeMode, String[] classNames, PropertyFilter filter) {
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        Session session = SessionLocator.getSession(objectStores[0].getConnection());
        ObjectStoreImpl[] osi = new ObjectStoreImpl[objectStores.length];
        for (int lp = 0; lp < objectStores.length; ++lp) {
            osi[lp] = (ObjectStoreImpl)objectStores[lp];
        }
        return session.getSearchMetadata((ConnectionImpl)objectStores[0].getConnection(), osi, mergeMode, classNames, filter);
    }

    public final RepositoryRowSet fetchRows(ObjectStore objectStore, StoredSearch storedSearch, String fromClass, SearchTemplateParameters templateParameters, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStore == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        this.saveStoredSearchData(storedSearch, fromClass, templateParameters);
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStore.getConnection());
        return session.fetchRows((ConnectionImpl)objectStore.getConnection(), this, (ObjectStoreImpl)objectStore, pageSize, continuable, null);
    }

    public final RepositoryRowSet fetchRows(ObjectStore[] objectStores, StoredSearch storedSearch, String fromClass, SearchTemplateParameters templateParameters, MergeMode mergeMode, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        this.saveStoredSearchData(storedSearch, fromClass, templateParameters);
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStores[0].getConnection());
        ObjectStoreImpl[] osi = new ObjectStoreImpl[objectStores.length];
        for (int lp = 0; lp < objectStores.length; ++lp) {
            osi[lp] = (ObjectStoreImpl)objectStores[lp];
        }
        return session.fetchRows((ConnectionImpl)objectStores[0].getConnection(), this, osi, mergeMode, pageSize, continuable, null);
    }

    public final IndependentObjectSet fetchObjects(ObjectStore objectStore, StoredSearch storedSearch, String fromClass, SearchTemplateParameters templateParameters, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStore == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        this.saveStoredSearchData(storedSearch, fromClass, templateParameters);
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStore.getConnection());
        return session.fetchObjects((ConnectionImpl)objectStore.getConnection(), this, (ObjectStoreImpl)objectStore, pageSize, continuable, null);
    }

    public final IndependentObjectSet fetchObjects(ObjectStore[] objectStores, StoredSearch storedSearch, String fromClass, SearchTemplateParameters templateParameters, MergeMode mergeMode, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        if (pageSize != null && pageSize < 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "pageSize");
        }
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        this.saveStoredSearchData(storedSearch, fromClass, templateParameters);
        if (filter != null) {
            this.setPropertyFilter(filter);
        }
        if (continuable == null) {
            continuable = Boolean.FALSE;
        }
        Session session = SessionLocator.getSession(objectStores[0].getConnection());
        return session.fetchObjects((ConnectionImpl)objectStores[0].getConnection(), this, objectStores, mergeMode, pageSize, continuable, null);
    }

    private final void saveStoredSearchData(StoredSearch storedSearch, String searchFromClass, SearchTemplateParameters templateParameters) {
        if (storedSearch == null || searchFromClass == null) {
            throw new EngineRuntimeException(ExceptionCode.API_SEARCH_REQUIRED_VALUES_NULL);
        }
        this.searchObject = storedSearch.getObjectReference();
        this.fromClass = searchFromClass;
        this.templateData = templateParameters;
    }

    public ObjectReference getSearchObject() {
        return this.searchObject;
    }

    public final String getFromClass() {
        return this.fromClass;
    }

    public final SearchTemplateParameters getTemplateData() {
        return this.templateData;
    }

    public final void setStoredSearch(ObjectReference searchObjectRef, String searchFromClass, SearchTemplateParameters templateParameters) {
        this.searchObject = searchObjectRef;
        this.fromClass = searchFromClass;
        if (this.searchObject == null || this.fromClass == null) {
            throw new EngineRuntimeException(ExceptionCode.API_SEARCH_REQUIRED_VALUES_NULL);
        }
        this.templateData = templateParameters;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(super.toString());
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" ObjectReference=");
        sb.append(this.searchObject);
        sb.append(" FromClass=");
        sb.append(this.fromClass);
        return sb.toString();
    }

    @Override
    public short getStreamType() {
        return 14;
    }

    @Override
    public void putStreamValue(DelegateOutputStream s) throws IOException {
        this.write(s);
    }

    public void deserializeValue(DelegateInputStream s, Connection connection) throws IOException, ClassNotFoundException {
        this.read(s);
    }

    private void read(DelegateInputStream s) throws IOException, ClassNotFoundException {
        int value;
        Integer maxRecords = null;
        Integer timeLimit = null;
        Integer countLimit = null;
        this.searchObject = (ObjectReference)s.readObject();
        this.fromClass = (String)s.readObject();
        String vs = this.getString(s);
        VersionSelection versionSelection = null;
        if (vs != null) {
            versionSelection = vs.equalsIgnoreCase(VersionSelection.ALL_VERSIONS.toString()) ? VersionSelection.ALL_VERSIONS : (vs.equalsIgnoreCase(VersionSelection.CURRENT_VERSION.toString()) ? VersionSelection.CURRENT_VERSION : VersionSelection.RELEASED_VERSION);
        }
        if ((value = s.readInt()) != -1) {
            maxRecords = new Integer(value);
        }
        if ((value = s.readInt()) != -1) {
            timeLimit = new Integer(value);
        }
        if ((value = s.readInt()) != -1) {
            countLimit = new Integer(value);
        }
        List<String> selectList = this.readStringList(s);
        List<SearchTemplateFolder> folders = this.readFolders(s);
        List<SearchTemplateSelectProperty> selectProps = this.readSelectProps(s);
        List<SearchTemplateSubclass> subclasses = this.readSubclasses(s);
        List<SearchTemplateWhereProperty> whereProps = this.readWhereProps(s);
        SearchTemplateContent content = this.readContent(s);
        if (maxRecords != null || selectList != null || folders != null || timeLimit != null || countLimit != null || versionSelection != null || selectProps != null || subclasses != null || whereProps != null || content != null) {
            this.templateData = new SearchTemplateParameters();
            this.templateData.setMaximumRecords(maxRecords);
            this.templateData.setTimeLimit(timeLimit);
            this.templateData.setCountLimit(countLimit);
            this.templateData.setAugmentedSelectList(selectList);
            this.templateData.setContent(content);
            this.templateData.setFolders(folders);
            this.templateData.setSelectProperties(selectProps);
            this.templateData.setSubclasses(subclasses);
            this.templateData.setVersionSelection(versionSelection);
            this.templateData.setWhereProperties(whereProps);
        }
    }

    private void write(DelegateOutputStream s) throws IOException {
        String versionSelection = null;
        Integer maxRecords = -1;
        Integer timeLimit = -1;
        Integer countLimit = -1;
        List<String> selectList = null;
        List<SearchTemplateFolder> folders = null;
        List<SearchTemplateSelectProperty> selectProps = null;
        List<SearchTemplateSubclass> subclasses = null;
        List<SearchTemplateWhereProperty> whereProps = null;
        SearchTemplateContent content = null;
        if (this.templateData != null) {
            if (this.templateData.getMaximumRecords() != null) {
                maxRecords = this.templateData.getMaximumRecords();
            }
            if (this.templateData.getTimeLimit() != null) {
                timeLimit = this.templateData.getTimeLimit();
            }
            if (this.templateData.getCountLimit() != null) {
                countLimit = this.templateData.getCountLimit();
            }
            if (this.templateData.getVersionSelection() != null) {
                versionSelection = this.templateData.getVersionSelection().toString();
            }
            selectList = this.templateData.getAugmentedSelectList();
            folders = this.templateData.getFolders();
            selectProps = this.templateData.getSelectProperties();
            subclasses = this.templateData.getSubclasses();
            whereProps = this.templateData.getWhereProperties();
            content = this.templateData.getContent();
        }
        s.writeBoolean(this == null);
        s.writeObject(this.searchObject);
        s.writeObject(this.fromClass);
        this.writeString(s, versionSelection);
        s.writeInt(maxRecords);
        s.writeInt(timeLimit);
        s.writeInt(countLimit);
        this.writeStringList(s, selectList);
        this.writeFolders(s, folders);
        this.writeSelectProps(s, selectProps);
        this.writeSubclasses(s, subclasses);
        this.writeWhereProps(s, whereProps);
        this.writeContent(s, content);
    }

    private SearchTemplateContent readContent(DelegateInputStream s) throws IOException, ClassNotFoundException {
        String val = null;
        SearchTemplateContent c = null;
        int contentDefined = s.readInt();
        if (contentDefined == 0) {
            c = new SearchTemplateContent();
            c.setRank(this.getBoolean(s));
            c.setSummary(this.getBoolean(s));
            c.setContentQueryMaximumRecords(this.getInteger(s));
            val = this.getString(s);
            ContentQueryOptimization opt = null;
            if (val != null) {
                opt = optimizeMap.get(val);
            }
            c.setContentQueryOptimization(opt);
            c.setContentQueryDynamicThreshold(this.getInteger(s));
            int size = s.readInt();
            if (size > 0) {
                ArrayList<SearchTemplateContentItem> items = new ArrayList<SearchTemplateContentItem>();
                for (int ix = 0; ix < size; ++ix) {
                    SearchTemplateContentItem item = new SearchTemplateContentItem();
                    item.setExcludeFromQuery(this.getBoolean(s));
                    val = this.getString(s);
                    GroupAction ga = null;
                    if (val != null) {
                        ga = groupActionMap.get(val);
                    }
                    item.setGroupAction(ga);
                    item.setItemId(this.getString(s));
                    val = this.getString(s);
                    RequiredState rs = null;
                    if (val != null) {
                        rs = val.equalsIgnoreCase(RequiredState.PROHIBITED.toString()) ? RequiredState.PROHIBITED : (val.equalsIgnoreCase(RequiredState.REQUIRED.toString()) ? RequiredState.REQUIRED : RequiredState.NONE);
                    }
                    item.setRequiredState(rs);
                    val = this.getString(s);
                    SearchModifier sm = null;
                    if (val != null) {
                        sm = val.equalsIgnoreCase(SearchModifier.BOOST.toString()) ? SearchModifier.BOOST : (val.equalsIgnoreCase(SearchModifier.FUZZY.toString()) ? SearchModifier.FUZZY : SearchModifier.PROXIMITY);
                    }
                    item.setSearchModifier(sm);
                    item.setSearchModifierRange(this.getDouble(s));
                    List<String> itemData = this.readStringList(s);
                    item.setItemData(itemData);
                    items.add(item);
                }
                c.setContentItems(items);
            }
        }
        return c;
    }

    private void writeContent(DelegateOutputStream s, SearchTemplateContent c) throws IOException {
        int contentDefined = c == null ? -1 : 0;
        s.writeInt(contentDefined);
        if (c != null) {
            this.writeBoolean(s, c.getRank());
            this.writeBoolean(s, c.getSummary());
            this.writeInteger(s, c.getContentQueryMaximumRecords());
            ContentQueryOptimization opt = c.getContentQueryOptimization();
            String val = null;
            if (opt != null) {
                val = opt.toString();
            }
            this.writeString(s, val);
            this.writeInteger(s, c.getContentQueryDynamicThreshold());
            List<SearchTemplateContentItem> items = c.getContentItems();
            if (items == null) {
                s.writeInt(0);
            } else {
                int size = items.size();
                s.writeInt(size);
                for (int ix = 0; ix < size; ++ix) {
                    SearchTemplateContentItem item = items.get(ix);
                    this.writeBoolean(s, item.getExcludeFromQuery());
                    GroupAction ga = item.getGroupAction();
                    val = null;
                    if (ga != null) {
                        val = ga.toString();
                    }
                    this.writeString(s, val);
                    this.writeString(s, item.getItemId());
                    RequiredState rs = item.getRequiredState();
                    val = null;
                    if (rs != null) {
                        val = rs.toString();
                    }
                    this.writeString(s, val);
                    SearchModifier sm = item.getSearchModifier();
                    val = null;
                    if (sm != null) {
                        val = sm.toString();
                    }
                    this.writeString(s, val);
                    this.writeDouble(s, item.getSearchModifierRange());
                    List<String> data = item.getItemData();
                    this.writeStringList(s, data);
                }
            }
        }
    }

    private void writeWhereProps(DelegateOutputStream s, List<SearchTemplateWhereProperty> list) throws IOException {
        if (list == null) {
            s.writeInt(0);
        } else {
            int size = list.size();
            s.writeInt(size);
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateWhereProperty c = list.get(ix);
                this.writeBoolean(s, c.getExcludeFromQuery());
                this.writeString(s, c.getItemId());
                this.writeString(s, c.getLiteral());
            }
        }
    }

    private List<SearchTemplateWhereProperty> readWhereProps(DelegateInputStream s) throws IOException, ClassNotFoundException {
        ArrayList<SearchTemplateWhereProperty> list = null;
        int size = s.readInt();
        if (size > 0) {
            list = new ArrayList<SearchTemplateWhereProperty>();
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateWhereProperty p = new SearchTemplateWhereProperty();
                p.setExcludeFromQuery(this.getBoolean(s));
                p.setItemId(this.getString(s));
                p.setLiteral(this.getString(s));
                list.add(p);
            }
        }
        return list;
    }

    private void writeSubclasses(DelegateOutputStream s, List<SearchTemplateSubclass> list) throws IOException {
        if (list == null) {
            s.writeInt(0);
        } else {
            int size = list.size();
            s.writeInt(size);
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateSubclass c = list.get(ix);
                this.writeBoolean(s, c.getExcludeFromQuery());
                this.writeString(s, c.getItemId());
                this.writeBoolean(s, c.getIncludeSubclasses());
                this.writeString(s, c.getSymbolicName());
            }
        }
    }

    private List<SearchTemplateSubclass> readSubclasses(DelegateInputStream s) throws IOException, ClassNotFoundException {
        ArrayList<SearchTemplateSubclass> list = null;
        int size = s.readInt();
        if (size > 0) {
            list = new ArrayList<SearchTemplateSubclass>();
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateSubclass p = new SearchTemplateSubclass();
                p.setExcludeFromQuery(this.getBoolean(s));
                p.setItemId(this.getString(s));
                p.setIncludeSubclasses(this.getBoolean(s));
                p.setSymbolicName(this.getString(s));
                list.add(p);
            }
        }
        return list;
    }

    private void writeSelectProps(DelegateOutputStream s, List<SearchTemplateSelectProperty> list) throws IOException {
        if (list == null) {
            s.writeInt(0);
        } else {
            int size = list.size();
            s.writeInt(size);
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateSelectProperty p = list.get(ix);
                this.writeBoolean(s, p.getExcludeFromQuery());
                this.writeString(s, p.getItemId());
                this.writeInteger(s, p.getSortLevel());
                SortOrder so = p.getSortOrder();
                String val = so == null ? "" : so.toString();
                this.writeString(s, val);
                this.writeString(s, p.getSymbolicName());
            }
        }
    }

    private List<SearchTemplateSelectProperty> readSelectProps(DelegateInputStream s) throws IOException, ClassNotFoundException {
        ArrayList<SearchTemplateSelectProperty> list = null;
        int size = s.readInt();
        if (size > 0) {
            list = new ArrayList<SearchTemplateSelectProperty>();
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateSelectProperty p = new SearchTemplateSelectProperty();
                p.setExcludeFromQuery(this.getBoolean(s));
                p.setItemId(this.getString(s));
                p.setSortLevel(this.getInteger(s));
                String val = this.getString(s);
                SortOrder so = null;
                if (val != null) {
                    so = val.equalsIgnoreCase(SortOrder.ASCENDING.toString()) ? SortOrder.ASCENDING : (val.equalsIgnoreCase(SortOrder.DESCENDING.toString()) ? SortOrder.DESCENDING : SortOrder.NONE);
                }
                p.setSortOrder(so);
                p.setSymbolicName(this.getString(s));
                list.add(p);
            }
        }
        return list;
    }

    private void writeFolders(DelegateOutputStream s, List<SearchTemplateFolder> list) throws IOException {
        if (list == null) {
            s.writeInt(0);
        } else {
            int size = list.size();
            s.writeInt(size);
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateFolder f = list.get(ix);
                this.writeBoolean(s, f.getExcludeFromQuery());
                this.writeString(s, f.getItemId());
                Folder folderObj = f.getFolder();
                if (folderObj != null) {
                    String identity = folderObj.getObjectReference().getObjectIdentity();
                    Id id = Id.asIdOrNull(identity);
                    folderObj = id != null ? Factory.Folder.getInstance(folderObj.getObjectStore(), null, id) : Factory.Folder.getInstance(folderObj.getObjectStore(), null, identity);
                }
                s.writeShort(2);
                s.putEngineObject((EngineObjectImpl)((Object)folderObj));
                this.writeBoolean(s, f.getSearchSubFolders());
            }
        }
    }

    private List<SearchTemplateFolder> readFolders(DelegateInputStream s) throws IOException, ClassNotFoundException {
        ArrayList<SearchTemplateFolder> list = null;
        int size = s.readInt();
        if (size > 0) {
            list = new ArrayList<SearchTemplateFolder>();
            for (int ix = 0; ix < size; ++ix) {
                SearchTemplateFolder f = new SearchTemplateFolder();
                f.setExcludeFromQuery(this.getBoolean(s));
                f.setItemId(this.getString(s));
                Folder folderObj = (Folder)s.getObject();
                f.setFolder(folderObj);
                f.setSearchSubFolders(this.getBoolean(s));
                list.add(f);
            }
        }
        return list;
    }

    private void writeBoolean(DelegateOutputStream s, Boolean b) throws IOException {
        String val = b == null ? "" : b.toString();
        s.writeObject(val);
    }

    private void writeString(DelegateOutputStream s, String val) throws IOException {
        if (val == null) {
            val = "";
        }
        s.writeObject(val);
    }

    private void writeId(DelegateOutputStream s, Id id) throws IOException {
        String val = null;
        val = id == null ? "" : id.toString();
        s.writeObject(val);
    }

    private void writeInteger(ObjectOutputStream s, Integer i) throws IOException {
        String val = null;
        val = i == null ? "" : i.toString();
        s.writeObject(val);
    }

    private void writeDouble(ObjectOutputStream s, Double i) throws IOException {
        String val = null;
        val = i == null ? "" : i.toString();
        s.writeObject(val);
    }

    private Boolean getBoolean(DelegateInputStream s) throws IOException, ClassNotFoundException {
        Boolean b = null;
        String val = (String)s.readObject();
        if (val != null && val.length() > 0) {
            b = new Boolean(val);
        }
        return b;
    }

    private Integer getInteger(DelegateInputStream s) throws IOException, ClassNotFoundException {
        Integer i = null;
        String val = (String)s.readObject();
        if (val != null && val.length() > 0) {
            i = new Integer(val);
        }
        return i;
    }

    private String getString(DelegateInputStream s) throws IOException, ClassNotFoundException {
        String val = (String)s.readObject();
        if (val != null && val.length() == 0) {
            val = null;
        }
        return val;
    }

    private Double getDouble(DelegateInputStream s) throws IOException, ClassNotFoundException {
        Double d = null;
        String val = (String)s.readObject();
        if (val != null && val.length() > 0) {
            d = new Double(val);
        }
        return d;
    }

    private void writeStringList(DelegateOutputStream s, List<String> list) throws IOException {
        if (list == null) {
            s.writeInt(0);
        } else {
            int size = list.size();
            s.writeInt(size);
            for (int ix = 0; ix < size; ++ix) {
                String val = list.get(ix);
                this.writeString(s, val);
            }
        }
    }

    private List<String> readStringList(DelegateInputStream s) throws IOException, ClassNotFoundException {
        ArrayList<String> list = null;
        int size = s.readInt();
        if (size > 0) {
            list = new ArrayList<String>();
            for (int ix = 0; ix < size; ++ix) {
                String val = (String)s.readObject();
                list.add(val);
            }
        }
        return list;
    }

    static {
        groupActionMap.put(GroupAction.ALL.toString(), GroupAction.ALL);
        groupActionMap.put(GroupAction.ANY.toString(), GroupAction.ANY);
        groupActionMap.put(GroupAction.IN.toString(), GroupAction.IN);
        groupActionMap.put(GroupAction.NEAR.toString(), GroupAction.NEAR);
        groupActionMap.put(GroupAction.NONE.toString(), GroupAction.NONE);
        groupActionMap.put(GroupAction.PARAGRAPH.toString(), GroupAction.PARAGRAPH);
        groupActionMap.put(GroupAction.PHRASE.toString(), GroupAction.PHRASE);
        groupActionMap.put(GroupAction.SENTENCE.toString(), GroupAction.SENTENCE);
        groupActionMap.put(GroupAction.UNIT.toString(), GroupAction.UNIT);
        groupActionMap.put(GroupAction.VQL.toString(), GroupAction.VQL);
        optimizeMap.put(ContentQueryOptimization.NONE.toString(), ContentQueryOptimization.NONE);
        optimizeMap.put(ContentQueryOptimization.CONTENT_FIRST.toString(), ContentQueryOptimization.CONTENT_FIRST);
        optimizeMap.put(ContentQueryOptimization.DB_FIRST.toString(), ContentQueryOptimization.DB_FIRST);
        optimizeMap.put(ContentQueryOptimization.DYNAMIC_THRESHOLD.toString(), ContentQueryOptimization.DYNAMIC_THRESHOLD);
    }
}

