/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query.parser;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.query.parser.DaphneQuery;
import com.filenet.apiimpl.query.parser.SimpleNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;

public class QueryParserHelper {
    private static final TimeZone tzGMT = TimeZone.getTimeZone("GMT");

    private static SimpleDateFormat sdfW3C_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'ddZ");
        return sdf;
    }

    private static SimpleDateFormat sdfW3C_Z() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'Z'");
        sdf.setTimeZone(tzGMT);
        return sdf;
    }

    private static SimpleDateFormat sdfW3C_time_Z() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
        sdf.setTimeZone(tzGMT);
        return sdf;
    }

    private static SimpleDateFormat sdfW3C_time_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssZ");
        return sdf;
    }

    private static SimpleDateFormat sdfW3C_time_fraction_Z() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSS'Z'");
        sdf.setTimeZone(tzGMT);
        return sdf;
    }

    private static SimpleDateFormat sdfW3C_time_fraction_TZ() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSSZ");
        sdf.setTimeZone(tzGMT);
        return sdf;
    }

    private static SimpleDateFormat sdfW3C_time_fraction_TZ_out() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSSZ");
        sdf.setTimeZone(tzGMT);
        return sdf;
    }

    private static SimpleDateFormat sdfISO_time_Z() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        sdf.setTimeZone(tzGMT);
        return sdf;
    }

    private static SimpleDateFormat sdfISO_time_fraction_Z() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss','SSS'Z'");
        sdf.setTimeZone(tzGMT);
        return sdf;
    }

    public static String toW3Cformat(Date date) {
        return QueryParserHelper.sdfW3C_time_fraction_TZ_out().format(date);
    }

    public static String toISOformat(Date date) {
        return QueryParserHelper.sdfISO_time_fraction_Z().format(date);
    }

    public static Date parseIsoDate(String dateString) {
        SimpleDateFormat sdf;
        boolean needRoundUp = false;
        if (dateString.length() > 16 && dateString.charAt(15) == ',') {
            sdf = QueryParserHelper.sdfISO_time_fraction_Z();
            int numberOfFracDigits = 0;
            for (int ii = 16; ii < dateString.length() && Character.isDigit(dateString.charAt(ii)); ++ii) {
                ++numberOfFracDigits;
            }
            switch (numberOfFracDigits) {
                case 1: {
                    dateString = dateString.substring(0, 17) + "000" + dateString.substring(17);
                    numberOfFracDigits = 4;
                    break;
                }
                case 2: {
                    dateString = dateString.substring(0, 18) + "00" + dateString.substring(18);
                    numberOfFracDigits = 4;
                    break;
                }
                case 3: {
                    dateString = dateString.substring(0, 19) + "0" + dateString.substring(19);
                    numberOfFracDigits = 4;
                }
            }
            if (dateString.length() > 19) {
                char dig4 = dateString.charAt(19);
                if (dig4 >= '5') {
                    needRoundUp = true;
                }
                dateString = dateString.substring(0, 19) + dateString.substring(16 + numberOfFracDigits);
            }
        } else {
            sdf = QueryParserHelper.sdfISO_time_Z();
        }
        try {
            sdf.setLenient(false);
            Date date = sdf.parse(dateString);
            if (date == null) {
                throw new EngineRuntimeException(ExceptionCode.RETRIEVE_UNRECOGNIZED_QUERY_DATE, new Object[]{dateString});
            }
            if (needRoundUp) {
                date = new Date(date.getTime() + 1L);
            }
            return date;
        }
        catch (ParseException e) {
            throw new EngineRuntimeException(e, ExceptionCode.RETRIEVE_UNRECOGNIZED_QUERY_DATE, new Object[]{dateString});
        }
    }

    public static Date parseW3cDate(String dateString) {
        String originalDateString = dateString;
        boolean hasTimeZoneZee = false;
        boolean hasTimeZone = false;
        boolean hasTime = false;
        boolean hasSecondFraction = false;
        boolean needRoundUp = false;
        int len = dateString.length();
        if (len > 10 && (dateString.charAt(len - 6) == '+' || dateString.charAt(len - 6) == '-')) {
            hasTimeZone = true;
            dateString = dateString.substring(0, len - 3) + dateString.substring(len - 2);
        } else if (dateString.charAt(len - 1) == 'Z') {
            hasTimeZoneZee = true;
        }
        if (dateString.length() > 10 && dateString.charAt(10) == 'T') {
            hasTime = true;
            if (dateString.length() > 19 && dateString.charAt(19) == '.') {
                hasSecondFraction = true;
                int numberOfFracDigits = 0;
                for (int ii = 20; ii < dateString.length() && Character.isDigit(dateString.charAt(ii)); ++ii) {
                    ++numberOfFracDigits;
                }
                switch (numberOfFracDigits) {
                    case 1: {
                        dateString = dateString.substring(0, 21) + "000" + dateString.substring(21);
                        numberOfFracDigits = 4;
                        break;
                    }
                    case 2: {
                        dateString = dateString.substring(0, 22) + "00" + dateString.substring(22);
                        numberOfFracDigits = 4;
                        break;
                    }
                    case 3: {
                        dateString = dateString.substring(0, 23) + "0" + dateString.substring(23);
                        numberOfFracDigits = 4;
                    }
                }
                if (dateString.length() > 23) {
                    char dig4 = dateString.charAt(23);
                    if (dig4 >= '5') {
                        needRoundUp = true;
                    }
                    dateString = dateString.substring(0, 23) + dateString.substring(20 + numberOfFracDigits);
                }
            }
        }
        SimpleDateFormat sdf = null;
        if (hasTime) {
            if (hasSecondFraction) {
                if (hasTimeZone) {
                    sdf = QueryParserHelper.sdfW3C_time_fraction_TZ();
                } else if (hasTimeZoneZee) {
                    sdf = QueryParserHelper.sdfW3C_time_fraction_Z();
                } else {
                    sdf = QueryParserHelper.sdfW3C_time_fraction_Z();
                    dateString = dateString + 'Z';
                }
            } else if (hasTimeZone) {
                sdf = QueryParserHelper.sdfW3C_time_TZ();
            } else if (hasTimeZoneZee) {
                sdf = QueryParserHelper.sdfW3C_time_Z();
            } else {
                sdf = QueryParserHelper.sdfW3C_time_Z();
                dateString = dateString + 'Z';
            }
        } else if (hasTimeZoneZee) {
            sdf = QueryParserHelper.sdfW3C_Z();
        } else if (hasTimeZone) {
            sdf = QueryParserHelper.sdfW3C_TZ();
        } else {
            sdf = QueryParserHelper.sdfW3C_Z();
            dateString = dateString + 'Z';
        }
        try {
            sdf.setLenient(false);
            Date date = sdf.parse(dateString);
            if (date == null) {
                throw new EngineRuntimeException(ExceptionCode.RETRIEVE_UNRECOGNIZED_QUERY_DATE, new Object[]{originalDateString});
            }
            if (needRoundUp) {
                date = new Date(date.getTime() + 1L);
            }
            return date;
        }
        catch (ParseException e) {
            throw new EngineRuntimeException(e, ExceptionCode.RETRIEVE_UNRECOGNIZED_QUERY_DATE, new Object[]{originalDateString});
        }
    }

    public static String unSquote(String in) {
        String out = in.substring(1, in.length() - 1);
        out = out.replaceAll("''", "'");
        return out;
    }

    public static HashSet<String> extractQueryParameters(DaphneQuery node) {
        HashSet<String> parameterList = new HashSet<String>();
        parameterList = QueryParserHelper.traverseChildren(node, parameterList);
        return parameterList;
    }

    private static HashSet<String> traverseChildren(SimpleNode node, HashSet<String> parameterList) {
        int numChildren = node.jjtGetNumChildren();
        if (numChildren > 0) {
            for (int i = 0; i < numChildren; ++i) {
                SimpleNode n = (SimpleNode)node.jjtGetChild(i);
                if (n == null) continue;
                if (n.getNodeType() == 24) {
                    parameterList.add(n.getText());
                }
                parameterList = QueryParserHelper.traverseChildren(n, parameterList);
            }
        }
        return parameterList;
    }
}

