/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.List;

public class ExecuteChangesRequest
extends Message
implements Request,
XMLTraceable {
    private transient ChangeRequest[] batch;
    private transient boolean refresh = false;
    private transient ArrayList contentHandles;
    private transient ArrayList xopBinaryProps;
    private static final long serialVersionUID = -7849548217052120170L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ExecuteChangesRequest(ChangeRequest[] batchVal) {
        this.batch = batchVal;
    }

    public boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refreshVal) {
        this.refresh = refreshVal;
    }

    public ChangeRequest[] getBatch() {
        return this.batch;
    }

    @Override
    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    @Override
    public void getObjectStoreReferences(List references) {
        if (this.batch != null) {
            int len = this.batch.length;
            for (int ix = 0; ix < len; ++ix) {
                ObjectReferenceBase o = this.batch[ix].getObjectReference();
                if (o == null || o.getObjectStoreReference() == null) continue;
                references.add(o.getObjectStoreReference());
            }
        }
    }

    public ArrayList getContentHandles() {
        return this.contentHandles;
    }

    public void setContentHandles(ArrayList list) {
        this.contentHandles = list;
    }

    public ArrayList getXopBinaryProperties() {
        return this.xopBinaryProps;
    }

    public void setXopBinaryProperties(ArrayList list) {
        this.xopBinaryProps = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        s.writeBoolean(this.refresh);
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                s.putChangeRequest(this.batch[lp]);
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.refresh = s.readBoolean();
        int size = s.readInt();
        this.batch = new ChangeRequest[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                this.batch[lp] = s.getChangeRequest();
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    @Override
    public void trace(XMLTraceReader reader, String element) throws Exception {
        reader.addAttribute("refresh", String.valueOf(this.refresh));
        this.trace(reader, element, this.batch);
    }
}

