/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.WSICredential;
import java.net.HttpCookie;

public class AuthToken {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(AuthToken.class, SubSystem.API);
    private TokenType tokenType;
    private String tokenName;
    private String tokenValue;
    private String principalName;
    private String cookieName;
    private String issuer;
    private String realm;

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public String getPrincipalName() {
        if (J2EEUtil.getAppServerType() == 3 && !this.isEmpty(this.realm) && !this.isEmpty(this.principalName) && (this.principalName.startsWith(this.realm + "\\") || this.principalName.startsWith(this.realm + "/"))) {
            String noRealmPrincipalName = this.principalName.substring(this.realm.length() + 1, this.principalName.length());
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("AuthToken.getPrincipalName(): Removed realm from principalName [" + this.principalName + "]; updated [" + noRealmPrincipalName + "]");
            }
            return noRealmPrincipalName;
        }
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public WSICredential getWsiCredential() {
        WSICredential cred = null;
        cred = this.tokenType == TokenType.OAUTH_TOKEN || this.tokenType == TokenType.OIDC_TOKEN ? new WSICredential(this.getTokenName(), this.getPrincipalName()) : new WSICredential(this.getTokenName(), this.getTokenValue());
        cred.setAuthToken(this);
        return cred;
    }

    public boolean usesHttpAuthCookie() {
        return this.tokenType == TokenType.LTPA_TOKEN;
    }

    public HttpCookie getHttpAuthCookie() {
        HttpCookie cookie = null;
        if (this.tokenType == TokenType.LTPA_TOKEN) {
            cookie = new HttpCookie(this.getCookieName(), this.getTokenValue());
        }
        return cookie;
    }

    public boolean usesHttpAuthHeader() {
        return this.tokenType == TokenType.OAUTH_TOKEN || this.tokenType == TokenType.OIDC_TOKEN;
    }

    public String getHttpAuthHeader() {
        String httpAuthHeader = null;
        if (this.tokenType == TokenType.OAUTH_TOKEN || this.tokenType == TokenType.OIDC_TOKEN) {
            httpAuthHeader = "Bearer " + this.getTokenValue();
        }
        return httpAuthHeader;
    }

    public String toString() {
        return "AuthToken [tokenType=" + (Object)((Object)this.tokenType) + ", tokenName=" + this.tokenName + ", tokenValue=" + this.tokenValue + ", principalName=" + this.principalName + ", cookieName=" + this.cookieName + ", issuer=" + this.issuer + ", realm=" + this.realm + "]";
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static enum TokenType {
        OAUTH_TOKEN,
        OIDC_TOKEN,
        LTPA_TOKEN;

    }
}

