/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SpillStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArraySpillStreamFactory
implements SpillStreamFactory {
    private ByteArrayOutputStream baos = null;
    private FilterOutputStream fos = null;
    private final int estimatedCapacity;
    private final int maxCapacity;
    private final BaseLogger logger;
    private String cid = null;

    public ByteArraySpillStreamFactory(int estimatedCapacity, int maxCapacity, BaseLogger logger) {
        this.estimatedCapacity = estimatedCapacity;
        this.maxCapacity = maxCapacity;
        this.logger = logger;
    }

    @Override
    public SpillStreamFactory getInstance(BaseLogger logger) {
        return new ByteArraySpillStreamFactory(this.estimatedCapacity, this.maxCapacity, logger);
    }

    @Override
    public OutputStream getOutputStream(String cid) throws IOException {
        this.cid = cid;
        this.baos = this.estimatedCapacity > 0 ? new ByteArrayOutputStream(this.estimatedCapacity) : new ByteArrayOutputStream();
        if (this.maxCapacity > 0) {
            this.fos = new LimitedOutputStream(this.baos, this.maxCapacity);
            return this.fos;
        }
        return this.baos;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.baos == null) {
            IllegalStateException ise = new IllegalStateException("Must call getOutputStream before getInputStream");
            IOException ioe = new IOException();
            ioe.initCause(ise);
            throw ioe;
        }
        if (this.fos != null) {
            this.fos.close();
        }
        this.baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.baos.toByteArray());
        this.baos = null;
        return bais;
    }

    public static final class LimitedOutputStream
    extends FilterOutputStream {
        int count = 0;
        private final int maxCapacity;

        public LimitedOutputStream(OutputStream out, int maxCapacity) {
            super(out);
            this.maxCapacity = maxCapacity;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
            this.checkCapacity();
            super.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.count += b.length;
            this.checkCapacity();
            super.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
            this.checkCapacity();
            super.write(b);
        }

        private void checkCapacity() throws IOException {
            if (this.count > this.maxCapacity) {
                MaximumCapacityExceededException mcee = new MaximumCapacityExceededException("" + this.maxCapacity);
                IOException ioe = new IOException();
                ioe.initCause(mcee);
                throw ioe;
            }
        }
    }

    private static class MaximumCapacityExceededException
    extends IndexOutOfBoundsException {
        public MaximumCapacityExceededException(String s) {
            super(s);
        }
    }
}

