/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.security.SecureRandom;

public class CaseInsensitivityHelper {
    private static final int TOLC_SIZE = 128;
    private static final int TOLC_MODULUS_MASK = 127;
    private static final char[] tolc;
    private static final int[] tolcHash;
    private static final int[] tolcPlusHash;

    public static int getStringHash(String str) {
        int len = str.length();
        int hash = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                hash = (hash << 5) - hash + tolcPlusHash[c];
                continue;
            }
            c = Character.toLowerCase(Character.toUpperCase(c));
            hash = (hash << 5) - hash + c + tolcHash[c & 0x7F];
        }
        return hash;
    }

    public static boolean equalStrings(String str1, String str2) {
        int len = str1.length();
        if (len != str2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c2;
            char c1 = str1.charAt(i);
            if (c1 == (c2 = str2.charAt(i))) continue;
            char c = c1 = c1 < '\u0080' ? tolc[c1] : Character.toLowerCase(Character.toUpperCase(c1));
            if (!(c2 < '\u0080' ? c1 != tolc[c2] : c1 != Character.toLowerCase(Character.toUpperCase(c2)))) continue;
            return false;
        }
        return true;
    }

    static {
        int i;
        tolc = new char[128];
        tolcHash = new int[128];
        tolcPlusHash = new int[128];
        SecureRandom rand = new SecureRandom();
        for (i = 0; i < 128; ++i) {
            CaseInsensitivityHelper.tolc[i] = Character.toLowerCase(Character.toUpperCase((char)i));
            int n = rand.nextInt() + 1;
        }
        for (i = 0; i < 128; ++i) {
            int j = Character.toLowerCase(Character.toUpperCase((char)i));
            int hash = rand.nextInt() + 1;
            if (i < j && tolcHash[j] == 0) {
                CaseInsensitivityHelper.tolcHash[i] = hash;
                CaseInsensitivityHelper.tolcHash[j] = hash;
                continue;
            }
            if (i == j) {
                if (tolcHash[i] != 0) continue;
                CaseInsensitivityHelper.tolcHash[i] = hash;
                continue;
            }
            CaseInsensitivityHelper.tolcHash[i] = tolcHash[j];
        }
        for (i = 0; i < 128; ++i) {
            CaseInsensitivityHelper.tolcPlusHash[i] = tolc[i] + tolcHash[i];
        }
    }
}

