/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.ConfigValueLookup;
import java.util.concurrent.ConcurrentHashMap;

public class ComponentStatus {
    private static ConcurrentHashMap<ServerComponent, Boolean> startedComponents = new ConcurrentHashMap();
    private static int startupDelayMs = ConfigValueLookup.getValueAsInt("com.filenet.engine.ComponentStartupDelay", 0) * 1000;

    public static void componentStarted(ServerComponent sc) {
        if (startupDelayMs > 0) {
            try {
                Thread.sleep(startupDelayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        startedComponents.put(sc, true);
    }

    public static void componentStopped(ServerComponent sc) {
        startedComponents.remove((Object)sc);
    }

    public static synchronized boolean isComponentStarted(ServerComponent sc) {
        return startedComponents.containsKey((Object)sc);
    }

    public static enum ServerComponent {
        CEWS,
        PEWS,
        PEEngine,
        RESTRegistration,
        RESTProvision;

    }
}

