/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.ContextKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ContextEntries {
    private final Map entries = new HashMap();
    private final Values values;

    public ContextEntries(Values values) {
        this.values = values;
    }

    public void put(ContextKey key) {
        Map entries = this.entries;
        while (true) {
            Object context = key.getContext();
            Object object = key.getObject();
            HashMap<Object, ContextKey> map = (HashMap<Object, ContextKey>)entries.get(context);
            if (map == null) {
                map = new HashMap<Object, ContextKey>();
                entries.put(context, map);
            }
            if (map.put(object, key) != null || !(context instanceof ContextKey)) break;
            key = (ContextKey)context;
        }
    }

    public void remove(ContextKey key) {
        Map entries = this.entries;
        while (!entries.containsKey(key) && !this.values.containsKey(key)) {
            Object context = key.getContext();
            Object object = key.getObject();
            Map map = (Map)entries.get(context);
            if (map != null) {
                map.remove(object);
                if (map.size() == 0) {
                    entries.remove(context);
                }
            }
            if (!(context instanceof ContextKey)) break;
            key = (ContextKey)context;
        }
    }

    public ContextKey[] getKeys(Object context) {
        Map map = (Map)this.entries.get(context);
        if (map == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (Object key : map.values()) {
            if (!this.values.containsKey(key)) continue;
            list.add(key);
        }
        return list.toArray(new ContextKey[list.size()]);
    }

    public ContextKey find(Object context, Object object) {
        if (context == null) {
            return null;
        }
        Map map = (Map)this.entries.get(context);
        return map == null ? null : (ContextKey)map.get(object);
    }

    public ContextKey make(Object context, Object object) {
        ContextKey key = this.find(context, object);
        return key == null ? new ContextKey(context, object) : key;
    }

    public void clear() {
        this.entries.clear();
    }

    public String toString() {
        return this.entries.toString();
    }

    public static interface Values {
        public boolean containsKey(Object var1);
    }
}

