/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.authentication.Credentials;
import com.filenet.apiimpl.util.UnifiedUtil;
import java.security.PrivilegedExceptionAction;

public class ImpersonationCredentials
extends Credentials {
    private String userName;

    public ImpersonationCredentials(String userName) {
        this.userName = userName;
    }

    public String getUsername() {
        return this.userName;
    }

    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> pea) {
        try {
            UnifiedUtil.beginImp(this.userName);
            T t = super.doAs(pea);
            return t;
        }
        finally {
            UnifiedUtil.endImp();
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ImpersonationCredentials)) {
            return false;
        }
        ImpersonationCredentials uc = (ImpersonationCredentials)other;
        return this.userName.equals(uc.userName);
    }

    public int hashCode() {
        return this.userName.hashCode();
    }

    public String toString() {
        return "Imersonation credentials: username=" + this.userName;
    }
}

