/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.authentication.util.AuthnUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class J2EEType {
    public static final int APP_SERVER_UNDETERMINED = 0;
    public static final int APP_SERVER_UNKNOWN = 1;
    public static final int APP_SERVER_WEBLOGIC = 2;
    public static final int APP_SERVER_WEBSPHERE = 3;
    public static final int APP_SERVER_WEBSPHERE_LIBERTY = 4;
    public static final String APP_SERVER_PROP_NAME = "com.filenet.AppServerType";
    public static final String APP_SERVER_PROP_NAME2 = "com.filenet.AppServer";
    public static final String APP_SERVER_TYPE_PROP = "FileNet.properties";
    private static int appServerType;
    private static String providerURL;
    private static String givenInitCxtFactoryName;
    private static boolean isContextOk;
    private static boolean isContextTried;
    public static boolean isGalaxyTaskEngine;
    public static final String[] APP_SERVER_NAMES;
    private static final String FNAME = "[J2EEType] ";
    private static final AppInfo[] appInfo;

    private J2EEType() {
    }

    public static synchronized boolean isUndetermined() {
        return appServerType == 0;
    }

    public static int getAppServerType() {
        return J2EEType.getAppServerType(null, null);
    }

    public static synchronized int getAppServerType(String appServerName, String initCxtFactoryName) {
        if (initCxtFactoryName != null) {
            givenInitCxtFactoryName = initCxtFactoryName;
        }
        if (appServerType == 0) {
            if (appServerName != null) {
                appServerType = J2EEType.findType(appServerName);
            }
            if (appServerType == 0) {
                J2EEType.tryAllInitialContexts();
            }
            if (appServerType == 0) {
                for (int i = 0; i < appInfo.length; ++i) {
                    if (J2EEType.appInfo[i].defaultClass == null) continue;
                    try {
                        Class<?> c = Class.forName(J2EEType.appInfo[i].defaultClass);
                        if (c == null) continue;
                        appServerType = J2EEType.appInfo[i].appType;
                        break;
                    }
                    catch (Throwable c) {
                        // empty catch block
                    }
                }
            }
            if (appServerType == 0 || appServerType == 4) {
                ProtectionDomain pDomain = null;
                try {
                    pDomain = J2EEType.class.getProtectionDomain();
                }
                catch (Throwable c) {
                    // empty catch block
                }
                CodeSource cs = null;
                if (pDomain != null) {
                    cs = pDomain.getCodeSource();
                }
                URL url = null;
                if (cs != null) {
                    url = cs.getLocation();
                }
                String urlBase = null;
                if (url != null) {
                    urlBase = url.toExternalForm();
                }
                if (urlBase != null) {
                    if (urlBase.toLowerCase().indexOf("engine-liberty.ear") > -1) {
                        appServerType = 4;
                    } else if (urlBase.toLowerCase().indexOf("engine-gte.ear") > -1) {
                        appServerType = 4;
                        isGalaxyTaskEngine = true;
                    }
                }
            }
            if (appServerType == 0) {
                appServerType = 1;
            }
        }
        return appServerType;
    }

    public static synchronized void setAppServerType(int type) {
        if (type < 0 || type >= APP_SERVER_NAMES.length) {
            throw new IllegalArgumentException();
        }
        appServerType = type;
    }

    public static synchronized String getAppServer() {
        return APP_SERVER_NAMES[appServerType];
    }

    public static synchronized void setAppServer(String str) {
        int type = J2EEType.findType(str);
        if (type == 0 && str != null) {
            throw new IllegalArgumentException();
        }
        appServerType = type;
    }

    public static synchronized String getProviderURL() {
        if (providerURL == null && (providerURL = J2EEType.getPrivilegedProperty("java.naming.provider.url")) == null) {
            J2EEType.tryAllInitialContexts();
        }
        return providerURL;
    }

    public static synchronized void setProviderURL(String url) {
        providerURL = url;
    }

    public static synchronized boolean isInitialContextOk() {
        J2EEType.tryAllInitialContexts();
        return isContextOk;
    }

    protected static int findType(String str) {
        int type = 0;
        if (str != null) {
            str = str.toLowerCase(Locale.US);
            for (int i = 0; i < appInfo.length; ++i) {
                if (str.indexOf(J2EEType.appInfo[i].matchString) < 0) continue;
                type = J2EEType.appInfo[i].appType;
                break;
            }
        }
        return type;
    }

    private static void tryAllInitialContexts() {
        if (!isContextTried) {
            int type = 0;
            if (givenInitCxtFactoryName != null) {
                type = J2EEType.tryInitialContext(givenInitCxtFactoryName);
            }
            if (type == 0) {
                type = J2EEType.tryInitialContext(null);
            }
            isContextTried = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int tryInitialContext(String factory) {
        int type = 0;
        InitialContext context = null;
        try {
            String initCntxFactory;
            context = J2EEType.reflective_J2EEUtil_getInitialContextWithParameters(factory);
            isContextOk = true;
            Hashtable<?, ?> env = context.getEnvironment();
            if (providerURL == null) {
                providerURL = (String)env.get("java.naming.provider.url");
            }
            if ((type = J2EEType.findType(initCntxFactory = (String)env.get("java.naming.factory.initial"))) == 3) {
                context.lookup("");
            }
        }
        catch (Throwable t) {
            AuthnUtil.log("[J2EEType] Detecting app server : tried to get InitialContext but that did not work so will try other method; message from trial: " + t.getLocalizedMessage());
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Throwable env) {}
            }
        }
        if (appServerType == 0) {
            appServerType = type;
        }
        return type;
    }

    public static InitialContext reflective_J2EEUtil_getInitialContextWithParameters() throws NamingException {
        return J2EEType.reflective_J2EEUtil_getInitialContextWithParameters(null);
    }

    public static InitialContext reflective_J2EEUtil_getInitialContextWithParameters(String factory) throws NamingException {
        try {
            Class<?> j2eeUtilClass = Class.forName("com.filenet.apiimpl.util.J2EEUtil");
            Class<?> connClass = Class.forName("com.filenet.apiimpl.core.ConnectionImpl");
            Method gICWP = j2eeUtilClass.getDeclaredMethod("getEJBJndiEnvironment", connClass);
            Properties env = (Properties)gICWP.invoke(null, new Object[]{null});
            if (factory != null) {
                if (env == null) {
                    env = new Properties();
                }
                env.put("java.naming.factory.initial", factory);
            }
            return new InitialContext(env);
        }
        catch (Throwable t) {
            return new InitialContext();
        }
    }

    private static final String getPrivilegedProperty(final String propertyName) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        };
        try {
            return (String)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static {
        isGalaxyTaskEngine = false;
        APP_SERVER_NAMES = new String[]{"undetermined", "unknown", "WebLogic", "WebSphere", "WebSphereLiberty"};
        appInfo = new AppInfo[]{new AppInfo("weblogic", 2, "weblogic.jndi.WLInitialContextFactory"), new AppInfo("websphere", 3, "com.ibm.websphere.naming.WsnInitialContextFactory"), new AppInfo("liberty", 4, null), new AppInfo("unknown", 1, null)};
    }

    private static class AppInfo {
        String matchString;
        int appType;
        String defaultClass;

        AppInfo(String matchString, int appType, String defaultClass) {
            this.matchString = matchString;
            this.appType = appType;
            this.defaultClass = defaultClass;
        }
    }
}

