/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.J2EEUtilWSBase;
import com.filenet.apiimpl.util.SubSystem;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class J2EEUtilWS
extends J2EEUtilWSBase {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(J2EEUtilWS.class, SubSystem.API);
    private static String WS_J2CCF_JNDI = null;
    private static final String WAS_MAPPING_JAAS_STANZA = "DefaultPrincipalMapping";

    protected J2EEUtilWS() {
    }

    @Override
    public String getTransactionManagerPath() {
        return null;
    }

    @Override
    public UserTransaction getUserTransaction(Context cntx) {
        try {
            Context comp = (Context)cntx.lookup("jta");
            Object userTrans = comp.lookup("usertransaction");
            return (UserTransaction)userTrans;
        }
        catch (Throwable e) {
            J2EEUtilWS.handleException(e);
            return null;
        }
    }

    @Override
    public synchronized TransactionManager getTransactionManager(Context cntx) {
        try {
            Class cl = TransactionManagerFactorySelector.tmfClass;
            Method method = cl.getMethod("getTransactionManager", null);
            Object tm = method.invoke(null, (Object[])null);
            return (TransactionManager)tm;
        }
        catch (Throwable e) {
            J2EEUtilWS.handleException(e);
            return null;
        }
    }

    @Override
    public String getLocalEnginePath() {
        return ConfigValueLookup.getValue("LocalEnginePath", "local:ejb/FileNet/Engine");
    }

    @Override
    public String getLocalEngineCorePath() {
        return "java:comp/env/EngineCoreLocal";
    }

    @Override
    public String getLocalEngineContentPath() {
        return ConfigValueLookup.getValue("LocalContentPath", "local:ejb/FileNet/EngineContent");
    }

    @Override
    public String getLocalEngineContentCorePath() {
        return "java:comp/env/EngineContentCoreLocal";
    }

    @Override
    public String getLocalEngineCommPath() {
        return ConfigValueLookup.getValue("LocalCommPath", "local:ejb/FileNet/EngineComm");
    }

    @Override
    public String getLocalEngineCommCorePath() {
        return "java:comp/env/EngineCommCoreLocal";
    }

    @Override
    public String getJaasContextFile() {
        return "jaas.conf.WebSphere";
    }

    @Override
    public void initializeORB() {
        J2EEUtilWS.initializeORBInternal();
    }

    private static void initializeORBInternal() {
        try {
            J2EEUtil.getInstance();
            InitialContext ic = J2EEUtil.getInitialContextWithParameters(null);
            ic.lookup("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PasswordAuthentication getJ2CAliasCredentials(String aliasName) {
        PasswordAuthentication aliasDetails = null;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("seeking J2C alias details for '" + aliasName + "'");
        }
        try {
            aliasDetails = J2EEUtilWS.getJ2CAliasCredentialsInternal(aliasName);
        }
        catch (Exception e) {
            logger.traceSummary("getJ2CAliasCredentials call for '" + aliasName + "' failed - Exception = " + e);
        }
        return aliasDetails;
    }

    private void trace(String method, String message, Object ... params) {
        this.trace(J2EEUtilWS.class, method, message, params);
    }

    private static final PasswordAuthentication getJ2CAliasCredentialsInternal(String aliasName) throws IllegalAccessException, InvocationTargetException, LoginException {
        PasswordAuthentication aliasDetails;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MAPPING_ALIAS_KEY, aliasName);
        CallbackHandler callbackHandler = J2EEUtilWS.getMappingCallbackHandler(map);
        LoginContext lc = new LoginContext(WAS_MAPPING_JAAS_STANZA, callbackHandler);
        lc.login();
        Subject subject = lc.getSubject();
        Set<Object> creds = subject.getPrivateCredentials();
        PasswordCredential result = (PasswordCredential)creds.iterator().next();
        if (result == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("No alias details available for '" + aliasName + "', null PasswordCredential mapped");
            }
            aliasDetails = null;
        } else {
            String userName = result.getUserName();
            if (userName == null || userName.length() == 0) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("No alias details available for '" + aliasName + "', null or empty user name mapped");
                }
                aliasDetails = null;
            } else {
                aliasDetails = new PasswordAuthentication(result.getUserName(), result.getPassword());
            }
            char[] password = result.getPassword();
            if (logger.isDetailTraceEnabled()) {
                if (password == null) {
                    logger.traceDetail("Alias details available for '" + aliasName + "', user '" + userName + "', null password");
                } else if (password.length == 0) {
                    logger.traceDetail("Alias details available for '" + aliasName + "', user '" + userName + "', empty password");
                } else {
                    logger.traceDetail("Alias details available for '" + aliasName + "', user '" + userName + "', with a password");
                }
            }
        }
        return aliasDetails;
    }

    private static final CallbackHandler getMappingCallbackHandler(Map map) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object factory = j2caFactoryGetInstanceMethod.invoke(null, (Object[])null);
        Object[] args = new Object[]{map, null};
        CallbackHandler cbh = (CallbackHandler)j2caGetCallbackHandlerMethod.invoke(factory, args);
        return cbh;
    }

    static {
        try {
            logger.traceDetail("Resolving static reflective items for doAs");
            doAsClass = Class.forName("com.ibm.websphere.security.auth.WSSubject");
            Class[] doAsArgTypes = new Class[]{Subject.class, PrivilegedExceptionAction.class};
            doAsMethod = doAsClass.getDeclaredMethod("doAs", doAsArgTypes);
            getSubjectMethod = doAsClass.getDeclaredMethod("getCallerSubject", null);
            getRunAsSubjectMethod = doAsClass.getDeclaredMethod("getRunAsSubject", null);
            try {
                Class<?> oidcClientHelperClass = Class.forName("com.ibm.websphere.security.oidc.util.OidcClientHelper");
                if (oidcClientHelperClass != null) {
                    getAccessTokenMethod = oidcClientHelperClass.getDeclaredMethod("getAccessTokenFromSubject", null);
                    getIdTokenMethod = oidcClientHelperClass.getDeclaredMethod("getIdTokenFromSubject", null);
                }
            }
            catch (Throwable t) {
                logger.traceDetail("WebSphere OidcClientHelper unavailable.");
            }
            try {
                Class<?> webSecurityHelperClass = Class.forName("com.ibm.websphere.security.web.WebSecurityHelper");
                getSSOCookieMethod = webSecurityHelperClass.getDeclaredMethod("getSSOCookieFromSSOToken", null);
            }
            catch (Exception e) {
                logger.traceDetail("WebSecurityHelper not available.");
            }
            logger.traceDetail("Resolving static reflective items for J2C aliases");
            Class<?> mappingConstantClass = Class.forName("com.ibm.wsspi.security.auth.callback.Constants");
            Field mappingAliasKeyField = mappingConstantClass.getField("MAPPING_ALIAS");
            MAPPING_ALIAS_KEY = mappingAliasKeyField.get(null).toString();
            Class<?> factoryClass = Class.forName("com.ibm.wsspi.security.auth.callback.WSMappingCallbackHandlerFactory");
            j2caFactoryGetInstanceMethod = factoryClass.getMethod("getInstance", null);
            Class[] j2cArgTypes = new Class[]{Map.class, ManagedConnectionFactory.class};
            j2caGetCallbackHandlerMethod = factoryClass.getMethod("getCallbackHandler", j2cArgTypes);
            logger.traceDetail("static call to internally initialize ORB");
            J2EEUtilWS.initializeORBInternal();
        }
        catch (Throwable e) {
            J2EEUtilWS.handleException(e);
        }
    }

    private static class TransactionManagerFactorySelector {
        private static final String WSTMF_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
        private static final String WSTMF_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
        private static final String WSTMF_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
        private static Class tmfClass = null;
        private static Exception savedEx = null;

        private TransactionManagerFactorySelector() {
        }

        private static Class getTransactionManagerFactoryClass(String factoryClass, String versionNumber) {
            try {
                return Class.forName(factoryClass);
            }
            catch (Exception ex) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Could not find WebSphere " + versionNumber + " TransactionManagerFactory class " + factoryClass + ".");
                }
                if (savedEx == null) {
                    savedEx = ex;
                }
                return null;
            }
        }

        static {
            tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_5_1, "5.1");
            if (tmfClass == null) {
                tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_5_0, "5.0");
            }
            if (tmfClass == null) {
                tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_4, "4");
            }
            if (tmfClass == null) {
                throw new EngineRuntimeException(savedEx, ExceptionCode.E_CLASS_LOADING_ERROR, new Object[]{"com.ibm.ws.Transaction.TransactionManagerFactory, com.ibm.ejs.jts.jta.TransactionManagerFactory, com.ibm.ejs.jts.jta.JTSXA"});
            }
        }
    }
}

