/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.constants.Charsets;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class JaasConfiguration
extends Configuration {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(JaasConfiguration.class, SubSystem.Security);
    private static final String WEBSPHERE_CONFIGURATION = "com.ibm.ws.security.auth.login.Configuration";
    private Configuration origConfig = null;
    private HashMap defaultEntries = null;
    private StreamTokenizer st = null;
    private static boolean isInitialized = false;

    private JaasConfiguration(Configuration config) {
        this.origConfig = config;
        try {
            String file = J2EEUtil.getInstance().getJaasContextFile();
            URL url = JaasConfiguration.class.getClassLoader().getResource(file);
            if (url != null) {
                this.defaultEntries = this.parseJAASConfig(url);
            }
            if (logger.isSummaryTraceEnabled()) {
                logger.traceSummary("Default JAAS Configuration: " + this.getDefaultTraceEntries());
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable t) {
            throw (SecurityException)new SecurityException(ExceptionCode.SECURITY_DEFAULT_CONFIG_EXCEPTION.toString(new Object[]{this.lineno(), t.getLocalizedMessage()})).initCause(t);
        }
        if (this.defaultEntries == null) {
            this.defaultEntries = new HashMap();
        }
    }

    private String getDefaultTraceEntries() {
        StringBuffer retVal = new StringBuffer();
        if (this.defaultEntries == null || this.defaultEntries.isEmpty()) {
            return "None";
        }
        for (Map.Entry ent : this.defaultEntries.entrySet()) {
            AppConfigurationEntry[] ce = (AppConfigurationEntry[])ent.getValue();
            retVal.append("\n");
            retVal.append((String)ent.getKey());
            retVal.append(" {\n");
            retVal.append(this.getLogString(ce));
            retVal.append("}\n ");
        }
        return retVal.toString();
    }

    private String getLogString(AppConfigurationEntry[] ce) {
        StringBuffer retVal = new StringBuffer();
        if (ce != null && ce.length > 0) {
            for (int lp = 0; lp < ce.length; ++lp) {
                retVal.append("    ");
                retVal.append(ce[lp].getLoginModuleName());
                retVal.append(" ");
                retVal.append(this.getLMControlFlag(ce[lp].getControlFlag()));
                retVal.append(";\n");
            }
        }
        return retVal.toString();
    }

    private String getLMControlFlag(AppConfigurationEntry.LoginModuleControlFlag lmcf) {
        if (lmcf == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
            return "optional";
        }
        if (lmcf == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
            return "required";
        }
        if (lmcf == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
            return "requisite";
        }
        if (lmcf == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
            return "sufficient";
        }
        return "";
    }

    public static synchronized void setConfiguration() {
        block9: {
            Configuration config;
            block8: {
                if (isInitialized) {
                    return;
                }
                config = null;
                try {
                    PrivilegedAction paGet = new PrivilegedAction(){

                        public Object run() {
                            return Configuration.getConfiguration();
                        }
                    };
                    config = (Configuration)AccessController.doPrivileged(paGet);
                    if (config != null && (config instanceof JaasConfiguration || JaasConfiguration.class.getName().equals(config.getClass().getName()) || WEBSPHERE_CONFIGURATION.equals(config.getClass().getName()))) {
                        isInitialized = true;
                        return;
                    }
                }
                catch (IllegalStateException t) {
                    if (logger.isSummaryTraceEnabled()) {
                        logger.traceSummary(Exceptions.printStackTrace(t, null, true));
                    }
                }
                catch (SecurityException se) {
                    if (!logger.isSummaryTraceEnabled()) break block8;
                    logger.traceSummary(Exceptions.printStackTrace(se, null, true));
                }
            }
            final Configuration fConfig = config;
            PrivilegedAction paSet = new PrivilegedAction(){

                public Object run() {
                    Configuration.setConfiguration(new JaasConfiguration(fConfig));
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(paSet);
            }
            catch (SecurityException se) {
                if (!logger.isSummaryTraceEnabled()) break block9;
                logger.traceSummary(Exceptions.printStackTrace(se, null, true));
            }
        }
        isInitialized = true;
    }

    @Override
    public void refresh() {
        if (this.origConfig != null) {
            this.origConfig.refresh();
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        AppConfigurationEntry[] entries;
        block20: {
            entries = null;
            if (this.origConfig != null) {
                block19: {
                    try {
                        entries = this.origConfig.getAppConfigurationEntry(applicationName);
                        if (entries != null) {
                            if (logger.isDetailTraceEnabled()) {
                                logger.traceDetail("Configured JAAS entry found (Default not used) for: '" + applicationName + "' " + this.getLogString(entries));
                            }
                        } else if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("No configured JAAS entry found for: '" + applicationName + "'...trying 'other'");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (!logger.isDetailTraceEnabled()) break block19;
                        logger.traceDetail("No configured JAAS entry found for:" + applicationName + " " + Exceptions.printStackTrace(e, null, true));
                    }
                }
                if (entries == null) {
                    try {
                        entries = this.origConfig.getAppConfigurationEntry("other");
                        if (entries != null) {
                            if (logger.isDetailTraceEnabled()) {
                                logger.traceDetail("Configured JAAS entry found for 'other' (Default not used): " + this.getLogString(entries));
                            }
                        } else if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("No configured JAAS entry found for: 'other'");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (!logger.isDetailTraceEnabled()) break block20;
                        logger.traceDetail("No configured JAAS entry found for: 'other' " + Exceptions.printStackTrace(e, null, true));
                    }
                }
            }
        }
        if (this.defaultEntries != null && entries == null) {
            entries = (AppConfigurationEntry[])this.defaultEntries.get(applicationName);
            if (entries != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Default JAAS entry found for:" + applicationName);
                }
            } else if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("No default JAAS entry found for:" + applicationName);
            }
        }
        return entries;
    }

    private HashMap parseJAASConfig(URL url) throws SecurityException, IOException {
        HashMap<String, AppConfigurationEntry[]> contexts = new HashMap<String, AppConfigurationEntry[]>();
        if (url != null) {
            InputStream is = url.openStream();
            BufferedReader r = null;
            if (is != null) {
                r = new BufferedReader(new InputStreamReader(is, Charsets.CHARSET_UTF_8));
            }
            if (r != null) {
                this.st = new StreamTokenizer(r);
            }
            if (this.st != null) {
                this.st.wordChars(36, 36);
                this.st.wordChars(95, 95);
                this.st.ordinaryChars(48, 57);
                this.st.wordChars(48, 57);
                this.st.ordinaryChar(39);
                this.st.ordinaryChar(47);
                this.st.slashSlashComments(true);
                this.st.slashStarComments(true);
                this.st.eolIsSignificant(false);
                int ttype = this.st.nextToken();
                while (ttype != -1) {
                    if (ttype != -3 && ttype != 34) {
                        throw this.parseError("stanza_label");
                    }
                    String contextName = this.st.sval;
                    ttype = this.st.nextToken();
                    if (ttype != 123) {
                        throw this.parseError("'{'");
                    }
                    AppConfigurationEntry appEntry = null;
                    ArrayList<AppConfigurationEntry> alist = new ArrayList<AppConfigurationEntry>();
                    while ((appEntry = this.readAppEntry()) != null) {
                        alist.add(appEntry);
                    }
                    ttype = this.st.nextToken();
                    if (ttype != 59) {
                        throw this.parseError("';'");
                    }
                    contexts.put(contextName, alist.toArray(new AppConfigurationEntry[alist.size()]));
                    ttype = this.st.nextToken();
                }
            }
        }
        this.st = null;
        return contexts;
    }

    private AppConfigurationEntry readAppEntry() throws SecurityException, IOException {
        String loginModuleName = null;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = null;
        HashMap<String, String> options = new HashMap<String, String>();
        int ttype = this.st.nextToken();
        if (ttype == 125) {
            return null;
        }
        if (ttype != -3 && ttype != 34) {
            throw this.parseError("login_module_class");
        }
        loginModuleName = this.st.sval;
        ttype = this.st.nextToken();
        if (ttype != -3 && ttype != 34) {
            throw this.parseError("control_flag");
        }
        if (this.st.sval.equalsIgnoreCase("optional")) {
            controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else if (this.st.sval.equalsIgnoreCase("required")) {
            controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (this.st.sval.equalsIgnoreCase("requisite")) {
            controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (this.st.sval.equalsIgnoreCase("sufficient")) {
            controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else {
            throw this.parseError("valid_control_flag");
        }
        ttype = this.st.nextToken();
        while (ttype != 59) {
            if (ttype != -3 && ttype != 34) {
                throw this.parseError("option_key");
            }
            String name = this.st.sval;
            ttype = this.st.nextToken();
            if (ttype != 61) {
                throw this.parseError("'='");
            }
            ttype = this.st.nextToken();
            if (ttype != -3 && ttype != 34) {
                throw this.parseError("option_value" + ttype);
            }
            String value = this.st.sval;
            if (ttype == 34 && value != null && value.length() > 0 && (value = this.expand(value)).length() == 0) {
                throw this.parseError("non_empty_value");
            }
            options.put(name, value);
            ttype = this.st.nextToken();
        }
        return new AppConfigurationEntry(loginModuleName, controlFlag, options);
    }

    private SecurityException parseError(String expected) {
        return new SecurityException(ExceptionCode.SECURITY_DEFAULT_CONFIG_PARSE_ERROR.toString(new Object[]{this.lineno(), expected}));
    }

    private String lineno() {
        return this.st == null ? "?" : Integer.toString(this.st.lineno());
    }

    private String expand(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int ps = value.indexOf("${");
        if (ps < 0) {
            return value;
        }
        int len = value.length();
        StringBuffer buf = new StringBuffer(len);
        int copied = 0;
        do {
            int pe;
            if (ps > copied) {
                buf.append(value.substring(copied, ps));
                copied = ps;
            }
            if ((ps += 2) >= len) break;
            if (value.charAt(ps) == '{') {
                pe = value.indexOf("}}", ps);
                if (pe < 0) break;
                ps = pe + 2;
                continue;
            }
            pe = value.indexOf(125, ps);
            if (pe < 0) break;
            String key = value.substring(ps, pe);
            if (key.equals("/")) {
                buf.append(File.separatorChar);
            } else {
                String repl = JaasConfiguration.getPrivilegedProperty(key);
                if (repl == null) {
                    throw new SecurityException(ExceptionCode.SECURITY_DEFAULT_CONFIG_EXPAND_ERROR.toString(new Object[]{key, this.lineno()}));
                }
                buf.append(repl);
            }
            copied = ps = pe + 1;
        } while (ps < len && (ps = value.indexOf("${", ps)) >= 0);
        if (copied < len) {
            buf.append(value.substring(copied));
        }
        return buf.toString();
    }

    private static final String getPrivilegedProperty(final String propertyName) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        };
        try {
            return (String)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            JaasConfiguration.setConfiguration();
            PrivilegedAction paGet = new PrivilegedAction(){

                public Object run() {
                    return Configuration.getConfiguration();
                }
            };
            Configuration c = (Configuration)AccessController.doPrivileged(paGet);
            AppConfigurationEntry[] entries = c.getAppConfigurationEntry("FileNetP8WSI");
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    System.out.println(entries[i].getLoginModuleName());
                }
            }
        }
        catch (Throwable t) {
            logger.error("Exception in main", t);
        }
    }
}

