/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class LocaleUtils {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(LocaleUtils.class, SubSystem.API);
    private static Pattern primaryTag = Pattern.compile("[ix]|[a-zA-Z]{2,3}");
    private static Pattern subTag = Pattern.compile("[a-zA-Z0-9]{2,8}");
    private static Pattern separator = Pattern.compile("[_-]");
    private static Map locales = new HashMap();
    private static final String FALLBACK_LOCALE = "en-us";
    private static String defaultLocaleName = ConfigValueLookup.getValue("com.filenet.engine.init.DefaultLocale", "en-us");
    private static Map<String, String[]> localeEquivalentsForBoth;
    private static Map<String, String[]> localeEquivalentsForLanguage;
    private static Map<String, String[]> localeEquivalentsForCountry;

    private LocaleUtils() {
    }

    public static String[] validateLocaleName(String localeName, boolean forPersistence) {
        if (localeName == null) {
            return null;
        }
        String[] localeParts = new String[]{null, null};
        String[] s = separator.split(localeName);
        boolean matches = true;
        for (int i = 0; i < s.length && matches; ++i) {
            if (i == 0) {
                if (s[0].length() > 0) {
                    matches = primaryTag.matcher(s[0]).matches();
                    if (!matches) continue;
                    localeParts[0] = s[0].toLowerCase();
                    continue;
                }
                if (forPersistence) {
                    matches = false;
                    continue;
                }
                if (defaultLocaleName == null) continue;
                localeParts = separator.split(defaultLocaleName);
                continue;
            }
            if (s[i].length() <= 0 || !(matches = subTag.matcher(s[i]).matches()) || i != 1) continue;
            localeParts[1] = s[1].toLowerCase();
        }
        if (localeParts[0] != null && localeParts[0].length() == 1 && localeParts[1] == null) {
            matches = false;
        }
        if (!matches) {
            if (localeName.equals("C")) {
                localeParts[0] = Locale.getDefault().getLanguage().toLowerCase();
                localeParts[1] = Locale.getDefault().getCountry().toLowerCase();
                matches = true;
            } else {
                localeParts = null;
            }
        }
        return localeParts;
    }

    public static String[] validateLocaleName(String localeName) {
        if (locales.containsKey(localeName)) {
            return (String[])locales.get(localeName);
        }
        String[] localeParts = LocaleUtils.validateLocaleName(localeName, false);
        locales.put(localeName, localeParts);
        return localeParts;
    }

    public static Locale fromString(String localeString) {
        String[] localeParts = LocaleUtils.validateLocaleName(localeString);
        if (localeParts == null) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_LOCALE_FORMAT, new Object[]{localeString});
        }
        Locale loc = localeParts[1] != null ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeParts[0]);
        return loc;
    }

    public static String getDefaultLocaleName() {
        return defaultLocaleName;
    }

    public static String toXmlLanguageTag(Locale locale) {
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        String region = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer out = new StringBuffer(language);
        if (region != null && region.length() > 0) {
            out.append('-').append(region);
        }
        if (variant != null && variant.length() > 0) {
            out.append('-').append(variant);
        }
        return out.toString();
    }

    private static void initEquivTables() {
        String tableOfTables = ConfigValueLookup.getValue("com.filenet.locale.equivalents", "|,he_*,iw_*,|,nb_NO,nb_*,no_*,|");
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Locale equivalents table: " + tableOfTables);
        }
        if (tableOfTables == null) {
            return;
        }
        if ((tableOfTables = tableOfTables.trim()).length() == 0) {
            return;
        }
        String outsideDelimiter = tableOfTables.substring(0, 1);
        outsideDelimiter = Pattern.quote(outsideDelimiter);
        String[] tables = tableOfTables.split(outsideDelimiter);
        for (int ii = 0; ii < tables.length; ++ii) {
            String table = tables[ii];
            if (table == null || (table = table.trim()).length() == 0) continue;
            String insideDelimiter = table.substring(0, 1);
            insideDelimiter = Pattern.quote(insideDelimiter);
            String[] equivs = table.split(insideDelimiter);
            String[] target = null;
            for (int jj = 0; jj < equivs.length; ++jj) {
                String[] previousTarget;
                String equiv = equivs[jj];
                if (equiv == null || (equiv = equiv.trim()).length() == 0) continue;
                String[] e = LocaleUtils.validateLocaleName(equiv.replace("*", ""));
                boolean wildLanguage = false;
                if (e[0] == null || e[0].length() == 0) {
                    e[0] = "*";
                    wildLanguage = true;
                }
                boolean wildCountry = false;
                if (e[1] == null || e[1].length() == 0) {
                    e[1] = "*";
                    wildCountry = true;
                }
                if (target == null) {
                    target = e;
                    continue;
                }
                e[0] = e[0].toLowerCase();
                e[1] = e[1].toLowerCase();
                equiv = e[0] + "_" + e[1];
                if (wildCountry) {
                    previousTarget = localeEquivalentsForLanguage.get(e[0]);
                    if (previousTarget != null) {
                        logger.warn("Overlaying locale equivalence of " + equiv);
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Recording Locale equivalence L for source " + equiv + ", target " + target[0] + "_" + target[1]);
                    }
                    localeEquivalentsForLanguage.put(e[0], target);
                    continue;
                }
                if (wildLanguage) {
                    previousTarget = localeEquivalentsForCountry.get(e[1]);
                    if (previousTarget != null) {
                        logger.warn("Overlaying locale equivalence of " + equiv);
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Recording Locale equivalence C for source " + equiv + ", target " + target[0] + "_" + target[1]);
                    }
                    localeEquivalentsForCountry.put(e[1], target);
                    continue;
                }
                previousTarget = localeEquivalentsForBoth.get(equiv);
                if (previousTarget != null) {
                    logger.warn("Overlaying locale equivalence of " + equiv);
                }
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Recording Locale equivalence B for source " + equiv + ", target " + target[0] + "_" + target[1]);
                }
                localeEquivalentsForBoth.put(equiv, target);
            }
        }
    }

    public static boolean localeSpecialCaseSwitcheroo(String[] lc) {
        String country;
        String language = lc[0];
        if (language != null && (language = language.trim().toLowerCase()).length() == 0) {
            language = null;
        }
        if ((country = lc[1]) != null && (country = country.trim().toLowerCase()).length() == 0) {
            country = null;
        }
        if (language == null && country == null) {
            return false;
        }
        String[] target = null;
        if (language != null && country != null) {
            target = localeEquivalentsForBoth.get(language + "_" + country);
        }
        if (target == null && language != null) {
            target = localeEquivalentsForLanguage.get(language);
        }
        if (target == null && country != null) {
            target = localeEquivalentsForCountry.get(country);
        }
        if (target == null) {
            return false;
        }
        if (!"*".equals(target[0])) {
            lc[0] = target[0];
        }
        if (!"*".equals(target[1])) {
            lc[1] = target[1];
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Locale substitution from " + LocaleUtils.NS(language) + "_" + LocaleUtils.NS(country) + " to " + LocaleUtils.NS(lc[0]) + "_" + LocaleUtils.NS(lc[1]) + " via target " + LocaleUtils.NS(target[0]) + "_" + LocaleUtils.NS(target[1]));
        }
        return true;
    }

    private static final String NS(String in) {
        if (in == null) {
            return "*";
        }
        return in;
    }

    static {
        String[] localeParts = LocaleUtils.validateLocaleName(defaultLocaleName, true);
        if (!defaultLocaleName.equalsIgnoreCase(FALLBACK_LOCALE)) {
            if (localeParts == null || localeParts[0] == null || localeParts[0].length() == 0) {
                logger.warn("DefaultLocale value of '" + defaultLocaleName + "' is not valid.  Using '" + FALLBACK_LOCALE + "'.");
                defaultLocaleName = FALLBACK_LOCALE;
                localeParts = LocaleUtils.validateLocaleName(defaultLocaleName, true);
            } else {
                defaultLocaleName = localeParts[1] != null && localeParts[1].length() > 0 ? localeParts[0] + "-" + localeParts[1] : localeParts[0];
                logger.info("Using default locale value of '" + defaultLocaleName + "'.");
            }
        }
        localeEquivalentsForBoth = new HashMap<String, String[]>();
        localeEquivalentsForLanguage = new HashMap<String, String[]>();
        localeEquivalentsForCountry = new HashMap<String, String[]>();
        LocaleUtils.initEquivTables();
    }
}

