/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.ApiVersionInfo;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFormatter
extends Formatter {
    private static final String[] SPACE_PADDING = new String[]{" ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           "};
    private static final String[] ZERO_PADDING = new String[]{"0", "00", "000", "0000", "00000", "000000", "0000000", "00000000"};
    protected static final String NEWLINE = System.getProperty("line.separator");
    private static final String NEWLINE_ESCAPE = "\\n";
    private static final String ESCAPE_ESCAPE = "\\\\";
    private static final TimeZone utcTz = LogFormatter.getTimeZoneForLogging();
    private static final String LOGFILE_DATE_SDF_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static HashMap<Level, String> levelNames = new HashMap();
    private static final String productID = "FNRCE";
    private static final Pattern ERE_TOSTRING_ERRORID_PULLER;
    private static final String DOMAIN_HEADER = "Domain       ";
    private static final int MAX_DOMAIN_LENGTH = 12;
    private boolean multiLine;

    public LogFormatter() {
        this.sdf.setTimeZone(utcTz);
        this.multiLine = false;
    }

    void setMultiLine(boolean newValue) {
        this.multiLine = newValue;
    }

    @Override
    public String format(LogRecord record) {
        return this.formatCommon(record, false, null);
    }

    @Override
    public String getHead(Handler h) {
        StringBuilder sbHeader = new StringBuilder(100);
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "unknown host";
        }
        sbHeader.append("Content Engine Java API build:").append(ApiVersionInfo.BUILD_LABEL).append(" on ").append(hostName).append(NEWLINE);
        LogFormatter.getHeadCommon(sbHeader, false, false);
        return sbHeader.toString();
    }

    protected final String formatCommon(LogRecord record, boolean isServer, String domainName) {
        StringBuilder sb = new StringBuilder();
        Date eventDate = new Date(record.getMillis());
        sb.append(this.sdf.format(eventDate));
        sb.append(SPACE_PADDING[0]);
        String tidTxt = String.format("%08X", record.getThreadID());
        sb.append(tidTxt);
        sb.append(SPACE_PADDING[0]);
        String[] lnParts = record.getLoggerName().split(":");
        if (!isServer) {
            sb.append(lnParts[0]).append(":");
        }
        String subSysAbbrev = lnParts[1];
        sb.append(subSysAbbrev);
        int len = subSysAbbrev.length();
        if (len < 4) {
            sb.append(SPACE_PADDING[3 - len]);
        }
        sb.append(SPACE_PADDING[0]);
        String levelName = levelNames.get(record.getLevel());
        if (isServer) {
            LogFormatter.appendMessageId(record, sb, levelName);
        } else {
            sb.append(levelName);
        }
        sb.append(SPACE_PADDING[0]);
        if (domainName != null) {
            int nameLen = domainName.length();
            if (nameLen > 12) {
                domainName = domainName.substring(0, 12);
                nameLen = 12;
            }
            sb.append(domainName);
            sb.append(SPACE_PADDING[12 - nameLen]);
        }
        if (this.multiLine) {
            sb.append(record.getMessage());
        } else {
            LogFormatter.appendRenderedMessage(sb, record.getMessage());
        }
        ArrayList<String> throwableLines = LogFormatter.getThrowableStrRep(record);
        if (throwableLines != null) {
            for (int i = 0; i < throwableLines.size(); ++i) {
                sb.append(this.multiLine ? NEWLINE : NEWLINE_ESCAPE);
                sb.append(throwableLines.get(i));
            }
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static void appendMessageId(LogRecord record, StringBuilder sb, String levelName) {
        String messageId = "FNRCE0000";
        Throwable t = record.getThrown();
        if (t != null) {
            if (t instanceof EngineRuntimeException) {
                EngineRuntimeException ere = (EngineRuntimeException)t;
                ExceptionCode ec = ere.getExceptionCode();
                messageId = ec.getErrorId();
            }
        } else {
            Matcher m;
            String s = record.getMessage();
            if (s != null && (m = ERE_TOSTRING_ERRORID_PULLER.matcher(s)).find()) {
                messageId = m.group(1);
            }
        }
        sb.append(messageId);
        sb.append(levelName.charAt(0)).append(" - ").append(levelName);
    }

    public static ArrayList<String> getThrowableStrRep(LogRecord record) {
        Throwable t = record.getThrown();
        if (t != null) {
            return LogFormatter.getStringRep(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getStringRep(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            throwable.printStackTrace(pw);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        pw.flush();
        ArrayList<String> lines = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            lines.add(ex.toString());
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable2) {}
        }
        return lines;
    }

    protected static final void getHeadCommon(StringBuilder sbHeader, boolean isServer, boolean isMultiDomain) {
        sbHeader.append("All times are local; the time zone is ").append(LogFormatter.getTimeZoneDisplayName()).append("(").append(LogFormatter.getTimeZoneOffSet()).append(")").append(NEWLINE);
        sbHeader.append("Date (").append(LogFormatter.getTimeZoneOffSet()).append(")       Thread   Sub  ");
        if (isServer) {
            sbHeader.append("Category     ");
        } else {
            sbHeader.append("   ");
        }
        sbHeader.append("Sev   ");
        if (isMultiDomain) {
            sbHeader.append(DOMAIN_HEADER);
        }
        sbHeader.append("Message").append(NEWLINE);
    }

    private static String getTimeZoneOffSet() {
        TimeZone tz = TimeZone.getDefault();
        Date date = new Date();
        int offset = tz.getOffset(date.getTime());
        int absOffset = Math.abs(offset);
        return String.format("UTC %s%02d%s%02d", offset >= 0 ? "+" : "-", absOffset / 3600000, ":", absOffset / 60000 % 60);
    }

    private static String getTimeZoneDisplayName() {
        TimeZone tz = TimeZone.getDefault();
        Date date = new Date();
        boolean isDaylightSavings = tz.inDaylightTime(date);
        String displayName = tz.getDisplayName(isDaylightSavings, 1);
        return displayName;
    }

    private static TimeZone getTimeZoneForLogging() {
        TimeZone tz = TimeZone.getDefault();
        String timeZone = System.getProperty("com.filenet.util.logging.TimeZone");
        if (timeZone != null && "GMT".equalsIgnoreCase(timeZone)) {
            tz = TimeZone.getTimeZone("GMT+00");
        }
        return tz;
    }

    private static void appendRenderedMessage(StringBuilder sbuf, String msg) {
        int current = 0;
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char c = msg.charAt(i);
            if (c == '\n' || c == '\f') {
                sbuf.append(msg.substring(current, i));
                sbuf.append(NEWLINE_ESCAPE);
                current = i + 1;
                continue;
            }
            if (c == '\r') {
                sbuf.append(msg.substring(current, i));
                sbuf.append(NEWLINE_ESCAPE);
                if (i + 1 < len && msg.charAt(i + 1) == '\n') {
                    ++i;
                }
                current = i + 1;
                continue;
            }
            if (c != '\\') continue;
            sbuf.append(msg.substring(current, i));
            sbuf.append(ESCAPE_ESCAPE);
            current = i + 1;
        }
        if (current < len) {
            sbuf.append(msg.substring(current));
        }
    }

    static {
        levelNames.put(Level.SEVERE, "ERROR");
        levelNames.put(Level.WARNING, "WARN ");
        levelNames.put(Level.INFO, "INFO ");
        levelNames.put(Level.FINE, "DEBUG");
        levelNames.put(Level.FINER, "DEBUG");
        levelNames.put(Level.FINEST, "DEBUG");
        ERE_TOSTRING_ERRORID_PULLER = Pattern.compile(EngineRuntimeException.class.getName() + ": (" + productID + "[0-9]{4})");
    }
}

