/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SpillStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class MemoryThenFileSpillStreamFactory
implements SpillStreamFactory {
    private SwitchableOutputStream sos = null;
    private final int estimatedCapacity;
    private final int cutoverCapacity;
    private final File directory;
    private final BaseLogger logger;
    private String cid = null;

    private static InputStream openPrivilegedFileInputStream(final File theFile) throws Throwable {
        PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return new FileInputStream(theFile);
            }
        };
        try {
            return (InputStream)AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    private static OutputStream openPrivilegedFileOutputStream(final File theFile) throws Throwable {
        PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return new FileOutputStream(theFile);
            }
        };
        try {
            return (OutputStream)AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    public MemoryThenFileSpillStreamFactory(int estimatedCapacity, int cutoverCapacity, File directory, BaseLogger logger) {
        this.estimatedCapacity = estimatedCapacity;
        this.cutoverCapacity = cutoverCapacity;
        this.directory = directory;
        this.logger = logger;
    }

    @Override
    public SpillStreamFactory getInstance(BaseLogger logger) {
        return new MemoryThenFileSpillStreamFactory(this.estimatedCapacity, this.cutoverCapacity, this.directory, logger);
    }

    @Override
    public OutputStream getOutputStream(String cid) {
        this.cid = cid;
        ByteArrayOutputStream baos = null;
        baos = this.estimatedCapacity > 0 ? new ByteArrayOutputStream(this.estimatedCapacity) : new ByteArrayOutputStream();
        this.sos = new SwitchableOutputStream(baos, this.cutoverCapacity, this.directory, this.logger, this.cid);
        return this.sos;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.sos == null) {
            IllegalStateException ise = new IllegalStateException("Must call getOutputStream before getInputStream");
            IOException ioe = new IOException();
            ioe.initCause(ise);
            throw ioe;
        }
        OutputStream out = this.sos.getStream();
        this.sos.close();
        out.close();
        if (out instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return bais;
        }
        if (out instanceof FileOutputStream) {
            InputStream fis;
            File theFile = this.sos.getFile();
            try {
                fis = MemoryThenFileSpillStreamFactory.openPrivilegedFileInputStream(theFile);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            if (this.logger.isDetailTraceEnabled()) {
                long fileSize = theFile.length();
                this.logger.traceDetail("iPART spill OPNR CID=" + this.cid + "; " + theFile.getAbsolutePath() + "; available bytes " + fileSize);
            }
            return new DeleteMeFileInputStream(fis, theFile, this.logger, this.cid);
        }
        IllegalStateException ise = new IllegalStateException(out.getClass().getName());
        IOException ioe = new IOException();
        ioe.initCause(ise);
        throw ioe;
    }

    private static final class SwitchableOutputStream
    extends FilterOutputStream {
        int count = 0;
        private final int maxCapacity;
        private final File directory;
        private File theFile = null;
        private final BaseLogger logger;
        private final String cid;

        public SwitchableOutputStream(OutputStream out, int maxCapacity, File directory, BaseLogger logger, String cid) {
            super(out);
            this.maxCapacity = maxCapacity;
            this.directory = directory;
            this.logger = logger;
            this.cid = cid;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
            this.checkCapacity();
            super.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.count += b.length;
            this.checkCapacity();
            super.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
            this.checkCapacity();
            super.write(b);
        }

        private OutputStream getStream() {
            return this.out;
        }

        private File getFile() {
            return this.theFile;
        }

        private void checkCapacity() throws IOException {
            if (this.out instanceof ByteArrayOutputStream && this.count > this.maxCapacity) {
                OutputStream theFos;
                this.theFile = this.directory != null ? File.createTempFile("spil", null, this.directory) : File.createTempFile("spil", null);
                if (this.logger.isDetailTraceEnabled()) {
                    this.logger.traceDetail("iPART spill MAKE CID=" + this.cid + "; " + this.theFile.getAbsolutePath());
                }
                this.theFile.deleteOnExit();
                try {
                    theFos = MemoryThenFileSpillStreamFactory.openPrivilegedFileOutputStream(this.theFile);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
                baos.writeTo(theFos);
                this.out = theFos;
            }
        }
    }

    private static final class DeleteMeFileInputStream
    extends FilterInputStream {
        private final File theFile;
        private final BaseLogger logger;
        private final String cid;

        private DeleteMeFileInputStream(InputStream in, File theFile, BaseLogger logger, String cid) {
            super(in);
            this.theFile = theFile;
            this.logger = logger;
            this.cid = cid;
        }

        @Override
        public void close() throws IOException {
            this.deleteMeInTheEnd(-1);
            super.close();
        }

        @Override
        public int read() throws IOException {
            return this.deleteMeInTheEnd(super.read());
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.deleteMeInTheEnd(super.read(b, off, len));
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.deleteMeInTheEnd(super.read(b));
        }

        private int deleteMeInTheEnd(int count) throws IOException {
            if (count < 0) {
                super.close();
                if (this.theFile.exists()) {
                    long fileSize = this.theFile.length();
                    boolean deleted = this.theFile.delete();
                    if (this.logger.isDetailTraceEnabled()) {
                        this.logger.traceDetail("iPART spill DELE CID=" + this.cid + "; " + this.theFile.getAbsolutePath() + "; size=" + fileSize + "; success? " + deleted);
                    }
                    if (!deleted) {
                        try {
                            FileOutputStream fos = new FileOutputStream(this.theFile, false);
                            fos.write(new byte[0]);
                            if (this.logger.isDetailTraceEnabled()) {
                                this.logger.traceDetail("iPART spill TRNC CID=" + this.cid + "; " + this.theFile.getAbsolutePath());
                            }
                        }
                        catch (Throwable t) {
                            this.logger.warn("MTOM Spill file deletion and truncation failed CID=" + this.cid + "; " + this.theFile.getAbsolutePath(), t);
                        }
                    }
                }
            }
            return count;
        }
    }
}

