/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.engine.ServerInputStream;
import com.filenet.apiimpl.engine.ServerOutputStream;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ObjectCloner {
    private ObjectCloner() {
    }

    public static Object deepCopy(Object oldObj) {
        try {
            return ObjectCloner.makeCopy(oldObj);
        }
        catch (IOException ioe) {
            throw new EngineRuntimeException(ioe, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
        catch (ClassNotFoundException cnf) {
            throw new EngineRuntimeException(cnf, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object makeCopy(Object oldObj) throws IOException, ClassNotFoundException {
        if (oldObj == null) {
            return null;
        }
        DelegateOutputStream oos = null;
        DelegateInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ServerOutputStream(bos);
            ((BinaryOutputStream)oos).putObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ServerInputStream(bin, ObjectCloner.checkForConnection(oldObj));
            Object object = ((BinaryInputStream)ois).getObject();
            return object;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (ois != null) {
                ois.close();
            }
        }
    }

    private static Connection checkForConnection(Object obj) {
        if (obj instanceof EngineObjectImpl) {
            return ((EngineObjectImpl)obj).getConnection();
        }
        if (obj instanceof PropertyImpl) {
            return ((PropertyImpl)obj).getConnection();
        }
        return null;
    }
}

