/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.BlockingPipe;
import com.filenet.apiimpl.util.BufferedBlock;
import com.filenet.apiimpl.util.DoAsideInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PipeAsideInputStream
extends DoAsideInputStream {
    private BlockingPipe[] pipes;
    private boolean atEnd = false;

    public PipeAsideInputStream(InputStream in, BlockingPipe[] outputPipes) {
        super(in);
        this.pipes = outputPipes;
    }

    @Override
    protected void processRead(byte[] buffer, int offset, int length) {
        BufferedBlock bb = BufferedBlock.FINAL_EMPTY_BLOCK;
        if (buffer != null) {
            byte[] data = new byte[length];
            System.arraycopy(buffer, offset, data, 0, length);
            bb = new BufferedBlock(data, length, false);
        }
        for (int i = 0; i < this.pipes.length; ++i) {
            this.pipes[i].send(bb);
        }
        this.atEnd = bb.lastBlock();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!this.atEnd) {
            Throwable excToThrow = null;
            for (int i = 0; i < this.pipes.length; ++i) {
                try {
                    this.pipes[i].abort();
                    continue;
                }
                catch (Throwable t) {
                    if (excToThrow != null) continue;
                    excToThrow = t;
                }
            }
            if (excToThrow != null) {
                if (excToThrow instanceof RuntimeException) {
                    throw (RuntimeException)excToThrow;
                }
                if (excToThrow instanceof IOException) {
                    throw (IOException)excToThrow;
                }
                throw new RuntimeException(excToThrow);
            }
        }
    }
}

