/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.io.IOException;
import java.io.InputStream;

public class SelfClosingInputStream
extends InputStream {
    protected InputStream is;

    public SelfClosingInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
    }

    @Override
    public synchronized int available() throws IOException {
        return this.is == null ? 0 : this.is.available();
    }

    @Override
    public synchronized int read() throws IOException {
        return this.is == null ? -1 : this.read(this.is.read());
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        return this.is == null ? -1 : this.read(this.is.read(b, off, len));
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.is == null ? -1 : this.read(this.is.read(b));
    }

    protected int read(int count) throws IOException {
        if (count == -1) {
            this.close();
        }
        return count;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        return this.is == null ? 0L : this.is.skip(n);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() {
    }
}

