/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import java.util.HashMap;

public class SessionContext {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(SessionContext.class, SubSystem.API);
    private static ThreadLocal tl = new ThreadLocal();
    private Connection connection;
    private HashMap cache = new HashMap();
    private HashMap valuesCache = new HashMap();

    public static SessionContext getSessionContext() {
        return (SessionContext)tl.get();
    }

    public static void setSessionContext(SessionContext sc) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(SessionContext.class.getSimpleName() + ".set " + sc);
        }
        tl.set(sc);
    }

    public static Connection getCurrentConnection() {
        if (tl.get() instanceof SessionContext) {
            return ((SessionContext)tl.get()).getConnection();
        }
        return null;
    }

    public static HashMap getCurrentCache() {
        if (tl.get() instanceof SessionContext) {
            return ((SessionContext)tl.get()).getCache();
        }
        return null;
    }

    public static HashMap getRuntimeValues() {
        if (tl.get() instanceof SessionContext) {
            return ((SessionContext)tl.get()).getValues();
        }
        return null;
    }

    public SessionContext(Connection conn) {
        this.connection = conn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private HashMap getCache() {
        return this.cache;
    }

    private HashMap getValues() {
        return this.valuesCache;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SessionContext.class.getSimpleName()).append("@0x").append(Integer.toHexString(System.identityHashCode(this))).append(':').append(this.connection);
        return sb.toString();
    }
}

