/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.util.XMLObjectSource;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XMLObjectReader
implements XMLReader,
PrivilegedExceptionAction {
    protected ContentHandler content;
    protected XMLObjectSource source;
    protected Map identities;
    protected AttributesImpl attributes;
    protected DateFormat dateFormat;
    protected static final String TYPE_ATTR = "type";
    protected static final String ID_ATTR = "rid";
    protected static final String REF_ATTR = "ref";
    protected static final String INTERNAL_CLASS_NAME_PREFIX = "com.filenet.";

    public XMLObjectReader() {
        this.init();
    }

    protected void init() {
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.content;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.content = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void parse(String systemId) {
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.source = (XMLObjectSource)input;
        this.identities = new IdentityHashMap();
        this.attributes = new AttributesImpl();
        try {
            AccessController.doPrivileged(this);
        }
        catch (Throwable e) {
            throw Exceptions.evaluate(e);
        }
        finally {
            this.source = null;
            this.identities = null;
            this.attributes = null;
            this.dateFormat = null;
        }
    }

    public Object run() throws Exception {
        this.content.startDocument();
        this.visitObject(this.source.getName(), this.source.getObject());
        this.content.endDocument();
        return null;
    }

    public void visitObject(String element, Object object) throws Exception {
        if (object == null) {
            this.visitNull(element);
        } else if (object instanceof Class) {
            this.visitClass(element, (Class)object);
        } else if (object instanceof URI) {
            this.visitURI(element, (URI)object);
        } else if (object instanceof String) {
            this.visitString(element, (String)object);
        } else if (object instanceof Boolean) {
            this.visitBooleanWrapper(element, (Boolean)object);
        } else if (object instanceof Character) {
            this.visitCharacterWrapper(element, (Character)object);
        } else if (object instanceof Number) {
            this.visitNumberWrapper(element, (Number)object);
        } else if (object instanceof Date) {
            this.visitDate(element, (Date)object);
        } else if (object instanceof Id) {
            this.visitId(element, (Id)object);
        } else if (object instanceof Throwable) {
            this.visitThrowable(element, (Throwable)object);
        } else {
            this.visitOther(element, object);
        }
    }

    public void visitOther(String element, Object object) throws Exception {
        Object id = this.identities.get(object);
        if (id == null) {
            this.visitInstance(element, object);
        } else {
            this.visitReference(element, object, id);
        }
    }

    public void visitReference(String element, Object object, Object id) throws Exception {
        this.addAttribute(REF_ATTR, id.toString());
        this.startElement(element);
        this.endElement(element);
    }

    public void visitInstance(String element, Object object) throws Exception {
        String id = String.valueOf(this.identities.size() + 1);
        this.identities.put(object, id);
        this.addAttribute(ID_ATTR, id);
        this.visitValue(element, object);
    }

    public void visitValue(String element, Object object) throws Exception {
        if (this.isInternalObject(object)) {
            this.visitInternalValue(element, object);
        } else {
            this.visitExternalValue(element, object);
        }
    }

    public void visitInternalValue(String element, Object object) throws Exception {
        this.visitFields(element, object);
    }

    public void visitExternalValue(String element, Object object) throws Exception {
        if (object.getClass().isArray()) {
            this.visitArray(element, object);
        } else if (object instanceof Collection) {
            this.visitCollection(element, (Collection)object);
        } else if (object instanceof Map) {
            this.visitMap(element, (Map)object);
        } else {
            this.visitExternalElement(element, object);
        }
    }

    public void visitExternalElement(String element, Object object) throws Exception {
        this.element(element, object);
    }

    public void visitArray(String element, Object object) throws Exception {
        if (object.getClass().getComponentType().isPrimitive()) {
            this.visitPrimitiveArray(element, object);
        } else {
            this.visitObjectArray(element, (Object[])object);
        }
    }

    public void visitPrimitiveArray(String element, Object object) throws Exception {
        Class<?> type = object.getClass().getComponentType();
        if (type == Boolean.TYPE) {
            this.visitBooleanArray(element, (boolean[])object);
        } else if (type == Character.TYPE) {
            this.visitCharArray(element, (char[])object);
        } else if (type == Byte.TYPE) {
            this.visitByteArray(element, (byte[])object);
        } else if (type == Short.TYPE) {
            this.visitShortArray(element, (short[])object);
        } else if (type == Integer.TYPE) {
            this.visitIntArray(element, (int[])object);
        } else if (type == Long.TYPE) {
            this.visitLongArray(element, (long[])object);
        } else if (type == Float.TYPE) {
            this.visitFloatArray(element, (float[])object);
        } else if (type == Double.TYPE) {
            this.visitDoubleArray(element, (double[])object);
        } else {
            throw new Error("type=" + type.getName());
        }
    }

    public void visitBooleanArray(String element, boolean[] array) throws Exception {
        this.startArray(element, array, array.length);
        if (array.length > 0) {
            StringBuffer buffer = new StringBuffer(array.length);
            for (int i = 0; i < array.length; ++i) {
                buffer.append(array[i] ? (char)'T' : 'F');
            }
            this.characters(buffer.toString());
        }
        this.endArray(element);
    }

    public void visitCharArray(String element, char[] array) throws Exception {
        this.startArray(element, array, array.length);
        this.characters(array);
        this.endArray(element);
    }

    public void visitByteArray(String element, byte[] array) throws Exception {
        this.startArray(element, array, array.length);
        if (array.length > 0) {
            StringBuffer buffer = new StringBuffer(this.size(array.length, 2L, -1L)).append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buffer.append(' ').append(array[i]);
            }
            this.characters(buffer.toString());
        }
        this.endArray(element);
    }

    public void visitShortArray(String element, short[] array) throws Exception {
        this.startArray(element, array, array.length);
        if (array.length > 0) {
            StringBuffer buffer = new StringBuffer(this.size(array.length, 2L, -1L)).append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buffer.append(' ').append(array[i]);
            }
            this.characters(buffer.toString());
        }
        this.endArray(element);
    }

    public void visitIntArray(String element, int[] array) throws Exception {
        this.startArray(element, array, array.length);
        if (array.length > 0) {
            StringBuffer buffer = new StringBuffer(this.size(array.length, 2L, -1L)).append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buffer.append(' ').append(array[i]);
            }
            this.characters(buffer.toString());
        }
        this.endArray(element);
    }

    public void visitLongArray(String element, long[] array) throws Exception {
        this.startArray(element, array, array.length);
        if (array.length > 0) {
            StringBuffer buffer = new StringBuffer(this.size(array.length, 2L, -1L)).append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buffer.append(' ').append(array[i]);
            }
            this.characters(buffer.toString());
        }
        this.endArray(element);
    }

    public void visitFloatArray(String element, float[] array) throws Exception {
        this.startArray(element, array, array.length);
        if (array.length > 0) {
            StringBuffer buffer = new StringBuffer(this.size(array.length, 4L, -1L)).append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buffer.append(' ').append(array[i]);
            }
            this.characters(buffer.toString());
        }
        this.endArray(element);
    }

    public void visitDoubleArray(String element, double[] array) throws Exception {
        this.startArray(element, array, array.length);
        if (array.length > 0) {
            StringBuffer buffer = new StringBuffer(this.size(array.length, 4L, -1L)).append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buffer.append(' ').append(array[i]);
            }
            this.characters(buffer.toString());
        }
        this.endArray(element);
    }

    public void visitObjectArray(String element, Object[] array) throws Exception {
        this.startArray(element, array, array.length);
        for (int i = 0; i < array.length; ++i) {
            this.visitObject("entry", array[i]);
        }
        this.endArray(element);
    }

    public void startArray(String element, Object array, int length) throws Exception {
        this.startArray(element, array, length, false);
    }

    public void startArray(String element, Object array, int length, boolean truncated) throws Exception {
        this.addAttribute("length", String.valueOf(length));
        if (truncated) {
            this.addAttribute("truncated", "true");
        }
        this.startElement(element, array);
    }

    public void endArray(String element) throws Exception {
        this.endElement(element);
    }

    public void visitCollection(String element, Collection collection) throws Exception {
        this.addAttribute("size", String.valueOf(collection.size()));
        this.startElement(element, collection);
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.visitObject("entry", i.next());
        }
        this.endElement(element);
    }

    public void visitMap(String element, Map map) throws Exception {
        this.addAttribute("size", String.valueOf(map.size()));
        this.startElement(element, map);
        for (Map.Entry entry : map.entrySet()) {
            this.startElement("entry");
            this.visitObject("key", entry.getKey());
            this.visitObject("value", entry.getValue());
            this.endElement("entry");
        }
        this.endElement(element);
    }

    public void visitFields(String element, Object object) throws Exception {
        this.startElement(element, object);
        this.visitFields(object, object.getClass());
        this.endElement(element);
    }

    public void visitFields(Object object, Class type) throws Exception {
        if (type == null || type == Object.class) {
            return;
        }
        this.visitFields(object, type.getSuperclass());
        Field[] fields = type.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            this.visitField(object, field);
        }
    }

    public void visitField(Object object, Field field) throws Exception {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            this.visitPrimitiveField(object, field);
        } else {
            this.visitObjectField(object, field);
        }
    }

    public void visitPrimitiveField(Object object, Field field) throws Exception {
        Class<?> type = field.getType();
        String name = field.getName();
        if (type == Boolean.TYPE) {
            this.visitBoolean(name, field.getBoolean(object));
        } else if (type == Character.TYPE) {
            this.visitChar(name, field.getChar(object));
        } else if (type == Byte.TYPE) {
            this.visitByte(name, field.getByte(object));
        } else if (type == Short.TYPE) {
            this.visitShort(name, field.getShort(object));
        } else if (type == Integer.TYPE) {
            this.visitInt(name, field.getInt(object));
        } else if (type == Long.TYPE) {
            this.visitLong(name, field.getLong(object));
        } else if (type == Float.TYPE) {
            this.visitFloat(name, field.getFloat(object));
        } else if (type == Double.TYPE) {
            this.visitDouble(name, field.getDouble(object));
        } else {
            throw new Error("type=" + type.getName());
        }
    }

    public void visitObjectField(Object object, Field field) throws Exception {
        this.visitObject(field.getName(), field.get(object));
    }

    public void visitNull(String element) throws Exception {
        this.addAttribute("null", "true");
        this.startElement(element);
        this.endElement(element);
    }

    public void visitClass(String element, Class object) throws Exception {
        this.element(element, (Object)object.getName(), object.getClass());
    }

    public void visitURI(String element, URI object) throws Exception {
        this.element(element, object);
    }

    public void visitString(String element, String object) throws Exception {
        this.element(element, object);
    }

    public void visitBooleanWrapper(String element, Boolean object) throws Exception {
        this.element(element, object);
    }

    public void visitCharacterWrapper(String element, Character object) throws Exception {
        this.element(element, object);
    }

    public void visitNumberWrapper(String element, Number object) throws Exception {
        this.element(element, object);
    }

    public void visitBoolean(String element, boolean value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Boolean.TYPE);
    }

    public void visitChar(String element, char value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Character.TYPE);
    }

    public void visitByte(String element, byte value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Byte.TYPE);
    }

    public void visitShort(String element, short value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Short.TYPE);
    }

    public void visitInt(String element, int value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Integer.TYPE);
    }

    public void visitLong(String element, long value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Long.TYPE);
    }

    public void visitFloat(String element, float value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Float.TYPE);
    }

    public void visitDouble(String element, double value) throws Exception {
        this.element(element, (Object)String.valueOf(value), Double.TYPE);
    }

    public void visitDate(String element, Date value) throws Exception {
        this.element(element, (Object)this.formatDate(value), value.getClass());
    }

    public String formatDate(Date value) throws Exception {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return this.dateFormat.format(value);
    }

    public void visitId(String element, Id value) throws Exception {
        this.element(element, (Object)String.valueOf(value), value.getClass());
    }

    public void visitThrowable(String element, Throwable value) throws Exception {
        this.element(element, (Object)this.printStackTrace(value), value.getClass());
    }

    public String printStackTrace(Throwable value) {
        StringWriter writer = new StringWriter(8192);
        StringBuffer buffer = writer.getBuffer().append('\n');
        Exceptions.printStackTrace(value, writer, "\n", false);
        return buffer.toString();
    }

    public void element(String name, Object content) throws Exception {
        this.element(name, content, content.getClass());
    }

    public void element(String name, Object content, Class type) throws Exception {
        this.element(name, content, type.getName());
    }

    public void element(String name, Object content, String type) throws Exception {
        this.startElement(name, type);
        this.characters(content.toString());
        this.endElement(name);
    }

    public void startElement(String name, Object value) throws Exception {
        this.startElement(name, this.getObjectType(value));
    }

    public void startElement(String name, Class type) throws Exception {
        this.startElement(name, this.getTypeName(type));
    }

    public void startElement(String name, String type) throws Exception {
        this.addType(type);
        this.startElement(name);
    }

    public void startElement(String name) throws Exception {
        this.sortAttributes();
        this.content.startElement(null, name, name, this.attributes);
        this.attributes.clear();
    }

    protected void sortAttributes() {
        this.moveAttribute(this.attributes.getIndex(TYPE_ATTR), 0);
        this.moveAttribute(this.attributes.getIndex(ID_ATTR), this.attributes.getLength() - 1);
    }

    protected void moveAttribute(int current, int target) {
        if (current == -1 || current == target) {
            return;
        }
        int length = this.attributes.getLength();
        String name = this.attributes.getQName(current);
        String value = this.attributes.getValue(current);
        if (current < target) {
            for (int i = current + 1; i <= target; ++i) {
                this.attributes.setQName(i - 1, this.attributes.getQName(i));
                this.attributes.setValue(i - 1, this.attributes.getValue(i));
            }
        } else {
            for (int i = current - 1; i >= target; --i) {
                this.attributes.setQName(i + 1, this.attributes.getQName(i));
                this.attributes.setValue(i + 1, this.attributes.getValue(i));
            }
        }
        this.attributes.setQName(target, name);
        this.attributes.setValue(target, value);
    }

    public void endElement(String name) throws Exception {
        this.content.endElement(null, name, name);
    }

    public void characters(String value) throws Exception {
        this.characters(value.toCharArray());
    }

    public void characters(char[] value) throws Exception {
        if (value.length > 0) {
            this.content.characters(value, 0, value.length);
        }
    }

    public void addAttribute(String name, String value) throws Exception {
        if (value != null) {
            this.attributes.addAttribute(null, null, name, null, value);
        }
    }

    public void addType(String name) throws Exception {
        if (name != null) {
            this.addAttribute(TYPE_ATTR, name);
        }
    }

    public Class getObjectType(Object value) throws Exception {
        return value == null ? null : value.getClass();
    }

    public String getTypeName(Class type) throws Exception {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            return this.getArrayType(type);
        }
        return type.getName();
    }

    public String getArrayType(Class type) {
        StringBuffer buffer = new StringBuffer(64);
        while (type.isArray()) {
            buffer.append("[]");
            type = type.getComponentType();
        }
        buffer.insert(0, type.getName());
        return buffer.toString();
    }

    public boolean isInternalObject(Object value) {
        return this.isInternalType(value.getClass());
    }

    public boolean isInternalType(Class type) {
        return this.isInternalTypeName(type.getName());
    }

    public boolean isInternalTypeName(String type) {
        return type.startsWith(INTERNAL_CLASS_NAME_PREFIX);
    }

    public int size(long base, long multiple, long additional) {
        long size = base * multiple + additional;
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        return (int)size;
    }
}

