/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.ContentElementURLDataItems;
import com.filenet.apiimpl.util.classloader.ContentElementURLStreamHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;

final class ContentElementURLutil {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ContentElementURLutil.class, SubSystem.CodeModule);
    private static final String KV_PAIR_SEPARATOR = "\n";
    private static final String OBJECT_STORE_IDENTITY_KEY = "os";
    private static final String CLASS_IDENTITY_KEY = "class";
    private static final String OBJECT_IDENTITY_KEY = "object";
    private static final String ELEMENT_SEQUENCE_NUMBER_KEY = "eltseqnum";
    private static final String ELEMENT_ORDINAL_NUMBER_KEY = "eltnum";
    private static final String SUBELEMENT_FRAGMENT_KEY = "subelt";
    private static final String[] CLASS_TYPES = new String[]{"application/java", "application/java-byte-code", "application/x-java-class"};
    private static final String[] JARZIP_TYPES = new String[]{"application/java-archive", "application/x-compressed", "application/x-zip-compressed", "application/zip", "multipart/x-zip"};

    ContentElementURLutil() {
    }

    static final URL makeContentElementURL(Connection connection, String objectStoreIdentity, String classIdentity, String objectIdentity, int eltNum, int eltSeqNum, String subElt) {
        URI completeURI;
        URI connURI;
        String connURL = connection.getURI();
        try {
            connURI = new URI(connURL);
        }
        catch (URISyntaxException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        String queryPart = ContentElementURLutil.buildQueryPart(objectStoreIdentity, classIdentity, objectIdentity, eltNum, eltSeqNum, subElt);
        try {
            completeURI = new URI(connURI.getScheme(), connURI.getUserInfo(), connURI.getHost(), connURI.getPort(), connURI.getPath(), queryPart, null);
        }
        catch (URISyntaxException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        ContentElementURLStreamHandler streamHandler = new ContentElementURLStreamHandler();
        try {
            URL ceURL = new URL(null, completeURI.toString(), streamHandler);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ContentElementURLutil.makeContentElementURL() => " + ceURL);
            }
            return ceURL;
        }
        catch (MalformedURLException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    private static String buildQueryPart(String objectStoreIdentity, String classIdentity, String objectIdentity, int eltNum, int eltSeqNum, String subElt) {
        StringBuilder qpBuf = new StringBuilder(150);
        boolean needSep = false;
        if (objectStoreIdentity != null) {
            qpBuf.append(needSep ? KV_PAIR_SEPARATOR : "").append(OBJECT_STORE_IDENTITY_KEY).append('=').append(objectStoreIdentity);
            needSep = true;
        }
        if (classIdentity != null) {
            qpBuf.append(needSep ? KV_PAIR_SEPARATOR : "").append(CLASS_IDENTITY_KEY).append('=').append(classIdentity);
            needSep = true;
        }
        if (objectIdentity != null) {
            qpBuf.append(needSep ? KV_PAIR_SEPARATOR : "").append(OBJECT_IDENTITY_KEY).append('=').append(objectIdentity);
            needSep = true;
        }
        if (eltNum >= 0) {
            qpBuf.append(needSep ? KV_PAIR_SEPARATOR : "").append(ELEMENT_ORDINAL_NUMBER_KEY).append('=').append(eltNum);
            needSep = true;
        }
        if (eltSeqNum >= 0) {
            qpBuf.append(needSep ? KV_PAIR_SEPARATOR : "").append(ELEMENT_SEQUENCE_NUMBER_KEY).append('=').append(eltSeqNum);
            needSep = true;
        }
        if (subElt != null) {
            qpBuf.append(needSep ? KV_PAIR_SEPARATOR : "").append(SUBELEMENT_FRAGMENT_KEY).append('=').append(subElt);
            needSep = true;
        }
        return qpBuf.toString();
    }

    static final ContentElementURLDataItems parseQueryPart(String queryPart) {
        if (queryPart == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] kvpairs = queryPart.split(KV_PAIR_SEPARATOR);
        for (int ii = 0; ii < kvpairs.length; ++ii) {
            String kvpair = kvpairs[ii];
            int firstEquals = kvpair.indexOf(61);
            if (firstEquals == 0) {
                MalformedURLException mue = new MalformedURLException(queryPart);
                throw new EngineRuntimeException(mue, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            if (firstEquals < 0) {
                map.put(kvpair, null);
                continue;
            }
            String key = kvpair.substring(0, firstEquals);
            String value = kvpair.substring(firstEquals + 1);
            map.put(key, value);
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentElementURLutil.parseQueryPart(" + queryPart + ") => " + map);
        }
        ContentElementURLDataItems u = new ContentElementURLDataItems();
        u.setQueryPartKVs(map);
        u.setClassIdentity((String)map.get(CLASS_IDENTITY_KEY));
        String eltNumString = (String)map.get(ELEMENT_ORDINAL_NUMBER_KEY);
        u.setEltNum(eltNumString == null ? -1 : Integer.parseInt(eltNumString));
        String eltSeqNumString = (String)map.get(ELEMENT_SEQUENCE_NUMBER_KEY);
        u.setEltSeqNum(eltSeqNumString == null ? -1 : Integer.parseInt(eltSeqNumString));
        u.setObjectIdentity((String)map.get(OBJECT_IDENTITY_KEY));
        u.setObjectStoreIdentity((String)map.get(OBJECT_STORE_IDENTITY_KEY));
        u.setSubElt((String)map.get(SUBELEMENT_FRAGMENT_KEY));
        return u;
    }

    static final boolean isClassType(String type) {
        boolean isIt = false;
        if (type != null) {
            for (int ii = 0; ii < CLASS_TYPES.length; ++ii) {
                String someType = CLASS_TYPES[ii];
                if (!type.equalsIgnoreCase(someType)) continue;
                isIt = true;
                break;
            }
        }
        return isIt;
    }

    static final boolean isJarZipType(String type) {
        boolean isIt = false;
        if (type != null) {
            for (int ii = 0; ii < JARZIP_TYPES.length; ++ii) {
                String someType = JARZIP_TYPES[ii];
                if (!type.equalsIgnoreCase(someType)) continue;
                isIt = true;
                break;
            }
        }
        return isIt;
    }
}

