/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CRCLConfig;
import com.filenet.apiimpl.util.classloader.CRCLHelper;
import com.filenet.apiimpl.util.classloader.DummyClassLoader;
import com.filenet.apiimpl.util.classloader.DummyEnumeration;
import com.filenet.apiimpl.util.classloader.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.Attributes;

public class CrossReleaseClassLoader
extends URLClassLoader {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(CRCLHelper.class, SubSystem.API);
    private static final ClassLoader VISIBLE_API_CLASSLOADER = CRCLHelper.getVisibleApiClassloader();
    private final URL jarFileUrl;
    private static final String CRCL_PACKAGE = Util.getPackageName(CrossReleaseClassLoader.class.getName());
    private static final String CRCL_PREFIX_1 = CRCL_PACKAGE + ".CRCL";
    private static final String CRCL_PREFIX_2 = CRCL_PACKAGE + ".CrossRelease";
    private static final Set<String> doLoadPackagesClasses = new TreeSet<String>();
    private static final Set<String> noLoadPackagesClasses = new TreeSet<String>();
    private final String toStringValue;
    private static final ThreadLocal<Boolean> isTCCLish;
    private static final ThreadLocal<ClassLoader> tcclParent;

    CrossReleaseClassLoader(URL url) {
        super(new URL[]{url}, (ClassLoader)DummyClassLoader.INSTANCE);
        this.jarFileUrl = url;
        this.toStringValue = this.init(url);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: for JAR " + url + ", creating D classloader " + this);
        }
    }

    private CrossReleaseClassLoader(CrossReleaseClassLoader crcl, ClassLoader parent) {
        super(new URL[]{crcl.jarFileUrl}, parent);
        this.jarFileUrl = crcl.jarFileUrl;
        this.toStringValue = this.init(this.jarFileUrl);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: for JAR " + this.jarFileUrl + ", creating P classloader " + this);
        }
    }

    static TCCLishCRCL getTCCLishCRCL(CrossReleaseClassLoader crcl, ClassLoader parent) {
        return new TCCLishCRCL(crcl, parent);
    }

    private String init(URL url) {
        String specVersion = "?";
        String implVersion = "?";
        if (logger.isDetailTraceEnabled()) {
            String jarJarUrlString = Util.jarPathToUrlString(url.getPath());
            JarURLConnection juc = null;
            try {
                URL jarJarURL = new URL(jarJarUrlString);
                juc = (JarURLConnection)jarJarURL.openConnection();
                Attributes mainAttributes = juc.getMainAttributes();
                logger.traceDetail("CRCL: JAR manifest main attributes " + mainAttributes.entrySet());
                specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            catch (IOException e) {
                logger.traceDetail("CRCL: couldn't get JAR manifest for " + jarJarUrlString + "; " + e.getMessage());
            }
        }
        boolean hasDummyParent = this.getParent() instanceof DummyClassLoader;
        String ts = this.getClass().getSimpleName() + "@0x" + Integer.toHexString(System.identityHashCode(this)) + (hasDummyParent ? "" : "^") + "{" + url + "|" + specVersion + "|" + implVersion + "}";
        return ts;
    }

    private static boolean doCrclLoadTheClass(String className) {
        if (className.startsWith(CRCL_PREFIX_1)) {
            return false;
        }
        if (className.startsWith(CRCL_PREFIX_2)) {
            return false;
        }
        String candidate = className = className.replace('$', '.');
        while (true) {
            if (doLoadPackagesClasses.contains(candidate)) {
                return true;
            }
            if (noLoadPackagesClasses.contains(candidate)) {
                return false;
            }
            String prefix = Util.getPackageName(candidate);
            if (prefix == null || prefix.length() == 0 || prefix == candidate) break;
            candidate = prefix;
        }
        return false;
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        ClassLoader tccl = tcclParent.get();
        if (!CrossReleaseClassLoader.doCrclLoadTheClass(className)) {
            if (tccl != null && isTCCLish.get().booleanValue()) {
                if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CRCL: TCCL  loading " + className + " res=" + resolveClass);
                }
                return tccl.loadClass(className);
            }
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: VISIB loading " + className + " res=" + resolveClass);
            }
            return VISIBLE_API_CLASSLOADER.loadClass(className);
        }
        try {
            Class<?> crclClass = this.findLoadedClass(className);
            if (crclClass != null) {
                if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CRCL: CRCL  already " + className + " res=" + resolveClass + " " + this);
                }
            } else {
                crclClass = super.loadClass(className, resolveClass);
                if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CRCL: CRCL  loading " + className + " res=" + resolveClass + " " + this);
                }
            }
            return crclClass;
        }
        catch (ClassNotFoundException e) {
            if (tccl != null && isTCCLish.get().booleanValue()) {
                if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CRCL: TCCl  loading " + className + " res=" + resolveClass);
                }
                return tccl.loadClass(className);
            }
            if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                logger.traceDetail("CRCL: VISIb loading " + className + " res=" + resolveClass);
            }
            return VISIBLE_API_CLASSLOADER.loadClass(className);
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: try   loading " + className);
        }
        return this.loadClass(className, false);
    }

    private static boolean avoidItResource(String name) {
        return false;
    }

    @Override
    public URL findResource(String resName) {
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: findR '" + resName + "' " + this);
        }
        if (CrossReleaseClassLoader.avoidItResource(resName)) {
            return null;
        }
        return super.findResource(resName);
    }

    @Override
    public Enumeration<URL> findResources(String resName) throws IOException {
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: findRs '" + resName + "' " + this);
        }
        if (CrossReleaseClassLoader.avoidItResource(resName)) {
            return DummyEnumeration.EMPTY;
        }
        return super.findResources(resName);
    }

    @Override
    public URL getResource(String resName) {
        URL resource;
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: getR '" + resName + "' " + this);
        }
        if (!CrossReleaseClassLoader.avoidItResource(resName) && (resource = super.getResource(resName)) != null) {
            return resource;
        }
        ClassLoader parent = this.getParent();
        ClassLoader tccl = tcclParent.get();
        if (tccl != null && isTCCLish.get().booleanValue()) {
            return tccl.getResource(resName);
        }
        if (parent instanceof DummyClassLoader) {
            return VISIBLE_API_CLASSLOADER.getResource(resName);
        }
        if (parent == null) {
            return ClassLoader.getSystemResource(resName);
        }
        return parent.getResource(resName);
    }

    @Override
    public Enumeration<URL> getResources(String resName) throws IOException {
        URL url;
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: getRs '" + resName + "' " + this);
        }
        Enumeration local = CrossReleaseClassLoader.avoidItResource(resName) ? DummyEnumeration.EMPTY : super.getResources(resName);
        ClassLoader parent = this.getParent();
        ClassLoader tccl = tcclParent.get();
        Enumeration<URL> upper = tccl != null && isTCCLish.get() != false ? tccl.getResources(resName) : (parent instanceof DummyClassLoader ? VISIBLE_API_CLASSLOADER.getResources(resName) : (parent == null ? ClassLoader.getSystemResources(resName) : parent.getResources(resName)));
        Vector<URL> urls = new Vector<URL>();
        HashSet<URL> uniquifier = new HashSet<URL>();
        while (local.hasMoreElements()) {
            url = (URL)local.nextElement();
            if (uniquifier.contains(url)) continue;
            uniquifier.add(url);
            urls.add(url);
        }
        while (upper.hasMoreElements()) {
            url = upper.nextElement();
            if (uniquifier.contains(url)) continue;
            uniquifier.add(url);
            urls.add(url);
        }
        return urls.elements();
    }

    @Override
    public InputStream getResourceAsStream(String resName) {
        InputStream resourceAsStream;
        if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
            logger.traceDetail("CRCL: getRstr '" + resName + "' " + this);
        }
        if (!CrossReleaseClassLoader.avoidItResource(resName) && (resourceAsStream = super.getResourceAsStream(resName)) != null) {
            return resourceAsStream;
        }
        ClassLoader parent = this.getParent();
        ClassLoader tccl = tcclParent.get();
        if (tccl != null && isTCCLish.get().booleanValue()) {
            return tccl.getResourceAsStream(resName);
        }
        if (parent instanceof DummyClassLoader) {
            return VISIBLE_API_CLASSLOADER.getResourceAsStream(resName);
        }
        if (parent == null) {
            return ClassLoader.getSystemResourceAsStream(resName);
        }
        return parent.getResourceAsStream(resName);
    }

    public String toString() {
        return this.toStringValue;
    }

    static {
        String commaList = ConfigValueLookup.getValue("com.filenet.api.crcl.doload", ConfigValueLookup.CRCL_DO_LOAD_DEFAULT);
        if ((commaList = commaList.trim()).charAt(0) == '+') {
            commaList = ConfigValueLookup.CRCL_DO_LOAD_DEFAULT + "," + commaList.substring(1);
        }
        Util.parsePackageNamesToCollection(commaList, doLoadPackagesClasses);
        if (logger.isSummaryTraceEnabled()) {
            logger.traceSummary("CRCL    do-load packages/classes: " + doLoadPackagesClasses.size() + " " + doLoadPackagesClasses);
        }
        commaList = ConfigValueLookup.getValue("com.filenet.api.crcl.dontload", ConfigValueLookup.CRCL_DONT_LOAD_DEFAULT);
        if ((commaList = commaList.trim()).charAt(0) == '+') {
            commaList = ConfigValueLookup.CRCL_DONT_LOAD_DEFAULT + "," + commaList.substring(1);
        }
        Util.parsePackageNamesToCollection(commaList, noLoadPackagesClasses);
        if (logger.isSummaryTraceEnabled()) {
            logger.traceSummary("CRCL don't-load packages/classes: " + noLoadPackagesClasses.size() + " " + noLoadPackagesClasses);
        }
        isTCCLish = new ThreadLocal();
        tcclParent = new ThreadLocal();
    }

    static class TCCLishCRCL
    extends ClassLoader {
        private final CrossReleaseClassLoader crcl;
        private final ClassLoader tcclParnt;

        TCCLishCRCL(CrossReleaseClassLoader crcl, ClassLoader tcclParent) {
            this.crcl = crcl;
            this.tcclParnt = tcclParent;
        }

        ClassLoader getTCCLparent() {
            return this.tcclParnt;
        }

        private void setTCCLish(boolean isTCCLish) {
            isTCCLish.set(isTCCLish);
            if (isTCCLish) {
                tcclParent.set(this.tcclParnt);
                if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CRCL:tccl ON  " + this + "; TCCL parent " + this.tcclParnt);
                }
            } else {
                tcclParent.set(null);
                if (CRCLConfig.CRCL_CHATTY_LOGGING && logger.isDetailTraceEnabled()) {
                    logger.traceDetail("CRCL:tccl OFF " + this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
            try {
                this.setTCCLish(true);
                Class<?> clazz = this.crcl.loadClass(className, resolveClass);
                return clazz;
            }
            finally {
                this.setTCCLish(false);
            }
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            try {
                this.setTCCLish(true);
                Class<?> clazz = this.crcl.loadClass(className);
                return clazz;
            }
            finally {
                this.setTCCLish(false);
            }
        }

        @Override
        public URL findResource(String resName) {
            try {
                this.setTCCLish(true);
                URL uRL = this.crcl.findResource(resName);
                return uRL;
            }
            finally {
                this.setTCCLish(false);
            }
        }

        @Override
        public Enumeration<URL> findResources(String resName) throws IOException {
            try {
                this.setTCCLish(true);
                Enumeration<URL> enumeration = this.crcl.findResources(resName);
                return enumeration;
            }
            finally {
                this.setTCCLish(false);
            }
        }

        @Override
        public URL getResource(String resName) {
            try {
                this.setTCCLish(true);
                URL uRL = this.crcl.getResource(resName);
                return uRL;
            }
            finally {
                this.setTCCLish(false);
            }
        }

        @Override
        public Enumeration<URL> getResources(String resName) throws IOException {
            try {
                this.setTCCLish(true);
                Enumeration<URL> enumeration = this.crcl.getResources(resName);
                return enumeration;
            }
            finally {
                this.setTCCLish(false);
            }
        }

        @Override
        public InputStream getResourceAsStream(String resName) {
            try {
                this.setTCCLish(true);
                InputStream inputStream = this.crcl.getResourceAsStream(resName);
                return inputStream;
            }
            finally {
                this.setTCCLish(false);
            }
        }

        public String toString() {
            return "TCCL@0x" + Integer.toHexString(System.identityHashCode(this)) + "{" + this.crcl.toString() + "}";
        }
    }
}

