/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.json;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;

class Tokenizer {
    private PushbackReader rdr;
    private static HashMap<Integer, TokenType> mapSingleCharTokens = new HashMap();

    Tokenizer(Reader inRdr) throws IOException {
        this.rdr = new PushbackReader(inRdr);
    }

    Token nextToken() throws IOException {
        int c = this.skipWhitespace();
        if (c == -1) {
            throw new RuntimeException("Unexpected EOF while parsing JSON");
        }
        Token tok = null;
        TokenType tt = this.getSingleCharacterTokenType(c);
        if (tt != null) {
            tok = new Token(tt, null);
        } else if (c == 34) {
            StringBuilder sb = new StringBuilder();
            while ((c = this.rdr.read()) != 34) {
                if (c == 92) {
                    c = this.rdr.read();
                    if (c == 92 || c == 34 || c == 47) {
                        sb.append((char)c);
                        continue;
                    }
                    if (c == 98) {
                        sb.append("\b");
                        continue;
                    }
                    if (c == 102) {
                        sb.append("\f");
                        continue;
                    }
                    if (c == 110) {
                        sb.append("\n");
                        continue;
                    }
                    if (c == 114) {
                        sb.append("\r");
                        continue;
                    }
                    if (c == 116) {
                        sb.append("\t");
                        continue;
                    }
                    if (c != 117) continue;
                    StringBuilder ubuf = new StringBuilder();
                    for (int iu = 0; iu < 4; ++iu) {
                        ubuf.append((char)this.rdr.read());
                    }
                    char u = (char)Integer.parseInt(ubuf.toString(), 16);
                    sb.append(u);
                    continue;
                }
                sb.append((char)c);
            }
            tok = new Token(TokenType.QUOTED_STRING, sb.toString());
        } else {
            StringBuilder sb;
            block15: {
                sb = new StringBuilder();
                do {
                    sb.append((char)c);
                    c = this.rdr.read();
                    if (Character.isWhitespace(c)) break block15;
                } while (!this.isTokenCharacter(c));
                this.rdr.unread(c);
            }
            tok = new Token(TokenType.UNQUOTED_STRING, sb.toString());
        }
        return tok;
    }

    private int skipWhitespace() throws IOException {
        int c;
        do {
            if ((c = this.rdr.read()) != -1) continue;
            return c;
        } while (Character.isWhitespace(c));
        return c;
    }

    private boolean isTokenCharacter(int c) {
        return this.getSingleCharacterTokenType(c) != null;
    }

    private TokenType getSingleCharacterTokenType(int c) {
        return mapSingleCharTokens.get(c);
    }

    static {
        mapSingleCharTokens.put(123, TokenType.OPEN_BRACE);
        mapSingleCharTokens.put(125, TokenType.CLOSE_BRACE);
        mapSingleCharTokens.put(58, TokenType.COLON);
        mapSingleCharTokens.put(91, TokenType.OPEN_SQUARE);
        mapSingleCharTokens.put(93, TokenType.CLOSE_SQUARE);
        mapSingleCharTokens.put(44, TokenType.COMMA);
    }

    static class Token {
        private TokenType tt;
        private String strVal;

        Token(TokenType tt, String strVal) {
            this.tt = tt;
            this.strVal = strVal;
        }

        TokenType getTokenType() {
            return this.tt;
        }

        String getValue() {
            return this.strVal;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append(this.tt.toString());
            if (this.strVal != null) {
                sb.append(":").append(this.strVal);
            }
            sb.append("}");
            return sb.toString();
        }
    }

    static enum TokenType {
        OPEN_BRACE,
        CLOSE_BRACE,
        COLON,
        OPEN_SQUARE,
        CLOSE_SQUARE,
        COMMA,
        QUOTED_STRING,
        UNQUOTED_STRING;

    }
}

