/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.authentication.Credentials;
import com.filenet.api.authentication.OpenTokenCredentials;
import com.filenet.api.authentication.SubjectCredentials;
import com.filenet.api.authentication.UsernameCredentials;
import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.constants.Charsets;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.AuthToken;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SessionContext;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.ApiContext;
import com.filenet.apiimpl.wsi.ClientBinding;
import com.filenet.apiimpl.wsi.ClientInfo;
import com.filenet.apiimpl.wsi.Localization;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.ServiceSessionWsi;
import com.filenet.apiimpl.wsi.UsernameToken;
import com.filenet.apiimpl.wsi.WSICredential;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.Subject;

public abstract class ClientOperation {
    private final ServiceSessionWsi session;
    private final String operation;
    private final ConnectionImpl connection;
    private final ClientCallContext context;
    private final Request request;
    private Response response;
    private Throwable exception;
    private SessionContext savedSessionContext;
    private static ThreadLocal<WSICredential> overrideCredential = new ThreadLocal();
    private static final TransportLogger logger = TransportLogger.getLogger(ClientOperation.class, SubSystem.WSI);
    private static String DEFAULT_BUILD = ConfigValueLookup.getValue("BuildVersion", "unknown").trim();
    private static final String CUSTOM_CRED_CLASS = ConfigValueLookup.getValue("FileNet.WSI.custom.credential.class", "com.filenet.apiimpl.wsi.WSICredential");
    private static final String CUSTOM_USER_METHOD = ConfigValueLookup.getValue("FileNet.WSI.custom.credential.usermethod", "getUserName");
    private static final String CUSTOM_PASS_METHOD = ConfigValueLookup.getValue("FileNet.WSI.custom.credential.passwordmethod", "getPassword");
    private static final Class[] NO_PARAMS_TYPES;
    private static final Object[] NO_PARAMS;

    protected ClientOperation(ServiceSessionWsi session, String operation, ConnectionImpl connection, Request request, ClientCallContext context) {
        this.session = session;
        this.operation = operation;
        this.connection = connection;
        this.request = request;
        this.context = context;
    }

    protected abstract Response execute() throws Exception;

    public static void setThreadCredential(WSICredential credential) {
        overrideCredential.set(credential);
    }

    Response run() {
        EngineRuntimeException excep;
        this.init();
        try {
            this.start();
            this.response = this.execute();
        }
        catch (Throwable e) {
            this.error(e);
        }
        finally {
            excep = this.finish();
        }
        if (excep == null) {
            return this.response;
        }
        throw excep;
    }

    private void init() {
        this.savedSessionContext = SessionContext.getSessionContext();
        this.exception = null;
    }

    private void start() throws Exception {
        this.traceRequest();
        ClientOperation.setSessionContext(this.session, this.connection, this.request);
        this.setCallContext(this.session, this.connection, this.context);
    }

    private EngineRuntimeException finish() {
        SessionContext.setSessionContext(this.savedSessionContext);
        EngineRuntimeException excep = ClientOperation.evaluate(this.exception);
        this.traceResponse(excep);
        return excep;
    }

    protected void error(Throwable excep) {
        if (excep == null || this.exception == null) {
            this.exception = excep;
        }
    }

    private static EngineRuntimeException evaluate(Throwable e) {
        if (e == null) {
            return null;
        }
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof EngineRuntimeException)) continue;
            e = cause;
        }
        if (e instanceof EngineRuntimeException) {
            return (EngineRuntimeException)e;
        }
        if (e instanceof Error) {
            return new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return new EngineRuntimeException(e, ExceptionCode.E_EXCEPTION_RETRY, null);
    }

    private void traceRequest() throws Exception {
        if (!logger.isCallTraceEnabled()) {
            return;
        }
        if (this.request instanceof Message) {
            logger.traceRequest(this.context, this.operation, (Message)((Object)this.request));
        }
    }

    private void traceResponse(EngineRuntimeException excep) {
        if (excep != null) {
            logger.traceException(this.context, this.operation, excep, System.currentTimeMillis());
        } else if (this.response instanceof Message) {
            logger.traceResponse(this.context, this.operation, (Message)((Object)this.response), System.currentTimeMillis());
        }
    }

    private static void setSessionContext(ServiceSessionWsi session, Connection connection, Request request) {
        SessionContext.setSessionContext(new SessionContext(connection));
        ClientBinding binding = session.getBinding();
        ClientInfo.setBinding(binding.getType());
        ClientInfo.setVersion(binding.getVersion());
        ClientInfo.setRequest(request);
    }

    protected abstract void setCallContext(ServiceSessionWsi var1, ConnectionImpl var2, ClientCallContext var3);

    protected static void setCallContextHelper(Map<String, Object> contextData, ClientCallContext optionalCCC) {
        Security sec = ClientOperation.getSoapEnvelopeSecurity();
        Localization loc = ClientOperation.getSoapEnvelopeLocalization(optionalCCC);
        ApiContext ctx = ClientOperation.getSoapEnvelopeApiContext(optionalCCC);
        contextData.put("Security", sec);
        contextData.put("Localization", loc);
        contextData.put("ApiContext", ctx);
        contextData.put("WSDL_VERSION", SessionContext.getRuntimeValues().get("WSDL_VERSION"));
    }

    public static Localization getSoapEnvelopeLocalization(ClientCallContext optionalCCC) {
        Localization loc = new Localization();
        if (optionalCCC != null && optionalCCC.getParam("loc") instanceof String) {
            loc.Locale = (String)((Object)optionalCCC.getParam("loc"));
        } else {
            UserContext uc = UserContext.get();
            loc.Locale = uc.getLocale().getLanguage() + "-" + uc.getLocale().getCountry();
        }
        int tzOffset = TimeZone.getDefault().getOffset(System.currentTimeMillis());
        String sign = "+";
        if (tzOffset < 0) {
            sign = "-";
            tzOffset = -tzOffset;
        }
        DecimalFormat twoDigits = new DecimalFormat("00");
        loc.Timezone = sign + twoDigits.format(tzOffset / 3600000) + ":" + twoDigits.format(tzOffset % 3600000);
        return loc;
    }

    public static ApiContext getSoapEnvelopeApiContext(ClientCallContext optionalCCC) {
        ApiContext ctx = new ApiContext();
        ctx.type = "Java";
        if (optionalCCC != null) {
            ctx.version = optionalCCC.getClientVersion();
            ctx.build = (String)((Object)optionalCCC.getParam("clibuild"));
            ctx.threadId = (String)((Object)optionalCCC.getParam("ctid"));
        }
        if (ctx.version == null) {
            ctx.version = ClientCallContext.VERSION_DEFAULT;
        }
        if (ctx.threadId == null) {
            ctx.threadId = ApiContext.getClientThreadId();
        }
        if (ctx.build == null) {
            ctx.build = DEFAULT_BUILD;
        }
        return ctx;
    }

    public static Security getSoapEnvelopeSecurity() {
        WSICredential credential = ClientOperation.getCredential();
        Security sec = credential.getSecurityToken();
        return sec;
    }

    public static WSICredential getCredential() {
        WSICredential cred = overrideCredential.get();
        if (cred != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ClientOperation returns override credential " + cred);
            }
            return cred;
        }
        Credentials cr = Credentials.getCurrent();
        if (cr == null) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, null, ExceptionContext.SECURITY_NO_SECURITY_CONTEXT, null);
        }
        if (cr instanceof OpenTokenCredentials) {
            OpenTokenCredentials otc = (OpenTokenCredentials)cr;
            AuthToken authToken = new AuthToken();
            authToken.setTokenType(AuthToken.TokenType.OAUTH_TOKEN);
            authToken.setTokenName(UsernameToken.USER_NAME_OAUTH_TOKEN);
            authToken.setTokenValue(otc.getToken());
            authToken.setPrincipalName(otc.getUsername());
            authToken.setRealm(otc.getRealm());
            return authToken.getWsiCredential();
        }
        if (cr instanceof UsernameCredentials) {
            UsernameCredentials uc = (UsernameCredentials)cr;
            return new WSICredential(uc.getUsername(), uc.getPassword());
        }
        if (!(cr instanceof SubjectCredentials)) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, null, ExceptionContext.SECURITY_CREDENTIALS_TYPE_INVALID, new Object[]{cr.getClass().getSimpleName()});
        }
        Subject sub = ((SubjectCredentials)cr).getSubject();
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ClientOperation acting on Subject from UserContext");
        }
        Set<WSICredential> creds = null;
        try {
            creds = ClientOperation.cDoPrivilegedGetPrivateCredentials(sub);
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.SECURITY_INVALID_CREDENTIALS, null, ExceptionContext.SECURITY_CANNOT_RETRIEVE_CREDENTIALS, null);
        }
        if (creds == null || creds.isEmpty()) {
            try {
                creds = ClientOperation.cDoPrivilegedGetPrivateCustomCredentials(sub);
            }
            catch (Throwable t) {
                throw new EngineRuntimeException(t, ExceptionCode.SECURITY_INVALID_CREDENTIALS, null, ExceptionContext.SECURITY_CANNOT_RETRIEVE_CREDENTIALS, null);
            }
        }
        boolean autoDetectLTPA = ConfigValueLookup.getValueAsBoolean("FileNet.WSI.AutoDetectLTPAToken", false);
        if ((creds == null || creds.isEmpty()) && autoDetectLTPA) {
            String ltpaToken;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ClientOperation calling getLTPATokenFromSubject for " + J2EEUtil.getInstance().getPrincipalFromSubject(sub));
            }
            if ((ltpaToken = J2EEUtil.getInstance().getLTPATokenFromSubject(sub)) != null) {
                WSICredential ltpaCredential = new WSICredential(UsernameToken.USER_NAME_LTPA_TOKEN, ltpaToken);
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Using LTPA username <" + ClientOperation.getPrincipal(ltpaCredential) + "> from ambient context");
                }
                return ltpaCredential;
            }
        }
        boolean autoDetectAuthToken = ConfigValueLookup.getValueAsBoolean("com.filenet.authentication.wsi.AutoDetectAuthToken", false);
        if ((creds == null || creds.isEmpty()) && autoDetectAuthToken) {
            AuthToken authToken;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ClientOperation calling getAuthTokenFromSubject for " + J2EEUtil.getInstance().getPrincipalFromSubject(sub));
            }
            if ((authToken = J2EEUtil.getInstance().getAuthTokenFromSubject(sub)) != null) {
                WSICredential wsiCred = authToken.getWsiCredential();
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Using SSO Token username <" + ClientOperation.getPrincipal(wsiCred) + "> from ambient context");
                }
                return wsiCred;
            }
        }
        if (creds == null) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, (Object[])null, ExceptionContext.SECURITY_MISSING_CREDENTIALS, (Object[])null);
        }
        Iterator<WSICredential> iter = creds.iterator();
        if (iter == null || !iter.hasNext()) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, (Object[])null, ExceptionContext.SECURITY_MISSING_CREDENTIALS, (Object[])null);
        }
        WSICredential ret = iter.next();
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Using username <" + ClientOperation.getPrincipal(ret) + "> from UserContext");
        }
        return ret;
    }

    public static WSICredential getWSICredential(Subject sub) {
        Iterator<WSICredential> iter;
        Set<WSICredential> creds = null;
        try {
            creds = ClientOperation.cDoPrivilegedGetPrivateCredentials(sub);
        }
        catch (Throwable t) {
            logger.error("Unable to retrieve WSICredential", t);
            creds = null;
        }
        if (creds == null || creds.isEmpty()) {
            try {
                creds = ClientOperation.cDoPrivilegedGetPrivateCustomCredentials(sub);
            }
            catch (Throwable t) {
                logger.error("Unable to retrieve WSICredential", t);
                creds = null;
            }
        }
        WSICredential wsiCred = null;
        if (creds != null && (iter = creds.iterator()) != null && iter.hasNext()) {
            wsiCred = iter.next();
        }
        if (logger.isDebugEnabled()) {
            logger.traceDetail("getWSICredential(sub) returning credential for [" + ClientOperation.getPrincipal(wsiCred) + "]");
        }
        return wsiCred;
    }

    private static final Set<WSICredential> cDoPrivilegedGetPrivateCredentials(final Subject sub) throws Throwable {
        PrivilegedExceptionAction<Set<WSICredential>> peaPrivateCredsWSI = new PrivilegedExceptionAction<Set<WSICredential>>(){

            @Override
            public Set<WSICredential> run() {
                Set<WSICredential> priCredsWSI = sub.getPrivateCredentials(WSICredential.class);
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Set of private credentials for " + WSICredential.class.getSimpleName() + " has " + (priCredsWSI == null ? null : Integer.valueOf(priCredsWSI.size())) + " items");
                }
                return priCredsWSI;
            }
        };
        try {
            return AccessController.doPrivileged(peaPrivateCredsWSI);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    private static final Set<WSICredential> cDoPrivilegedGetPrivateCustomCredentials(final Subject sub) throws Throwable {
        PrivilegedExceptionAction<Set<WSICredential>> peaPrivateCredsCustom = new PrivilegedExceptionAction<Set<WSICredential>>(){

            @Override
            public Set<WSICredential> run() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail(" CUSTOM_CRED_CLASS   is   -  " + CUSTOM_CRED_CLASS);
                }
                if (CUSTOM_CRED_CLASS == null || CUSTOM_CRED_CLASS.length() == 0) {
                    return null;
                }
                HashSet<WSICredential> priCredsCustom = new HashSet<WSICredential>();
                Set<Object> allCreds = sub.getPrivateCredentials(Object.class);
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Set of all private credentials has " + (allCreds == null ? null : Integer.valueOf(allCreds.size())) + " items");
                }
                for (Object cred : allCreds) {
                    String thisPass;
                    Object thisPassObject;
                    String thisUser;
                    String thisCredClassName = cred.getClass().getName();
                    if (!thisCredClassName.equals(CUSTOM_CRED_CLASS)) continue;
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Found instance of custom private credential " + CUSTOM_CRED_CLASS + ": " + cred);
                    }
                    try {
                        Method thisUserMethod = cred.getClass().getMethod(CUSTOM_USER_METHOD, NO_PARAMS_TYPES);
                        Method thisPassMethod = cred.getClass().getMethod(CUSTOM_PASS_METHOD, NO_PARAMS_TYPES);
                        thisUser = (String)thisUserMethod.invoke(cred, NO_PARAMS);
                        thisPassObject = thisPassMethod.invoke(cred, NO_PARAMS);
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("Reflection on custom private credential yields username <" + thisUser + ">");
                        }
                    }
                    catch (Exception e1) {
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("Exception during reflection on custom private credential: " + e1);
                        }
                        return priCredsCustom;
                    }
                    if (thisPassObject instanceof String || thisPassObject == null) {
                        thisPass = (String)thisPassObject;
                    } else {
                        try {
                            thisPass = new String((byte[])thisPassObject, Charsets.CHARSET_UTF_8.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            thisPass = new String((byte[])thisPassObject);
                        }
                    }
                    WSICredential wsiCred = new WSICredential(thisUser, thisPass);
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Returning custom private credential as " + wsiCred);
                    }
                    priCredsCustom.add(wsiCred);
                    return priCredsCustom;
                }
                return priCredsCustom;
            }
        };
        try {
            return AccessController.doPrivileged(peaPrivateCredsCustom);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    private static String getPrincipal(WSICredential cred) {
        if (cred == null || cred.getSecurityToken() == null || cred.getSecurityToken().UsernameToken == null || cred.getSecurityToken().UsernameToken.Username == null) {
            return null;
        }
        return cred.getSecurityToken().UsernameToken.Username;
    }

    protected static int getConnectionTimeout(Connection conn) {
        Object rawValue = conn.getParameter(ConfigurationParameter.WSI_TRANSPORT_CONNECTION_TIMEOUT);
        if (rawValue == null) {
            rawValue = ConfigValueLookup.getValue("FileNet.WSI.TransportConnectionTimeout", null);
        }
        if (rawValue == null) {
            return ConfigValueLookup.getInt(ConfigurationParameter.WSI_TRANSPORT_CONNECTION_TIMEOUT, Integer.MAX_VALUE);
        }
        if (rawValue instanceof String) {
            return Integer.parseInt((String)rawValue);
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        return Integer.MAX_VALUE;
    }

    static {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ClientOperation looks for custom private credential class " + CUSTOM_CRED_CLASS + " with methods " + CUSTOM_USER_METHOD + " and " + CUSTOM_PASS_METHOD + " (ignored if class is null)");
        }
        NO_PARAMS_TYPES = new Class[0];
        NO_PARAMS = new Object[0];
    }
}

