/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.constants.Charsets;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.MultipartOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MtomOutputStream
extends MultipartOutputStream {
    private static final TransportLogger logger = TransportLogger.getLogger(MtomOutputStream.class, SubSystem.WSI);
    private final boolean needsMultipartFormat;
    private final String requestContentType;
    private String rootContentId = null;
    private byte[] mimeBoundary = null;
    private String contentType = "application/soap+xml";
    private static final byte[] CONTENT_TYPE_OCTET_STREAM_CRLF = Charsets.getBytes("Content-Type: application/octet-stream\r\n");
    private static final byte[] DASH_DASH = Charsets.getBytes("--");
    private static final byte[] CONTENT_TYPE_XOP_XML_CRLF = Charsets.getBytes("Content-Type: application/xop+xml; type=\"application/soap+xml\"; charset=UTF-8\r\n");
    private static final byte[] CONTENT_TRANSFER_ENCODING_BINARY_CRLF = Charsets.getBytes("Content-Transfer-Encoding: binary\r\n");
    private static final byte[] CRLF = Charsets.getBytes("\r\n");

    public MtomOutputStream(String uniquePiece, String contentIdZero, boolean needsMultipartFormat, String requestContentType) {
        super(null);
        this.needsMultipartFormat = needsMultipartFormat;
        this.requestContentType = requestContentType;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Request content type '" + this.requestContentType + "', Response multipart? " + this.needsMultipartFormat);
        }
        if (needsMultipartFormat) {
            this.computeMimeRelatedItems(uniquePiece, contentIdZero);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.needsMultipartFormat) {
            this.out.write(DASH_DASH);
            this.out.write(this.mimeBoundary);
            this.out.write(DASH_DASH);
            this.out.write(CRLF);
            this.out.write(CRLF);
        }
        this.out.close();
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    private void computeMimeRelatedItems(String uniquePiece, String contentIdZero) {
        this.rootContentId = "<" + contentIdZero + ">";
        String mimeBoundaryStr = "A-B--MIME-BOUNDARY--" + uniquePiece + "--Y-Z";
        try {
            this.mimeBoundary = mimeBoundaryStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        this.contentType = "multipart/related; boundary=" + mimeBoundaryStr + "; type=\"application/xop+xml\"; start-info=\"application/soap+xml\"; start=\"" + this.rootContentId + "\"";
    }

    @Override
    public void startRootPart() throws IOException {
        if (this.needsMultipartFormat) {
            this.out.write(DASH_DASH);
            this.out.write(this.mimeBoundary);
            this.out.write(CRLF);
            this.out.write(CONTENT_TRANSFER_ENCODING_BINARY_CRLF);
            this.out.write(CONTENT_TYPE_XOP_XML_CRLF);
            String cidHeader = "Content-ID: " + this.rootContentId;
            this.out.write(cidHeader.getBytes("UTF-8"));
            this.out.write(CRLF);
            this.out.write(CRLF);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Root part  header content-type: " + CONTENT_TYPE_XOP_XML_CRLF);
                logger.traceDetail("Root part  header content-id:   " + cidHeader);
            }
        } else if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Root part is the only part (ho headers)");
        }
    }

    @Override
    public void endRootPart(boolean attachmentsFollow) throws IOException {
        this.endAttachment(attachmentsFollow);
    }

    @Override
    public void startAttachment(String contentId) throws IOException {
        this.out.write(DASH_DASH);
        this.out.write(this.mimeBoundary);
        this.out.write(CRLF);
        this.out.write(CONTENT_TRANSFER_ENCODING_BINARY_CRLF);
        this.out.write(CONTENT_TYPE_OCTET_STREAM_CRLF);
        String partCidHeader = "Content-Id: <" + contentId + ">";
        this.out.write(partCidHeader.getBytes("UTF-8"));
        this.out.write(CRLF);
        this.out.write(CRLF);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Attachment header content-type: " + CONTENT_TYPE_OCTET_STREAM_CRLF);
            logger.traceDetail("Attachment header content-id:   " + partCidHeader);
        }
    }

    @Override
    public void endAttachment(boolean attachmentsFollow) throws IOException {
        this.out.write(CRLF);
    }

    @Override
    public String getRequestContentType() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Computed or deduced request content-type: " + this.contentType);
        }
        return this.contentType;
    }

    @Override
    public String getResponseContentType() {
        String ct = this.needsMultipartFormat ? this.contentType : (this.requestContentType == null || this.requestContentType.length() == 0 ? "application/soap+xml" : this.requestContentType);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Computed or deduced response content-type: " + ct);
        }
        return ct;
    }
}

