/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.serialization.TokenReader;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public final class TokenReaderJson
implements TokenReader {
    private static final TransportLogger logger = TransportLogger.getLogger(TokenReaderJson.class, SubSystem.WSI);
    final JsonParser sR;
    final String opName;
    private static final int UNKNOWN = 0;
    private static final int START_ELEMENT = 1;
    private static final int END_ELEMENT = 2;
    private static final int CONTENT = 3;
    private EventObject eo;
    private final ArrayList path = new ArrayList();
    private int pathSize = 0;
    private final boolean trace;

    public TokenReaderJson(Reader r, String opName) {
        this.opName = opName;
        this.trace = logger.isDetailTraceEnabled();
        this.sR = new JsonParser(r, opName);
    }

    @Override
    public TokenReader.State currentState() {
        int event = this.eo.getEventType();
        return this.stt2tt(event);
    }

    @Override
    public int depth() {
        return this.currentState() == TokenReader.State.END_TOKEN ? this.pathSize : this.pathSize - 1;
    }

    @Override
    public String getAttributeValue(String name) {
        return this.getAttributeValue(null, name);
    }

    @Override
    public String getAttributeValue(String uri, String name) {
        String attrValue = (String)this.eo.getAttrs().get(name);
        return attrValue;
    }

    @Override
    public String getLocalName() {
        return this.eo.getLocalName();
    }

    @Override
    public String getNamespace() {
        return "";
    }

    @Override
    public TokenReader.State next() {
        try {
            this.eo = this.sR.next();
            TokenReader.State currentState = this.currentState();
            if (currentState == TokenReader.State.START_TOKEN) {
                PathItem pathItem = new PathItem();
                pathItem.setElementName(this.getLocalName());
                pathItem.setClassId(this.getAttributeValue("classId"));
                pathItem.setObjectId(this.getAttributeValue("objectId"));
                this.pushToken(pathItem);
            } else if (currentState == TokenReader.State.END_TOKEN) {
                this.popToken();
            }
            if (this.trace) {
                this.trace();
            }
            return currentState;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, (Object[])new String[]{this.opName, this.getPath()});
        }
    }

    @Override
    public String readContent() {
        return this.eo.getContent();
    }

    @Override
    public InputStream referenceAttachment(String contentId) {
        throw new UnsupportedOperationException(this.getClass().getName() + ": referenceAttachement method is not supported.");
    }

    private TokenReader.State stt2tt(int stt) {
        switch (stt) {
            case 1: {
                return TokenReader.State.START_TOKEN;
            }
            case 2: {
                return TokenReader.State.END_TOKEN;
            }
            case 3: {
                return TokenReader.State.CONTENT;
            }
        }
        return TokenReader.State.UNKNOWN;
    }

    @Override
    public String getPath() {
        int size = this.pathSize;
        if (size == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(32 * size);
        for (int i = 0; i < size; ++i) {
            String objectId;
            if (buffer.length() > 0) {
                buffer.append('/');
            }
            PathItem pathItem = (PathItem)this.path.get(i);
            buffer.append(pathItem.getElementName());
            String classId = pathItem.getClassId();
            String string = objectId = classId == null ? null : pathItem.getObjectId();
            if (objectId == null) continue;
            buffer.append('[');
            buffer.append(classId);
            buffer.append(',');
            buffer.append(objectId);
            buffer.append(']');
        }
        return buffer.toString();
    }

    public int getJsonDepth() {
        return this.sR.getObjectDepth();
    }

    private void pushToken(PathItem toke) {
        PathItem pathToken;
        if (this.pathSize == this.path.size()) {
            pathToken = new PathItem();
            this.path.add(pathToken);
        } else {
            pathToken = (PathItem)this.path.get(this.pathSize);
        }
        ++this.pathSize;
        pathToken.setClassId(toke.getClassId());
        pathToken.setObjectId(toke.getObjectId());
        pathToken.setElementName(toke.getElementName());
    }

    private void popToken() {
        if (this.pathSize == 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.pathSize;
    }

    private void trace() {
        TokenReader.State currentState = this.currentState();
        String type = currentState.toString();
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("token=").append(type);
        if (currentState == TokenReader.State.START_TOKEN || currentState == TokenReader.State.END_TOKEN) {
            buffer.append(" name=").append(this.getLocalName());
        }
        buffer.append(" depth=").append(this.depth());
        logger.traceDetail(buffer);
    }

    @Override
    public boolean canClone() {
        return false;
    }

    @Override
    public void startCloning(OutputStream cloneToStream) {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't support input cloning.");
    }

    @Override
    public void stopCloning() {
        throw new IllegalStateException(this.getClass().getName() + " is not doing input cloning.");
    }

    static /* synthetic */ TransportLogger access$1100() {
        return logger;
    }

    private static class JsonBlock {
        private int jEventType;
        private HashMap map = new HashMap();
        private List list = new ArrayList();
        private String localName;

        public void check() {
            if (this.map.get("localName") != null && this.map.get("localName").equals("CollectionTerminator")) {
                this.setLocalName("CollectionTerminator");
                this.map.remove("localName");
            }
        }

        public void add(String string) {
            this.list.add(string);
        }

        public void put(String key, String value) {
            this.map.put(key, value);
        }

        public int getjEventType() {
            return this.jEventType;
        }

        public void setjEventType(int jEventType) {
            this.jEventType = jEventType;
        }

        public List getList() {
            return this.list;
        }

        public HashMap getMap() {
            return this.map;
        }

        public String getLocalName() {
            return this.localName == null ? "" : this.localName;
        }

        public void setLocalName(String s) {
            this.localName = s == null ? "" : ("value".equals(s) ? "Value" : s);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("map=\n");
            Iterator<Object> it = this.map.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    sb.append(",\n");
                }
                String key = (String)it.next();
                sb.append(key).append(":").append((String)this.map.get(key));
                ++i;
            }
            sb.append(",\n").append(this.localName);
            it = this.list.iterator();
            i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    sb.append(",\n");
                }
                String value = (String)it.next();
                sb.append(value);
                ++i;
            }
            return sb.toString();
        }
    }

    private static class EventObject {
        private int eventType;
        private Map attrs = new HashMap();
        private String localName;
        private String content;

        public int getEventType() {
            return this.eventType;
        }

        public void setEventType(int eventType) {
            this.eventType = eventType;
        }

        public Map getAttrs() {
            return this.attrs;
        }

        public void setAttrs(Map attrs) {
            this.attrs = attrs;
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String localName) {
            this.localName = localName;
        }

        public void setAttr(String name, String value) {
            if (this.attrs == null) {
                this.attrs = new HashMap();
            }
            this.attrs.put(name, value);
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }

    private static class JsonParser {
        private PushbackReader reader;
        private Stack stk;
        private String opName;
        private JsonBlock curBlock;
        private JsonBlock nextBlock;
        private static final int JSON_UNKNOWN = 0;
        private static final int JSON_START_OBJECT = 1;
        private static final int JSON_END_OBJECT = 2;
        private static final int JSON_START_ARRAY_OBJECT = 3;
        private static final int JSON_START_ARRAY_STRING = 4;
        private static final int JSON_END_ARRAY = 5;
        private int objectDepth;

        public JsonParser(Reader r, String operationName) {
            this.reader = new PushbackReader(r);
            this.opName = operationName;
            this.stk = new Stack();
            this.objectDepth = 0;
            this.curBlock = this._next(false);
        }

        public EventObject next() {
            Object o;
            if (!this.stk.isEmpty() && (o = this.stk.peek()) instanceof StringValueObject) {
                StringValueObject vo = (StringValueObject)o;
                EventObject eo = null;
                if (vo.getState() == 1) {
                    vo.setState(3);
                    eo = new EventObject();
                    eo.setLocalName("Value");
                    eo.setContent(vo.getContent());
                    eo.setEventType(3);
                    return eo;
                }
                if (vo.getState() == 3) {
                    vo.setState(2);
                    eo = new EventObject();
                    eo.setLocalName("Value");
                    eo.setContent(vo.getContent());
                    eo.setEventType(2);
                    return eo;
                }
                if (vo.getState() == 2) {
                    this.stk.pop();
                    if (!this.stk.isEmpty() && this.stk.peek() instanceof ListStringValueObject) {
                        StringValueObject so = ((ListStringValueObject)this.stk.peek()).getNext();
                        if (so != null) {
                            this.stk.push(so);
                            eo = new EventObject();
                            eo.setContent(so.getContent());
                            eo.setLocalName("Value");
                            eo.setEventType(1);
                            return eo;
                        }
                        this.stk.pop();
                        this.curBlock = this._next(false);
                    } else {
                        this.curBlock = this.nextBlock;
                    }
                } else {
                    vo.setState(1);
                    eo = new EventObject();
                    eo.setLocalName("Value");
                    eo.setContent(vo.getContent());
                    eo.setEventType(1);
                    return eo;
                }
            }
            int jEvent = this.curBlock.getjEventType();
            EventObject eo = null;
            switch (jEvent) {
                case 1: {
                    Object po;
                    HashMap map;
                    Object obj;
                    if (!this.stk.isEmpty() && (obj = this.stk.peek()) instanceof PropertiesObject) {
                        eo = new EventObject();
                        this.nextBlock = this._next(false);
                        map = this.nextBlock.getMap();
                        if (map.get("value") != null) {
                            String content = (String)map.get("value");
                            map.remove("value");
                            eo.setAttrs(map);
                            eo.setAttr("propertyId", this.curBlock.getLocalName());
                            eo.setEventType(1);
                            eo.setLocalName("Property");
                            StringValueObject vo = new StringValueObject();
                            vo.setDepth(this.getObjectDepth());
                            vo.setContent(content);
                            vo.setState(0);
                            this.stk.push(vo);
                            return eo;
                        }
                        eo.setAttrs(this.nextBlock.getMap());
                        eo.setLocalName("Property");
                        eo.setAttr("propertyId", this.curBlock.getLocalName());
                        eo.setEventType(1);
                        if (this.nextBlock.getjEventType() == 1 && this.nextBlock.getLocalName().equals("Value")) {
                            ValueObject vo = new ValueObject();
                            vo.setDepth(this.getObjectDepth());
                            this.stk.push(vo);
                        }
                        this.curBlock = this.nextBlock;
                        return eo;
                    }
                    this.nextBlock = this._next(false);
                    eo = new EventObject();
                    eo.setAttrs(this.nextBlock.getMap());
                    eo.setEventType(1);
                    if (this.nextBlock.getLocalName().equals("CollectionTerminator")) {
                        eo.setLocalName("CollectionTerminator");
                    } else if (!this.stk.isEmpty() && this.stk.peek() instanceof EnumValueObject && "".equals(this.curBlock.getLocalName())) {
                        eo.setLocalName("Value");
                    } else {
                        eo.setLocalName(this.curBlock.getLocalName());
                    }
                    if (this.nextBlock.getLocalName().equals("properties")) {
                        po = new PropertiesObject();
                        ((DepthTrackedObject)po).setDepth(this.getObjectDepth());
                        this.stk.push(po);
                        this.nextBlock = this._next(false);
                    }
                    this.curBlock = this.nextBlock;
                    return eo;
                }
                case 2: {
                    Object po;
                    HashMap map;
                    Object obj;
                    if (!this.stk.isEmpty() && (po = this.stk.peek()) instanceof PropertiesObject && ((PropertiesObject)po).getDepth() == this.getObjectDepth() + 1) {
                        this.stk.pop();
                        this.curBlock = this._next(false);
                        return this.next();
                    }
                    eo = new EventObject();
                    eo.setEventType(2);
                    if (!this.stk.isEmpty()) {
                        obj = (DepthTrackedObject)this.stk.peek();
                        if (obj instanceof ValueObject) {
                            eo.setLocalName("Value");
                        } else if (obj instanceof PropertiesObject) {
                            eo.setLocalName("Property");
                        } else if (obj instanceof EnumValueObject) {
                            eo.setLocalName("Value");
                        } else {
                            throw new UnsupportedOperationException(this.getClass().getName() + " unkonwn object type on stack: " + obj.getClass().getName());
                        }
                        if (((DepthTrackedObject)obj).getDepth() == this.getObjectDepth() + 1) {
                            map = this.stk.pop();
                        }
                    }
                    this.curBlock = this._next(false);
                    return eo;
                }
                case 4: {
                    this.nextBlock = this._next(true);
                    List list = this.nextBlock.getList();
                    Collections.reverse(list);
                    ListStringValueObject lvo = new ListStringValueObject(list);
                    lvo.setDepth(this.getObjectDepth());
                    StringValueObject so = lvo.getNext();
                    this.stk.push(lvo);
                    this.stk.push(so);
                    eo = new EventObject();
                    eo.setContent(so.getContent());
                    eo.setLocalName("Value");
                    eo.setEventType(1);
                    return eo;
                }
                case 3: {
                    EnumValueObject ev = new EnumValueObject();
                    ev.setDepth(this.getObjectDepth());
                    this.stk.push(ev);
                    this.curBlock = this._next(false);
                    this.curBlock.setLocalName("Value");
                    return this.next();
                }
                case 5: {
                    if (this.stk.isEmpty() || !(this.stk.peek() instanceof EnumValueObject) || ((EnumValueObject)this.stk.peek()).getDepth() != this.getObjectDepth()) {
                        throw new IllegalStateException(this.getClass().getName() + " JSON_END_ARRAY doesn't match.");
                    }
                    this.stk.pop();
                    this.curBlock = this._next(false);
                    return this.next();
                }
            }
            throw new IllegalStateException(this.getClass().getName() + " unkonwn Json event.");
        }

        private int getObjectDepth() {
            return this.objectDepth;
        }

        /*
         * Unable to fully structure code
         */
        private JsonBlock _next(boolean readStringList) {
            sb = new StringBuilder();
            eType = 0;
            block = new JsonBlock();
            key = null;
            value = null;
lbl6:
            // 2 sources

            try {
                while ((c = this.reader.read()) != -1) {
                    block37: {
                        if (c == 13 || c == 10 || c == 9 || c == 32 || c == 12) continue;
                        if (c != 34) break block37;
                        escape = true;
                        while ((c = this.reader.read()) != 34 || c == 34 && escape && sb.length() > 0 && sb.charAt(sb.length() - 1) == '\\') {
                            if (c == 92) {
                                nextChar = this.reader.read();
                                switch (nextChar) {
                                    case 98: {
                                        sb.append('\b');
                                        break;
                                    }
                                    case 114: {
                                        sb.append('\r');
                                        break;
                                    }
                                    case 110: {
                                        sb.append('\n');
                                        break;
                                    }
                                    case 102: {
                                        sb.append('\f');
                                        break;
                                    }
                                    case 116: {
                                        sb.append('\t');
                                        break;
                                    }
                                    case 92: {
                                        sb.append('\\');
                                        escape = false;
                                        break;
                                    }
                                    case 47: {
                                        sb.append('/');
                                        break;
                                    }
                                    case 34: {
                                        sb.append('\"');
                                        break;
                                    }
                                    case 39: {
                                        sb.append('\'');
                                        break;
                                    }
                                    case 117: {
                                        ubuf = new StringBuilder();
                                        for (iu = 0; iu < 4; ++iu) {
                                            ubuf.append((char)this.reader.read());
                                        }
                                        u = (char)Integer.parseInt(ubuf.toString(), 16);
                                        sb.append(u);
                                        break;
                                    }
                                    default: {
                                        sb.append('\\').append(nextChar);
                                    }
                                }
                                if (nextChar == 92) continue;
                                escape = true;
                                continue;
                            }
                            sb.append((char)c);
                            escape = true;
                        }
                        ** GOTO lbl6
                    }
                    if (c == 58) {
                        key = sb.toString();
                        sb = new StringBuilder();
                        nc = this.nextNonWhiteChar();
                        if (nc == 34) {
                            value = "";
                        }
                        this.reader.unread(nc);
                        continue;
                    }
                    if (c == 44) {
                        if (readStringList) {
                            block.add(sb.toString());
                            sb = new StringBuilder();
                            continue;
                        }
                        value = sb.toString();
                        sb = new StringBuilder();
                        block.put(key, value);
                        key = null;
                        value = null;
                        continue;
                    }
                    if (c == 123) {
                        eType = 1;
                        ++this.objectDepth;
                        block.setjEventType(eType);
                        break;
                    }
                    if (c == 91) {
                        n = this.nextNonWhiteChar();
                        if (n == 123) {
                            eType = 3;
                        } else if (n == 34) {
                            eType = 4;
                        } else if (n == 93) {
                            eType = readStringList != false ? 4 : 3;
                        } else {
                            throw new IllegalStateException(this.getClass().getName() + " unknown char encountered after [, char is " + (char)n);
                        }
                        this.reader.unread(n);
                        block.setjEventType(eType);
                        break;
                    }
                    if (c == 125) {
                        --this.objectDepth;
                        eType = 2;
                        block.setjEventType(eType);
                        break;
                    }
                    if (c == 93) {
                        eType = 5;
                        block.setjEventType(eType);
                        break;
                    }
                    sb.append((char)c);
                }
            }
            catch (IOException e) {
                throw Util.ereOrIoeS(e, new String[]{this.opName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
            }
            if (readStringList) {
                block.add(sb.toString());
            } else if (value == null) {
                block.setLocalName(key == null ? "" : key);
            } else {
                block.put(key, sb.toString());
            }
            block.check();
            TokenReaderJson.access$1100().traceDetail(block.toString());
            return block;
        }

        private int nextNonWhiteChar() throws IOException {
            int c = -1;
            while ((c = this.reader.read()) != -1 && (c == 13 || c == 10 || c == 9 || c == 32) && c != 12) {
            }
            return c;
        }

        private static class ListStringValueObject
        extends DepthTrackedObject {
            private List list;

            public ListStringValueObject(List list) {
                this.list = list;
            }

            public StringValueObject getNext() {
                if (this.list.size() < 1) {
                    return null;
                }
                String value = (String)this.list.remove(this.list.size() - 1);
                StringValueObject so = new StringValueObject();
                so.setContent(value);
                so.setState(1);
                return so;
            }
        }

        private static class StringValueObject
        extends DepthTrackedObject {
            private String content;
            private int state;

            private StringValueObject() {
            }

            public int getState() {
                return this.state;
            }

            public void setState(int state) {
                this.state = state;
            }

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }
        }

        private static class EnumValueObject
        extends DepthTrackedObject {
            private EnumValueObject() {
            }
        }

        private static class ValueObject
        extends DepthTrackedObject {
            private ValueObject() {
            }
        }

        private static class PropertiesObject
        extends DepthTrackedObject {
            private PropertiesObject() {
            }
        }

        private static class DepthTrackedObject {
            private int depth;

            private DepthTrackedObject() {
            }

            public void setDepth(int depth) {
                this.depth = depth;
            }

            public int getDepth() {
                return this.depth;
            }
        }
    }

    private static class PathItem {
        private String elementName;
        private String classId;
        private String objectId;

        public PathItem() {
        }

        public PathItem(String elementName, String classId, String objectId) {
            this.elementName = elementName;
            this.classId = classId;
            this.objectId = objectId;
        }

        private String getElementName() {
            return this.elementName;
        }

        private String getClassId() {
            return this.classId;
        }

        private String getObjectId() {
            return this.objectId;
        }

        private void setElementName(String elementName) {
            this.elementName = elementName;
        }

        private void setClassId(String classId) {
            this.classId = classId;
        }

        private void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }
}

