/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.comm;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.transport.comm.StorageDeviceRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.comm.CommSerialization;
import java.util.LinkedList;

public class StorageDeviceRequestSerialization
extends CommSerialization {
    public static final StorageDeviceRequestSerialization INSTANCE = new StorageDeviceRequestSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        Id[] storageDeviceIds;
        super.serialize(object, context);
        StorageDeviceRequest request = (StorageDeviceRequest)object;
        context.writeAttribute("storageAreaId", Util.toIdString(request.getStorageAreaId()));
        context.writeAttribute("contentId", Util.toIdString(request.getContentId()));
        if (request.getHashSequence() != null) {
            context.writeAttribute("hashSequence", Util.toUnsignedLongString(request.getHashSequence()));
        }
        if ((storageDeviceIds = request.getStorageDeviceId()) != null && storageDeviceIds.length > 0) {
            for (int i = 0; i < storageDeviceIds.length; ++i) {
                String externalIdentity = request.getExternalIdentity(storageDeviceIds[i]);
                if (externalIdentity == null) {
                    context.writeElement("StorageDeviceId", null, Util.toIdString(storageDeviceIds[i]));
                    continue;
                }
                context.enterElement("StorageDeviceId");
                context.writeAttribute("externalIdentity", externalIdentity);
                context.writeContent(Util.toIdString(storageDeviceIds[i]));
                context.leaveElement();
            }
        }
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        super.deserialize(object, context);
        StorageDeviceRequest request = (StorageDeviceRequest)object;
        Id storageAreaId = Util.parseId(context.getAttribute("storageAreaId"));
        request.setStorageAreaId(storageAreaId);
        Id contentId = Util.parseId(context.getAttribute("contentId"));
        request.setContentId(contentId);
        Long contentHash = Util.parseLong(context.getAttribute("hashSequence"));
        request.setHashSequence(contentHash);
        context.nextElementToken();
        LinkedList<Id> storageDeviceIds = new LinkedList<Id>();
        while (context.isStartToken("StorageDeviceId")) {
            String externalIdentity = context.getAttribute("externalIdentity");
            String storageDeviceIdStr = context.readElement();
            Id storageDeviceId = new Id(storageDeviceIdStr);
            storageDeviceIds.add(storageDeviceId);
            if (externalIdentity == null) continue;
            request.setExternalIdentity(storageDeviceId, externalIdentity);
        }
        request.setStorageDeviceId(storageDeviceIds.toArray(new Id[0]));
        return null;
    }
}

