/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.core;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertiesSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.reference.ReferenceValues;

public class EngineObjectSerialization
extends Serialization {
    public static final EngineObjectSerialization INSTANCE = new EngineObjectSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        EngineObjectImpl value = (EngineObjectImpl)object;
        this.serialize(value, true, context);
    }

    public void serialize(EngineObjectImpl value, boolean sendXsiType, SerializerContext context) throws Exception {
        boolean sendProperties = true;
        ObjectReferenceBase reference = (ObjectReferenceBase)value.getObjectReference();
        if (reference instanceof DependentIdentity) {
            if (sendXsiType) {
                context.writeSchemaType("DependentObjectType");
            }
            context.writeAttribute("classId", ((DependentIdentity)reference).getClassIdentity());
        } else {
            if (sendXsiType) {
                context.writeSchemaType("ObjectValue");
            }
            ReferenceValues referenceValues = context.getReferenceValues(reference);
            context.writeAttribute("classId", referenceValues.classId);
            context.writeAttribute("objectId", referenceValues.objectId);
            context.writeAttribute("objectStore", referenceValues.objectStore);
            context.writeAttribute("updateSequenceNumber", Util.toIntString(value.getUpdateSequenceNumber()));
            context.writeAttribute("accessAllowed", Util.toIntString(value.getInternalAccessAllowed()));
            sendProperties = context.addObject(value);
        }
        context.writeAttribute("superClasses", Util.toStringList(value.getSuperClasses()));
        if (sendProperties) {
            PropertiesSerialization.INSTANCE.serialize(value, context);
        } else if (context.getVersion() >= 400) {
            context.writeAttribute("serializationDuplicate", "1");
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = (PropertyDeserializerCall)object;
        String classId = Util.emptyAsNull(context.getAttribute("classId"));
        String objectId = Util.emptyAsNull(context.getAttribute("objectId"));
        String objectStore = Util.emptyAsNull(context.getAttribute("objectStore"));
        Integer updateSequenceNumber = Util.parseInteger(context.getAttribute("updateSequenceNumber"));
        Integer accessAllowed = Util.parseInteger(context.getAttribute("accessAllowed"));
        String[] superClasses = Util.parseStringList(context.getAttribute("superClasses"));
        Boolean duplicate = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("serializationDuplicate")));
        EngineObjectImpl value = Util.createEngineObject(context.getConnection(), call.request, Util.reference(call.parent), call.propertyId, call.propertyIndex, classId, superClasses, objectId, objectStore);
        value.setUpdateSequenceNumber(updateSequenceNumber);
        value.setInternalAccessAllowed(accessAllowed);
        value.setSuperClasses(superClasses);
        EngineObjectImpl resolved = value;
        if (duplicate.booleanValue()) {
            resolved = context.resolveObject(value);
        } else {
            context.addObject(value);
        }
        if (Util.isStartToken(context.nextElementToken())) {
            PropertiesSerialization.INSTANCE.deserialize(new PropertyDeserializerCall(call, value), context);
        }
        if (resolved != value) {
            return resolved;
        }
        value.setDirty(false);
        return value;
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        String classId = json.getString("classId");
        String objectId = json.getString("objectId");
        String objectStore = json.getString("objectStore");
        Integer updateSequenceNumber = Util.parseInteger(json.getString("updateSequenceNumber"));
        Integer accessAllowed = Util.parseInteger(json.getString("accessAllowed"));
        String[] superClasses = Util.parseStringList(json.getString("superClasses"));
        EngineObjectImpl value = Util.createEngineObject(connection, call.request, Util.reference(call.parent), call.propertyId, call.propertyIndex, classId, superClasses, objectId, objectStore);
        value.setUpdateSequenceNumber(updateSequenceNumber);
        value.setInternalAccessAllowed(accessAllowed);
        value.setSuperClasses(superClasses);
        JSONObject jsonProps = (JSONObject)json.get("properties");
        if (jsonProps != null) {
            PropertiesSerialization.INSTANCE.deserializeJson(connection, jsonProps, "properties", hasDeltas, new PropertyDeserializerCall(call, value));
        }
        value.setDirty(false);
        return value;
    }
}

