/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.core;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ErrorRecord;
import com.filenet.api.exception.ErrorStack;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.wsi.ExceptionCodeMapper;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class ExceptionSerialization
extends Serialization {
    public static final ExceptionSerialization INSTANCE = new ExceptionSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws IOException {
        this.serialize(object, context, "ErrorStackType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialize(Object object, SerializerContext context, String stackType) throws IOException {
        ErrorStack errorStack;
        EngineRuntimeException exception = (EngineRuntimeException)object;
        Locale requestLocale = context.getRequestLocale();
        if (requestLocale == null) {
            requestLocale = Locale.getDefault();
        }
        Locale oldLocale = UserContext.get().getLocale();
        try {
            UserContext.get().setLocale(requestLocale);
            errorStack = exception.getAsErrorStack();
        }
        finally {
            UserContext.get().setLocale(oldLocale);
        }
        context.writeOptionalSchemaType(stackType);
        context.writeElement("ErrorName", context.getOptionalSchemaType("ErrorNameType"), ExceptionCodeMapper.toErrorNameString(errorStack.getExceptionCode(), context.getVersion()));
        ErrorRecord[] records = errorStack.getErrorRecords();
        for (int i = 0; i < records.length; ++i) {
            ErrorRecord record = records[i];
            context.enterElement("ErrorRecord", context.getOptionalSchemaType("ErrorRecordType"));
            context.writeOptionalElement("Source", context.getOptionalXsdType("string"), record.getSource());
            String desc = record.getDescription();
            if (!XMLHelper.isValidText(desc)) {
                desc = XMLHelper.encodeText(desc);
            }
            context.writeOptionalElement("Description", context.getOptionalXsdType("string"), desc);
            HashMap types = record.getDiagnosticTypes();
            this.writeOneDiagnosticElement(context, types, "exceptionCode");
            this.writeOneDiagnosticElement(context, types, "stackTrace");
            this.writeOneDiagnosticElement(context, types, "failedBatchItem");
            context.leaveElement();
        }
        context.leaveElement();
    }

    private void writeOneDiagnosticElement(SerializerContext context, Map types, String diagnosticType) throws IOException {
        Object value = types.get(diagnosticType);
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            value = "" + value;
        }
        context.enterElement("Diagnostic", context.getOptionalSchemaType("DiagnosticType"));
        context.writeAttribute("diagnosticType", diagnosticType);
        context.writeContent((String)value);
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        context.nextStartToken();
        String errorName = context.readElement();
        boolean codeFound = false;
        ArrayList<ErrorRecord> errorRecords = new ArrayList<ErrorRecord>();
        while (context.isStartToken("ErrorRecord")) {
            if (Util.isEndToken(context.nextElementToken())) {
                context.nextElementToken();
                continue;
            }
            String source = context.readElement("Source");
            String description = context.readElement("Description");
            LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
            while (context.isStartToken("Diagnostic")) {
                String type = Util.emptyAsNull(context.getAttribute("diagnosticType"));
                String value = Util.emptyAsNull(context.readElement());
                if (type == null || value == null) continue;
                types.put(type, value);
                if (codeFound || !type.equals("exceptionCode")) continue;
                codeFound = true;
                errorName = value;
            }
            context.nextElementToken();
            errorRecords.add(new ErrorRecord(source, description, types));
        }
        context.checkEndToken();
        ErrorRecord[] recordArray = errorRecords.toArray(new ErrorRecord[errorRecords.size()]);
        ErrorStack errorStack = new ErrorStack(errorName, recordArray);
        return new EngineRuntimeException(errorStack);
    }
}

