/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.transport.ContentResponse;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.transport.GetContentResponse;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;
import com.filenet.apiimpl.wsi.serialization.property.ContentSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.util.ArrayList;

public class GetContentResponseSerialization
extends Serialization {
    public static final GetContentResponseSerialization INSTANCE = new GetContentResponseSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        ContentResponse[] batch = ((GetContentResponse)object).getBatch();
        for (int i = 0; i < batch.length; ++i) {
            ContentResponse response = batch[i];
            context.enterElement("ContentResponse", null);
            context.writeAttribute("id", response.getCorrelationId());
            if (response.getValue() instanceof EngineRuntimeException) {
                context.writeSchemaType("ContentErrorResponse");
                context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, response.getValue());
            } else {
                context.writeSchemaType("ContentElementResponse");
                ClientInputStream cis = response.getClientInputStream();
                if (cis != null) {
                    String retrievalName = response.getRetrievalName();
                    if (!XMLHelper.isValidText(retrievalName)) {
                        retrievalName = XMLHelper.encodeText(retrievalName);
                    }
                    context.writeAttribute("retrievalName", retrievalName);
                    context.writeAttribute("totalSize", Util.toUnsignedLongString(cis.getTotalSize()));
                    context.writeAttribute("bufferedSize", Util.toIntString(cis.getBufferedSize()));
                    context.writeAttribute("continueFrom", cis.getContinueFrom());
                    context.serializeReference("SourceSpecification", cis.getSource());
                    context.enterElement("ElementSpecification", null);
                    context.writeAttribute("elementSequenceNumber", Util.toIntString(cis.getElementSequenceNumber()));
                    context.leaveElement();
                    context.enterElement("Content", null);
                    ContentSerialization.INSTANCE.serializeStream(context, cis.getContentAsStream());
                    context.leaveElement();
                }
            }
            context.leaveElement();
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        GetContentRequest gcr = (GetContentRequest)context.getRequest();
        boolean validateOnly = gcr.getValidateOnly();
        ArrayList<ContentResponse> responses = new ArrayList<ContentResponse>();
        while (true) {
            if (!Util.isStartToken(context.nextElementToken())) break;
            String correlectionId = Util.emptyAsNull(context.getAttribute("id"));
            ContentResponse response = new ContentResponse();
            response.setCorrelationId(correlectionId);
            String type = context.getXsiType();
            Object value = null;
            if (type.equals("ContentErrorResponse")) {
                context.nextElementToken();
                value = context.deserializeObject("ErrorStack", ExceptionSerialization.INSTANCE, null);
            } else if (type.equals("ContentElementResponse")) {
                String retrievalName = context.getAttribute("retrievalName");
                response.setRetrievalName(retrievalName);
                String continueFrom = context.getAttribute("continueFrom");
                Long totalSize = Util.parseLong(context.getAttribute("totalSize"));
                Integer bufferedSize = Util.parseInteger(context.getAttribute("bufferedSize"));
                context.nextElementToken();
                ObjectReferenceBase source = (ObjectReferenceBase)context.deserializeObject("SourceSpecification", ObjectReferenceSerialization.INSTANCE, null);
                Integer elementSequenceNumber = null;
                if (context.isStartToken("ElementSpecification")) {
                    elementSequenceNumber = Util.parseInteger(context.getAttribute("elementSequenceNumber"));
                    context.nextElementToken();
                    context.checkEndToken();
                    context.nextElementToken();
                } else if (!validateOnly) {
                    context.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, "ElementSpecification");
                }
                if (context.isStartToken("Content")) {
                    if (!validateOnly) {
                        value = ContentSerialization.INSTANCE.deserializeStream(context, (ConnectionImpl)context.getConnection(), source, elementSequenceNumber, continueFrom, totalSize, bufferedSize);
                    } else {
                        context.nextElementToken();
                    }
                    context.checkEndToken();
                    context.nextElementToken();
                }
            } else {
                context.throwException(ExceptionCode.TRANSPORT_WSI_INVALID_CONTENT_RESPONSE_TYPE, type);
            }
            response.putValue(value);
            context.checkEndToken();
            responses.add(response);
        }
        context.checkEndToken();
        ContentResponse[] batch = responses.toArray(new ContentResponse[responses.size()]);
        return new GetContentResponse(batch);
    }
}

