/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.GetObjectRequest;
import com.filenet.apiimpl.transport.ObjectRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.FilterSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.util.ArrayList;

public class GetObjectsRequestSerialization
extends Serialization {
    public static final GetObjectsRequestSerialization INSTANCE = new GetObjectsRequestSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        GetObjectRequest requests = (GetObjectRequest)object;
        ObjectRequest[] batch = requests.getBatch();
        for (int i = 0; i < batch.length; ++i) {
            ObjectRequest request = batch[i];
            ObjectReferenceBase reference = request.getObjectReference();
            context.enterElement("ObjectRequest", context.getOptionalSchemaType("ObjectRequestType"));
            context.writeAttribute("id", request.getCorrelationId());
            context.writeAttribute("cacheAllowed", Util.toBooleanString(request.getCacheAllowed()));
            context.writeAttribute("maxElements", Util.toIntString(request.getMaxElements()));
            context.writeAttribute("continueFrom", request.getContinueFrom());
            context.serializeObject("SourceSpecification", Util.objectClass(reference), (Object)reference);
            context.serializeObject("PropertyFilter", FilterSerialization.INSTANCE, (Object)request.getPropertyFilter());
            context.leaveElement();
        }
        context.leaveElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        ArrayList<ObjectRequest> requests = new ArrayList<ObjectRequest>();
        while (true) {
            if (!Util.isStartToken(context.nextElementToken())) {
                context.checkEndToken();
                ObjectRequest[] batch = requests.toArray(new ObjectRequest[requests.size()]);
                return new GetObjectRequest(batch);
            }
            String correlationId = context.getAttribute("id");
            Boolean cacheAllowed = Util.nullAsTrue(Util.parseBoolean(context.getAttribute("cacheAllowed")));
            Integer maxElements = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("maxElements")));
            String continueFrom = context.getAttribute("continueFrom");
            if (Util.isEndToken(context.nextElementToken())) {
                context.nextElementToken();
                continue;
            }
            ObjectReferenceBase reference = (ObjectReferenceBase)context.deserializeObject("SourceSpecification", ObjectReferenceSerialization.INSTANCE, null);
            PropertyFilter refreshFilter = (PropertyFilter)context.deserializeObject("PropertyFilter", FilterSerialization.INSTANCE, null);
            ObjectRequest request = new ObjectRequest(reference, refreshFilter, cacheAllowed, correlationId, maxElements, continueFrom);
            requests.add(request);
        }
    }
}

