/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.property.PropertyBooleanImpl;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;

public class BooleanSerialization
extends PropertySerialization {
    public static final BooleanSerialization INSTANCE = new BooleanSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = this.enter("SingletonBoolean", object, context);
        context.writeOptionalElement("Value", context.getOptionalXsdType("boolean"), Util.toBooleanString(call.property.getBooleanValue()));
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyBooleanImpl property = new PropertyBooleanImpl(call.propertyId, Util.parseBoolean(this.getValueText(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        String value = json.getString("value");
        PropertyBooleanImpl property = new PropertyBooleanImpl(call.propertyId, Util.parseBoolean(value), call.propertyAccess);
        return this.respond(property, call);
    }
}

