/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.FilterElementSerialization;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FilterSerialization
extends Serialization {
    public static final FilterSerialization INSTANCE = new FilterSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertyFilter filter = (PropertyFilter)object;
        context.writeOptionalSchemaType("PropertyFilterType");
        context.writeAttribute("maxRecursion", Util.toIntString(filter.getMaxRecursion()));
        context.writeAttribute("maxSize", Util.toUnsignedLongString(filter.getMaxSize()));
        context.writeAttribute("maxElements", Util.toIntString(filter.getPageSize()));
        if (context.getVersion() >= 400) {
            context.writeAttribute("levelDependents", Util.toBooleanString(filter.getLevelDependents()));
        }
        context.serializeObjectArray("IncludeProperties", FilterElementSerialization.INSTANCE, (Object[])filter.getIncludeProperties());
        context.serializeObjectArray("IncludeTypes", FilterElementSerialization.INSTANCE, (Object[])filter.getIncludeTypes());
        context.writeOptionalElementArray("ExcludeProperties", context.getOptionalXsdType("string"), filter.getExcludeProperties());
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        Integer maxRecursion = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("maxRecursion")));
        Long maxSize = Util.parseLong(context.getAttribute("maxSize"));
        Integer pageSize = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("maxElements")));
        Boolean levelDependents = Util.parseBoolean(context.getAttribute("levelDependents"));
        List includeProperties = Collections.EMPTY_LIST;
        List includeTypes = Collections.EMPTY_LIST;
        List excludeProperties = Collections.EMPTY_LIST;
        if (Util.isStartToken(context.nextElementToken())) {
            includeProperties = context.deserializeObjectList("IncludeProperties", FilterElementSerialization.INSTANCE, null);
            includeTypes = context.deserializeObjectList("IncludeTypes", FilterElementSerialization.INSTANCE, null);
            excludeProperties = context.readElementList("ExcludeProperties");
        }
        context.checkEndToken();
        PropertyFilter filter = new PropertyFilter();
        Iterator i = includeProperties.iterator();
        while (i.hasNext()) {
            filter.addIncludeProperty((FilterElement)i.next());
        }
        i = includeTypes.iterator();
        while (i.hasNext()) {
            filter.addIncludeType((FilterElement)i.next());
        }
        i = excludeProperties.iterator();
        while (i.hasNext()) {
            filter.addExcludeProperty((String)i.next());
        }
        filter.setMaxRecursion(maxRecursion);
        filter.setMaxSize(maxSize);
        filter.setPageSize(pageSize);
        filter.setLevelDependents(levelDependents);
        return filter;
    }
}

