/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.property.PropertyIdImpl;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;

public class IdSerialization
extends PropertySerialization {
    public static final IdSerialization INSTANCE = new IdSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = this.enter("SingletonId", object, context);
        context.writeOptionalElement("Value", context.getOptionalSchemaType("GuidType"), Util.toIdString(call.property.getIdValue()));
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyIdImpl property = new PropertyIdImpl(call.propertyId, Util.parseId(this.getValueText(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        String value = json.getString("value");
        PropertyIdImpl property = new PropertyIdImpl(call.propertyId, Util.parseId(value), call.propertyAccess);
        return this.respond(property, call);
    }
}

