/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.collection.Integer32ListImpl;
import com.filenet.apiimpl.property.PropertyInteger32ListImpl;
import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import java.util.ArrayList;

public class Integer32ListSerialization
extends PropertySerialization {
    public static final Integer32ListSerialization INSTANCE = new Integer32ListSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        this.serializeList("ListOfInteger32", context.getOptionalXsdType("int"), object, context);
    }

    @Override
    protected String toString(Object value) {
        return Util.toIntString((Integer)value);
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyInteger32ListImpl property = new PropertyInteger32ListImpl(call.propertyId, new Integer32ListImpl(this.readList(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    protected Object parseValue(String text) {
        return Util.parseInteger(text);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        ArrayList<Integer> values = new ArrayList<Integer>();
        JSONArray jsonVals = (JSONArray)json.get("value");
        if (jsonVals != null) {
            for (int i = 0; i < jsonVals.size(); ++i) {
                values.add(Util.parseInteger(jsonVals.getString(i)));
            }
        }
        PropertyInteger32ListImpl property = new PropertyInteger32ListImpl(call.propertyId, new Integer32ListImpl(values), call.propertyAccess);
        return this.respond(property, call);
    }
}

