/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.util.ClassKey;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import com.filenet.apiimpl.wsi.serialization.property.UnevaluatedValueSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;

public class ObjectSerialization
extends PropertySerialization {
    public static final ObjectSerialization INSTANCE = new ObjectSerialization();
    public static final Serialization OBJECT_VALUE = new Serialization(){

        @Override
        public void serialize(Object object, SerializerContext context) throws Exception {
            PropertySerializerCall call = (PropertySerializerCall)object;
            EngineObjectSerialization.INSTANCE.serialize(call.property.getInstanceValue(), context);
        }
    };
    public static final Serialization REFERENCE_VALUE = new Serialization(){

        @Override
        public void serialize(Object object, SerializerContext context) throws Exception {
            PropertySerializerCall call = (PropertySerializerCall)object;
            ObjectReferenceBase reference = (ObjectReferenceBase)call.property.getInstanceValue();
            if (reference instanceof UnevaluatedPropertyValue) {
                UnevaluatedValueSerialization.INSTANCE.serialize(object, context);
            } else {
                context.serializeReference(reference);
            }
        }

        @Override
        public Object deserialize(Object object, DeserializerContext context) throws Exception {
            EngineObjectImpl cached;
            Boolean duplicate = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("serializationDuplicate")));
            ObjectReferenceBase reference = (ObjectReferenceBase)ObjectReferenceSerialization.INSTANCE.deserialize(object, context);
            if (duplicate.booleanValue() && (cached = context.getObject(reference)) != null) {
                return cached;
            }
            return reference;
        }

        @Override
        public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
            return ObjectReferenceSerialization.INSTANCE.deserializeJson(connection, json, name, hasDeltas, call);
        }
    };
    public static final Serialization RETRIEVAL_ERROR = new Serialization(){

        @Override
        public void serialize(Object object, SerializerContext context) throws Exception {
            PropertySerializerCall call = (PropertySerializerCall)object;
            context.writeSchemaType("RetrievalError");
            context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, call.property.getInstanceValue());
            context.leaveElement();
        }

        @Override
        public Object deserialize(Object object, DeserializerContext context) throws Exception {
            context.nextStartToken();
            return context.deserializeObject(ExceptionSerialization.INSTANCE, null);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = this.enter("SingletonObject", object, context);
        Object value = call.property.getInstanceValue();
        if (value != null) {
            if (value instanceof EngineObjectImpl) {
                EngineObjectImpl eo = (EngineObjectImpl)value;
                ObjectReferenceBase ref = (ObjectReferenceBase)eo.getObjectReference();
                if (context.isServerProcessing() && (call.property.getPropertyName().equals("SourceObject") || call.property.getPropertyName().equals("OriginalObject"))) {
                    DuplicateObjectCache origDupObjCache = context.getDuplicateObjectCache();
                    try {
                        context.clearObjects();
                        context.serializeObject("Value", OBJECT_VALUE, (Object)call);
                    }
                    finally {
                        context.setDuplicateObjectCache(origDupObjCache);
                    }
                } else if (!(ref instanceof DependentIdentity) && (context.isClientProcessing() || context.getObject(ref) != null)) {
                    context.enterElement("Value");
                    if (context.isServerProcessing() && context.getVersion() >= 400) {
                        context.writeAttribute("serializationDuplicate", "1");
                    }
                    context.serializeReference(ref);
                } else {
                    context.serializeObject("Value", OBJECT_VALUE, (Object)call);
                }
            } else {
                context.serializeObject("Value", new ClassKey("SingletonObject", value.getClass()), (Object)call);
            }
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        Object value = null;
        if (context.isStartToken()) {
            value = context.deserializeObject(context.getXsiType(), (Object)call);
        }
        PropertyEngineObjectImpl property = new PropertyEngineObjectImpl(call.propertyId, call.propertyAccess);
        property.setConnection(context.getConnection());
        property.setInstanceValue(value);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        Object value = null;
        JSONObject jsonVal = (JSONObject)json.get("value");
        if (jsonVal != null) {
            value = ObjectReferenceSerialization.INSTANCE.deserializeJson(connection, jsonVal, "value", hasDeltas, call);
        }
        PropertyEngineObjectImpl property = new PropertyEngineObjectImpl(call.propertyId, call.propertyAccess);
        property.setConnection(connection);
        property.setInstanceValue(value);
        return this.respond(property, call);
    }
}

