/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.constants.MergeMode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.meta.SearchScopeIdentity;
import com.filenet.apiimpl.query.MergedScope;
import com.filenet.apiimpl.query.ObjectStoreScope;
import com.filenet.apiimpl.query.SearchScope;
import com.filenet.apiimpl.transport.ObjectRequest;
import java.util.ArrayList;

public class PropertyDeserializerCall {
    public ObjectReferenceBase request;
    public PropertyFilter filter;
    public Integer maxElements;
    public EngineObjectImpl parent;
    public String propertyId;
    public byte propertyAccess;
    public Integer propertyIndex;

    public PropertyDeserializerCall(ObjectRequest request) {
        this.request = request.getObjectReference();
        this.filter = request.getPropertyFilter();
        this.maxElements = request.getMaxElements();
    }

    public PropertyDeserializerCall(PropertyDeserializerCall context, EngineObjectImpl parent) {
        this.parent = parent;
        this.filter = context.filter;
        this.maxElements = context.maxElements;
    }

    public PropertyDeserializerCall(ObjectReferenceBase reference) {
        this.request = reference;
    }

    public PropertyDeserializerCall(SearchScope scope, PropertyFilter filter) {
        MergeMode mergeMode = PropertyDeserializerCall.getMergeMode(scope);
        GlobalIdentity[] objectStores = PropertyDeserializerCall.getObjectStores(scope);
        this.request = new SearchScopeIdentity(null, null, objectStores, mergeMode);
        this.filter = filter;
    }

    private static MergeMode getMergeMode(SearchScope searchScope) {
        if (searchScope instanceof MergedScope) {
            MergedScope ms = (MergedScope)searchScope;
            return ms.getMergeMode();
        }
        return null;
    }

    private static GlobalIdentity[] getObjectStores(SearchScope searchScope) {
        if (searchScope instanceof ObjectStoreScope) {
            ObjectStoreScope oss = (ObjectStoreScope)searchScope;
            return new GlobalIdentity[]{oss.getObjectStore()};
        }
        if (searchScope instanceof MergedScope) {
            MergedScope ms = (MergedScope)searchScope;
            SearchScope[] ss = ms.getComponentScope();
            ArrayList<GlobalIdentity> objectStores = new ArrayList<GlobalIdentity>();
            if (ss != null && ss.length > 0) {
                for (int lp = 0; lp < ss.length; ++lp) {
                    GlobalIdentity[] ostores;
                    SearchScope s = ss[lp];
                    if (s instanceof ObjectStoreScope) {
                        ObjectStoreScope o = (ObjectStoreScope)s;
                        objectStores.add(o.getObjectStore());
                        continue;
                    }
                    if (!(s instanceof MergedScope) || (ostores = PropertyDeserializerCall.getObjectStores(s)) == null || ostores.length <= 0) continue;
                    for (int x = 0; x < ostores.length; ++x) {
                        objectStores.add(ostores[x]);
                    }
                }
            }
            return objectStores.toArray(new GlobalIdentity[objectStores.size()]);
        }
        return null;
    }
}

